
/*******************************************
****     64 bit I/O library for BCB     ****
**** (c) 2005-2020, Alessandro Pedretti ****
*******************************************/

/*
 * WARNING: The library doesn't work if the RTL is
 * linked dynamically.
 */


#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <errno.h>

#include "io64.h"


/**** fgetpos64() ****/

int IO64_FASTCALL fgetpos64(FILE *Stream, fpos64_t *Position)
{
  return fgetpos(Stream, Position);
}


/**** fseeko64() ****/

int IO64_FASTCALL fseeko64(FILE *Stream, off64_t Offset, int Whence)
{
  fpos64_t    Pos;

  if (Whence == SEEK_CUR) {
    if (fgetpos(Stream, &Pos)) return (-1);
    Pos += (fpos64_t)Offset;
  } else if (Whence == SEEK_END)
    Pos = (fpos64_t) (_filelengthi64(_fileno(Stream)) + Offset);
  else if (Whence == SEEK_SET)
    Pos = (fpos64_t)Offset;
  else {
    errno = EINVAL;
    return (-1);
  }

  return fsetpos(Stream, &Pos);
}


/**** fsetpos64() ****/

int IO64_FASTCALL fsetpos64(FILE *Stream, const fpos64_t *Position)
{
  return fsetpos(Stream, Position);
}


/**** ftello64() ****/

off64_t IO64_FASTCALL ftello64(FILE *Stream)
{
  fpos64_t    Pos;

  if (fgetpos(Stream, &Pos)) return -1LL;

  return ((off64_t)Pos);
}
