
/*******************************************
****         64 bit I/O library         ****
**** (c) 2005-2020, Alessandro Pedretti ****
*******************************************/

/**** Create a large test file ****/


#include <stdio.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  pragma argsused
#endif

#define  INT_TO_WRITE           2000000000
#define  TEST_FILENAME          "E:\\Temp\\Test.bin"


int main(int argc, char* argv[])
{
  FILE          *FH;
  unsigned int  k;

  if ((FH = fopen(TEST_FILENAME, "wb")) == NULL) {
    fprintf(stderr, "Can't create the test file\n");
    return 0;
  }

  for(k = 0; k < INT_TO_WRITE; ++k)
    if (fwrite(&k, sizeof(unsigned int), 1, FH) != 1) {
      fprintf(stderr, "Write error\n");
      fclose(FH);
      break;
    }

  fclose(FH);
  return 0;
}


