
/*************************************************
****         VEGA - Arguments parser          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"
#include "formats.h"
#include "globstr.h"

#define  MAXOPT         MAXTRJATM
#define  MAXSUBOPT      3


/**** Local definitions ****/

typedef struct  {
  char          *Name;          /* Name of mesure                  */
  VG_WORD       Args;           /* Number of arguments             */
} MESTABLE;


/**** Local prototypes ****/

static VG_BOOL AtmMatch(VG_ULONG *, VG_ULONG, VG_UWORD);



/**** Copy the atom number ****/

static VG_BOOL AtmMatch(VG_ULONG *Dest, VG_ULONG Src, VG_UWORD Idesc)
{
  VG_BOOL          Ret = TRUE;

  if (*Dest) Ret = CatErr(MSG_ERR_ARGPAR_MATCH, Idesc + 1);
  else *Dest = Src;

  return Ret;
}


/**** Translate atom description into atom number ****/

VG_BOOL AtmTrans(ATOMO *InizAtm, VG_ULONG TotAtm, register TRJPAR *TrjPar)
{
  ATMDESC               Tmp;
  register ATOMO        *Atm;
  register ATMDESC      *Desc;
  VG_UWORD              j, k;

  VG_BOOL                  Ret = TRUE;

  if (TrjPar -> Com <= MS_TORSION) {
    for(k = 0; (Ret) && (k < TrjPar -> Num); ++k) {
      Desc = &TrjPar -> Atm[k];
      if (!Desc -> Num) {
        for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
          if (Atm -> Name.L == Desc -> Name.L) {
            if (Desc -> ResName.L) {
              if (Atm -> ResName.L == Desc -> ResName.L) {
                if (Desc -> ResSeq.L) {
                  if (Atm -> ResSeq.L == Desc -> ResSeq.L)
                    Ret = AtmMatch(&Desc -> Num, Atm -> Num, k);
                } else Ret = AtmMatch(&Desc -> Num, Atm -> Num, k);
              }
            } else Ret = AtmMatch(&Desc -> Num, Atm -> Num, k);
          }
        } /* End of ATOMO for*/
        if (!Desc -> Num) Ret = CatErr(MSG_ERR_ARGPAR_INPFILE, k + 1);
      } else if (Desc -> Num > TotAtm) Ret = CatErr(MSG_ERR_ARGPAR_ATMNUM, k + 1);
      for(j = 0; (Ret) && (j < TrjPar -> Num); ++j)
        if ((j != k) && (Desc -> Num == TrjPar -> Atm[j].Num))
          Ret = CatErr(MSG_ERR_ARGPAR_DUPDESC, k + 1, j + 1);
    } /* End of PAR for */

    /**** Sort atom descriptors ****/

    if (Ret) {
      for(j = 0; j < TrjPar -> Num; ++j) {
        Desc = &TrjPar -> Atm[j];
        for(k = j; k < TrjPar -> Num; ++k) {
          if (Desc -> Num > TrjPar -> Atm[k].Num)
            Desc = &TrjPar -> Atm[k];
        } /* End of for loop */
        if (Desc -> Num != TrjPar -> Atm[j].Num) {
          memcpy(&Tmp, &TrjPar -> Atm[j], sizeof(ATMDESC));
          memcpy(&TrjPar -> Atm[j], Desc, sizeof(ATMDESC));
          memcpy(Desc, &Tmp, sizeof(ATMDESC));
        }
      } /* End of for loop */
    }
  }

  return Ret;
}


/**** Analysis command parser ****/

VG_BOOL TrjParser(TRJPAR *TrjPar)
{
  ATMDESC       *Desc;
  char          *Arg, *PrecArg, *SubOpt[MAXSUBOPT];
  VG_ULONG      Com;
  VG_UWORD      j, TotSubOpt;
  VG_WORD       k;

  VG_BOOL          Ret        = TRUE;


  const MESTABLE Mesure[] = {{ "DISTANCE",  2},
                             { "ANGLE"   ,  3},
                             { "TORSION" ,  4},
                             { "PLANEANG",  6},
                             { "VLOGP"   ,  0},
                             { "DIPOLE"  ,  0},
                             { "SURFACE" , -1},
                             { "SURFDIA" , -1},
                             { "VOLUME"  ,  0},
                             { "VOLDIA"  ,  0},
                             { "PSA"     , -1},
                             { "ILM"     , -1},
                             { "LIPOLEBR", -1},
                             { "LIPOLECR", -1},
                             { "RMSD"    , -1},
                             { NULL      ,  0}
                            };

  if (TrjPar -> Num >= 1) {
    for(Com = 0; (Mesure[Com].Name) &&
                 (strcasecmp(TrjPar -> Arg[0], Mesure[Com].Name)); ++Com);
    if (Mesure[Com].Name) {
      TrjPar -> Com   = 1 << Com;
      --TrjPar -> Num;
      k = Mesure[Com].Args;
      if ((k != (VG_WORD)-1) ||
          ((k == (VG_WORD)-1) && (TrjPar -> Num))) {
        if ((k == (VG_WORD)-1) || (TrjPar -> Num == k)) {
          ++TrjPar -> Arg;
          for(k = 0; (Ret) && (k < TrjPar -> Num); ++k) {
            Desc              = &TrjPar -> Atm[k];
            Desc -> Num       = 0;
            Desc -> Name.L    = 0;
            Desc -> ResName.L = 0;
            Desc -> ResSeq.L  = 0;
            Arg               = TrjPar -> Arg[k];
            if (!SubArg(&Arg, SUBA_POSINT, FALSE)) {
              PrecArg   = Arg;
              SubOpt[0] = Arg;
              TotSubOpt = 1;

              /**** Parse the atom description ****/
              /**** Format: ATOM:RESN:RNUM     ****/

              while((Ret) && (*Arg)) {
                if (*Arg == ':') *Arg = 0;
                else if (!*PrecArg) {
                  if (TotSubOpt < MAXSUBOPT) SubOpt[TotSubOpt++] = Arg;
                  else Ret = CatErr(MSG_ERR_ARGPAR_INCDESC);
                }
                PrecArg = Arg++;
              } /* End of while */

              for(j = 0;(Ret) && (j < TotSubOpt); ++j) {
                if (strlen(SubOpt[j]) <= sizeof(VG_QCHAR)) {
                  switch(j) {
                  case 0:         /* Atom name      */
                    Str2Qchar(&TrjPar -> Atm[k].Name, SubOpt[j]);
                    break;
                  case 1:         /* Residue name   */
                    Str2Qchar(&TrjPar -> Atm[k].ResName, SubOpt[j]);
                    break;
                  case 2:         /* Residue number */
                    Str2Qchar(&TrjPar -> Atm[k].ResSeq, SubOpt[j]);
                    break;
                  }
                } else Ret = CatErr(MSG_ERR_ARGPAR_TOOLONG);
              } /* End of for loop */
            } else {
              sscanf(TrjPar -> Arg[k], "%d", &TrjPar -> Atm[k].Num);
              if (!TrjPar -> Atm[k].Num) Ret = CatErr(MSG_ERR_ARGPAR_ILLATMNUM);
            }
          } /* End of for loop */
        } else Ret = CatErr(MSG_ERR_ARGPAR_ILLNUMMES);
      }
    } else Ret = CatErr(MSG_ERR_ARGPAR_UNKMES);
  } else Ret = CatErr(MSG_ERR_ARGPAR_TOOFEW);


  return Ret;
}

