
/*************************************************
****    VEGA - Atom list managment routines   ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VG_ATOM_H
#  define  __VG_ATOM_H

/*************************************
**** Elements for fast access the ****
****       ATOMO structure        ****
*************************************/

#ifdef LITTLE_ENDIAN
#  define VG_ELEM_C                     0x0043
#  define VG_ELEM_H                     0x0048
#  define VG_ELEM_D                     0x0044
#  define VG_ELEM_T                     0x0054
#  define VG_ELEM_O                     0x004f
#  define VG_ELEM_N                     0x004e
#  define VG_ELEM_S                     0x0053
#  define VG_ELEM_P                     0x0050
#  define VG_ELEM_B                     0x0042
#else
#  define VG_ELEM_C                     0x4300
#  define VG_ELEM_H                     0x4800
#  define VG_ELEM_D                     0x4400
#  define VG_ELEM_T                     0x5400
#  define VG_ELEM_O                     0x4f00
#  define VG_ELEM_N                     0x4e00
#  define VG_ELEM_S                     0x5300
#  define VG_ELEM_P                     0x5000
#  define VG_ELEM_B                     0x4200
#endif

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

char           *Atm2Str(char *, ATOMO *);
ATOMO          *CloneAtms(ATOMO *, VG_ULONG);
ATOMO          *FindResByAtm(ATOMO *, ATOMO **, VG_ULONG *);
VG_ULONG        RemoveAtmMatch(ATOMO *InizAtm, char *Sel);

#  ifdef __VG_OPENGL
ATOMO          *DuplicateAtms(ATOMO *, VG_ULONG);
#  endif

#  ifdef __cplusplus
}
#  endif
#endif