
/*************************************************
****       VEGA - Bond managment header       ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VG_BOND_H
#  define  __VG_BOND_H

#  ifndef __VG_TYPES
#    include "vgtypes.h"
#  endif

/**** Constants ****/

#define  VG_BOND_FIELDLEN             256
#define  VG_BOND_ROTPRECISION         1.0e-7f
#define  VG_BOND_TEMPLATE             "BOND.tem"

/**** Angles ****/

#define  VG_ANGLE_SP                    180.0f
#define  VG_ANGLE_SP2                   120.0f
#define  VG_ANGLE_SP3                   109.5f

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif
void            AtmSetGeoSp(ATOMO *, ATOMO *, float);
void            AtmSetGeoSp2(ATOMO *, ATOMO *, float);
void            AtmSetGeoSp3(ATOMO *, ATOMO *, float);

VG_BOOL         BndAssignTypes(ATOMO *, VG_ULONG , VG_BOOL);
VG_BOOL         BndCheck(ATOMO *, ATOMO *, VG_UBYTE *);
VG_BOOL         BndMake(ATOMO *, ATOMO *, VG_BYTE);

#  ifdef __VG_OPENGL
void            BndChange(ATOMO *, ATOMO *, VG_UBYTE);
void            BndChangeAll(ATOMO *, VG_UBYTE, VG_BOOL);
void            BndChangeSingle(ATOMO *, ATOMO *, VG_UBYTE);
void            BndDelete(ATOMO *, ATOMO *);
void            BndDeleteAll(ATOMO *, VG_BOOL);
void            BndFindConnAtms(VG_BYTE *, ATOMO *, VG_ULONG *);
float           BndGetLength(VG_UWORD, VG_UWORD);
VG_BOOL         BndGetRotMat(float *, float, float, float, float);
void            BndRotate(VG_UBYTE *, ATOMO *, ATOMO *, float);
void            BndUnlink(ATOMO *, ATOMO *);
void            BndUnlinkAll(ATOMO *);
float           GetAtmCovRad(VG_UWORD);
float           GetAtmVdwRad(VG_UWORD);
#  endif

#  ifdef __cplusplus
}
#  endif
#endif


