
/*************************************************
****      VEGA - Sybyl COMFA field saver      ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "formats.h"
#include "logp.h"


/**** Local prototypes ****/

static VG_BOOL    SybFldSave(FILE *, float *, VG_ULONG);


/**** Calculate a COMFA field ****/

VG_BOOL SybFldCalc(FILE *FH, ATOMO *InizAtm, VG_ULONG TotAtm, SPACEREG *Reg)
{
  ATOMO         *Atm;
  float         *Fld, *InizFld, *VdwRad, *Vdw;
  VG_ULONG      X, Y, Z;

#ifdef VLOGP
  float         *Contrib;
#endif

  VG_BOOL       Ret      = TRUE;

  if (Reg -> Par) {
    if (Reg -> Points) {
      if ((VdwRad = AssignVdwRad(InizAtm, TotAtm, VLOGP_PROBE_RAD, NULL)) != NULL) {
        switch (Reg -> Par -> Com) {
        case MS_VLOGP:
#ifdef VLOGP
          FindRing(InizAtm, FALSE);
          PrintProg(MSG_DCD_ASSATMTYPES);
          if ((Contrib = LogPInit(InizAtm, TotAtm, NULL, VG_LOGP_BROTO)) == NULL)
            Ret = FALSE;
#else
          Ret = PrintVlogPErr();
#endif
          break;
        } /* End of switch */

        if (Ret) {

          /**** Make the square of VDW radii ****/

          Vdw = VdwRad;
          for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
            *Vdw *= *Vdw;
            ++Vdw;
          }

          if ((InizFld = (float *)Alloca(Reg -> Points * sizeof(float))) != NULL) {
            Fld = InizFld;
            for(Z = 0; Z < Reg -> StZ; ++Z) {
              for(Y = 0; Y < Reg -> StY; ++Y) {
                for(X = 0; X < Reg -> StX; ++X) {
                  switch (Reg -> Par -> Com) {

#ifdef VLOGP
                  case MS_VLOGP:
                    *Fld = CalcSrfLogP(InizAtm, Contrib,
                                       X * Reg -> StepS.x + Reg -> Low.x,
                                       Y * Reg -> StepS.y + Reg -> Low.y,
                                       Z * Reg -> StepS.z + Reg -> Low.z,
                                       VdwRad, 0);
                    break;
#endif
                  }
                  ++Fld;
                } /* End of X loop */
              } /* End of Y loop */
            } /* End of Z loop */

            Ret = SybFldSave(FH, InizFld, Reg -> Points);
          }
          FREE(InizFld);
        } else Ret = FALSE;

        /**** Free the resources ****/

        switch (Reg -> Par -> Com) {

#ifdef VLOGP
        case MS_VLOGP:
          if (Contrib) FREE(Contrib);
          break;
#endif

        }
        FREE(VdwRad);

      } else Ret = FALSE;
    } else Ret = CatErr(MSG_ERR_COMFA_RGN);
  } else Ret = CatErr(MSG_ERR_COMFA_FIELD);

  return Ret;

}


/**** Save a COMFA field in .fld format ****/

static VG_BOOL SybFldSave(FILE *FH, register float *Fld, VG_ULONG TotPts)
{
  VG_BOOL                  Ret = TRUE;
  register VG_ULONG        Pts;

  for(Pts = 1;(Ret) && (Pts <= TotPts); ++Pts) {
    if (fprintf(FH, "  %12.6f", *Fld++) > 0) {
      if (!(Pts % 5))
        if (fprintf(FH, "\n") <= 0) Ret = PrintDosErr();
    } else Ret = PrintDosErr();
  }

  if (TotPts % 5)
    if (fprintf(FH, "\n") <= 0) Ret = PrintDosErr();

  return Ret;
}


