
/*************************************************
****           VEGA - Command parser          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <malloc.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#define  __COMPAR
#include "compar.h"
#include "traj.h"

static VG_ULONG         ErrArgNum;


/**** Check the type of the argument ****/

VG_BOOL ChkArgType(register char *Str, VG_ULONG Len, register VG_UBYTE Type)
{
  register VG_ULONG     k;

  VG_BOOL               Dot  = FALSE;
  VG_BOOL               Ret  = TRUE;
  VG_ULONG              Exp  = 0;
  VG_ULONG              Zero = 0;

  switch(Type & 0x7) {

  case VG_PARTYPE_BOOL:
    if ((Len != 1) || ((*Str != '0') && (*Str != '1')))
      Ret = FALSE;
    break;

  case VG_PARTYPE_FLOAT:
  case VG_PARTYPE_INT:
    if ((Type & VG_PARTYPE_UNSIGNED) && (*Str == '-')) {
      Ret = FALSE;
      break;
    }
    for(k = 0; (k < Len) && (Ret); ++k, ++Str) {
      if ((*Str < '0') || (*Str > '9')) {
        if (((!k) || ((Exp) && (k == Exp + 1))) &&
            ((*Str == '+') || (*Str == '-')))
          continue;
        if ((Type & 0x7) == VG_PARTYPE_FLOAT) {
          if ((*Str == '.') && (!Dot))
            Dot = TRUE;
          else if ((*Str == 'E') && (!Exp))
            Exp = k;
          else Ret = FALSE;
        } else Ret = FALSE;
      } else if (*Str == '0') ++Zero;
    }
    if ((Ret) && (Type & VG_PARTYPE_NOZERO)) {
      if (Dot) ++Zero;
      if (Zero == Len) Ret = FALSE;
    }
    break;
  } /* End of switch */

  return Ret;
}


/**** Find an argument in a string ****/

VG_ULONG CountArgStr(char *Str)
{
  register VG_ULONG     Args = 0;
  VG_BOOL               Beg = FALSE;
  VG_BOOL               Quo = FALSE;

  if (*Str) {
    do {
      if ((*Str != ' ') && (*Str != '\t')) {
        Beg = TRUE;
        if (*Str == '\"') Quo = !Quo;
      } else if ((Beg) && (!Quo)) {
        ++Args;
        Beg = FALSE;
      }
    } while (*++Str);
    if (Beg) ++Args;
  }

  return Args;
}


/**** Free all command structures ****/

void FreeCom(register VG_COMM *Com)
{
  register VG_COMM       *Succ;
  register VG_PARAM      *Par, *SucPar;

  if (Com) {
    do {
      Succ = Com -> Ptr;
      Par  = Com -> ParList;
      while(Par) {
        SucPar = Par -> Ptr;
        if (Par -> Type == VG_PARTYPE_CHAR)
          FREE(Par -> Data.C);
        FREE(Par);
        Par = SucPar;
      }
      FREE(Com);
      Com = Succ;
    } while(Com);
  }
}


/**** Get an argument from a string ****/

char *GetArgStr(char *Str, VG_ULONG *Size, char **NextStr)
{
  register char         *BegStr = NULL;
  VG_BOOL               Beg     = FALSE;
  VG_BOOL               Quo     = FALSE;

  if (*Str) {
    do {
      if ((*Str != ' ') && (*Str != '\t')) {
        if (!Beg) {
          BegStr = Str;
          Beg    = TRUE;
          *Size  = 0;
        }
        if (*Str == '\"') Quo = !Quo;
      } else if ((Beg) && (!Quo)) {
        break;
      }
      if (Beg) ++*Size;
    } while (*++Str);
    if (*BegStr == '\"') {
      --*Size;
      if (*++BegStr) {
        if (Size) {
          if (BegStr[*Size - 1] == '\"')
            --*Size;
        } else BegStr = NULL;
      } else BegStr = NULL;
    }
    if (NextStr) *NextStr = Str;
  }

  return BegStr;
}


/**** String parser ****/

VG_COMM *ParseStr(char *Str)
{
  char          *Arg, *NextArg, *Ptr;
  VG_COMM_INFO  *Info;
  VG_UBYTE      ArgType;
  VG_ULONG      k, StrLen;
  VG_MULTI      Val;
  VG_PARAM      **ParPtr;
  VG_UWORD      NumArgs;

  VG_BOOL       Ret  = TRUE;
  VG_COMM       *Com = NULL;

  ErrArgNum  = 0;

  if (NumArgs = CountArgStr(Str)) {
    --NumArgs;
    if (Arg = GetArgStr(Str, &StrLen, &NextArg)) {

      /**** Find the command ****/

      for(Info = (VG_COMM_INFO *)ComInfo;
         (Info -> Id != VG_PARCOM_NOTHING) && (strncasecmp(Arg, Info -> Name, StrLen));
          ++Info);

      if ((Info -> Id != VG_PARCOM_NOTHING) && (StrLen == strlen(Info -> Name))) {

        /**** Check if OpenGL mode is required ****/

        if ((Info -> Flags & VG_COMFLG_OPENGL) && (!GLOBSW_OPENGL)) {
          CatErr(MSG_ERR_LODER_OPENGLONLY);
          return NULL;
        }

        /**** Check if the molecule is required ****/

        if ((Info -> Flags & VG_COMFLG_MOL) && (!BegAtm)) {
          CatErr(MSG_ERR_COM_NOMOL);
          return NULL;
        }

        /**** Check if the surface is required ****/

        if ((Info -> Flags & VG_COMFLG_SRF) && (!BegSrf)) {
          CatErr(MSG_ERR_COM_NOSRF);
          return NULL;
        }

        /**** Check if the trajectory is required ****/

        if ((Info -> Flags & VG_COMFLG_TRJ) && (!TrjInfo.FH)) {
          CatErr(MSG_ERR_COM_NOTRJ);
          return NULL;
        }

        if (Info -> NumArgs > NumArgs) {
          CatErr(MSG_ERR_COM_FEWARGS, Info -> NumArgs);
        } else if (Info -> NumArgs < NumArgs) {
          CatErr(MSG_ERR_COM_TOOARGS, Info -> NumArgs);
        } else {
          if ((Com = (VG_COMM *)Alloca(sizeof(VG_COMM))) != NULL) {
            Com -> Id     = Info -> Id;
            Com -> RetVal = Info -> RetVal;
            Com -> NumPar = NumArgs;
            ParPtr        = &Com -> ParList;
            while ((Ret) &&
                   ((Arg = GetArgStr(NextArg, &StrLen, &NextArg)) != NULL)) {
              ArgType  = Info -> ArgTypes[ErrArgNum].ArgType;
              if (!ChkArgType(Arg, StrLen, ArgType)) {
                Ret = CatErr(MSG_ERR_COM_ILLARG, ErrArgNum + 1);
                break;
              }
              *ParPtr = (VG_PARAM *)Alloca(sizeof(VG_PARAM));
              if (*ParPtr) {
                (*ParPtr) -> Type = ArgType;
                switch(ArgType & 0x7) {
                case VG_PARTYPE_BOOL:
                  if (*Arg == '1')
                    (*ParPtr) -> Data.B = TRUE;
                  else
                    (*ParPtr) -> Data.B = FALSE;
                  break;

                case VG_PARTYPE_CHAR:
                  if (((ArgType & VG_PARTYPE_MAX) &&
                       (StrLen > Info -> ArgTypes[ErrArgNum].Max.UL)) ||
                      ((ArgType & VG_PARTYPE_MIN) &&
                       (StrLen < Info -> ArgTypes[ErrArgNum].Min.UL))) {
                      Ret = CatErr(MSG_ERR_COM_EXCRANGEC,
                                   ErrArgNum + 1,
                                   (VG_ULONG)Info -> ArgTypes[ErrArgNum].Min.UL,
                                   (VG_ULONG)Info -> ArgTypes[ErrArgNum].Max.UL);
                    break;
                  }

                  if (ArgType & VG_PARTYPE_CMTX) {
                    for(Ptr = Info -> ArgTypes[ErrArgNum].Max.C, k = 0;
                        ((*Ptr) && ((strlen(Ptr) != StrLen) ||
                         (strncasecmp(Arg, Ptr, StrLen))));
//                       ((*Ptr) && (strcasecmp(Arg, Ptr)));
                        Ptr += strlen(Ptr) + 1, ++k);
                    if (*Ptr)
                      (*ParPtr) -> Data.UL = k;
                    else
                      Ret = CatErr(MSG_ERR_COM_UNKKEYWORD, ErrArgNum + 1);
                  } else if ((*ParPtr) -> Data.C = (char *)Alloca(StrLen + 2)) {
                    strncpy((*ParPtr) -> Data.C, Arg, StrLen);
                  }
                  break;

                case VG_PARTYPE_FLOAT:
                  sscanf(Arg, "%f", &(*ParPtr) -> Data.F);
                  if ((((ArgType & VG_PARTYPE_MIN) &&
                       ((*ParPtr) -> Data.F < Info -> ArgTypes[ErrArgNum].Min.F))) ||
                      (((ArgType & VG_PARTYPE_MAX) &&
                       ((*ParPtr) -> Data.F > Info -> ArgTypes[ErrArgNum].Max.F)))) {
                    Ret = CatErr(MSG_ERR_COM_EXCRANGEF, ErrArgNum + 1,
                                 Info -> ArgTypes[ErrArgNum].Min.F,
                                 Info -> ArgTypes[ErrArgNum].Max.F);
                  }
                  break;

                case VG_PARTYPE_INT:
                  sscanf(Arg, "%d", &(*ParPtr) -> Data.L);
                  if (ArgType & VG_PARTYPE_UNSIGNED) {
                    if ((((ArgType & VG_PARTYPE_MIN) &&
                         ((*ParPtr) -> Data.UL < Info -> ArgTypes[ErrArgNum].Min.UL))) ||
                        (((ArgType & VG_PARTYPE_MAX) &&
                         ((*ParPtr) -> Data.UL > Info -> ArgTypes[ErrArgNum].Max.UL)))) {
                      Ret = CatErr(MSG_ERR_COM_EXCRANGEUI,
                                   ErrArgNum + 1,
                                   (VG_ULONG)Info -> ArgTypes[ErrArgNum].Min.UL,
                                   (VG_ULONG)Info -> ArgTypes[ErrArgNum].Max.UL);
                    }
                  } else {
                    if ((((ArgType & VG_PARTYPE_MIN) &&
                         ((*ParPtr) -> Data.L < Info -> ArgTypes[ErrArgNum].Min.L))) ||
                        (((ArgType & VG_PARTYPE_MAX) &&
                         ((*ParPtr) -> Data.L > Info -> ArgTypes[ErrArgNum].Max.L)))) {
                      Ret = CatErr(MSG_ERR_COM_EXCRANGEI,
                                   ErrArgNum + 1,
                                   Info -> ArgTypes[ErrArgNum].Min.L,
                                   Info -> ArgTypes[ErrArgNum].Max.L);
                    }
                  }
                  break;
                } /* End of switch */
                ParPtr = &((*ParPtr) -> Ptr);
              }
              ++ErrArgNum;
            } /* End of while */
            if (!Ret) {
              FreeCom(Com);
              Com = NULL;
            }
          }
        }
      } else CatErr(MSG_ERR_COM_UNKCOM);
    } else CatErr(MSG_ERR_COM_NOCOM);
  } else CatErr(MSG_ERR_COM_NOCOM);

  return Com;
}

