
/*************************************************
****            VEGA - Count header           ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VG_COUNT_H
#define  __VG_COUNT_H

#ifndef __VG_TYPES
#  include  "vgtypes.h"
#endif

#ifndef __VG_ATOM_H
#  include "atom.h"
#endif

/**** Constants ****/

#define  FIELDLEN       256
#define  PSF_HBFF       "HBOND.tem"

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_ULONG   CountActiveAtms(ATOMO *);
VG_ULONG   CountAtms(ATOMO *, VG_BOOL);
VG_ULONG   CountAngle(ATOMO **);
VG_ULONG   CountBndFreeOx(ATOMO *);
VG_ULONG   CountBndHeavyAtms(ATOMO *);
VG_ULONG   CountBndHyd(ATOMO *);
VG_ULONG   CountBond(ATOMO *);
VG_ULONG   CountChain(ATOMO *);
VG_ULONG   CountHbAcceptor(ATOMO *);
VG_ULONG   CountHbDonor(ATOMO *);
VG_ULONG   CountImproper(ATOMO **, ATOMO **);
VG_ULONG   CountRes(ATOMO *);
VG_ULONG   CountTorsion(ATOMO **, ATOMO **);
VG_ULONG   GenAngleMtx(ATOMO **, ATOMO ***);
VG_ULONG   GenBondMtx(ATOMO *, ATOMO ***);
VG_ULONG   GenImproperMtx(ATOMO **, ATOMO ***);
VG_ULONG   GenTorsionMtx(ATOMO **, ATOMO ***);

#  ifdef __cplusplus
}
#  endif
#endif
