
/*************************************************
****       VEGA - CSSR loader & saver         ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


/*
 * Supported CSSR subformats:
 * - CSSR    read & write
 * - QMC     read & write
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "bond.h"
#include "formats.h"


/**** CSSR Loader ****/

ATOMO *CSSRLoad(FILE *CSSRIN, RECORD *CSSRLin, VG_ULONG *TotAtomi, VG_UWORD SubForm)
{
  ATOMO             *Bnd, **ConMtx;
  VG_ULONG          ConNum[MAXBOND];
  VG_ULONG          AtmNum, BegFile, Offset, k;

  ATOMO             *Atm     = NULL;
  ATOMO             *InizAtm = NULL;


  BegFile = ftell(CSSRIN) - strlen(CSSRLin -> Line);

  if (SubForm) Offset = 70;    /* QMC  */
  else Offset = 74;            /* CSSR */

  /**** Load the coordinates ****/

  do {
    if (*CSSRLin -> Line != '\n') {
      if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
        sscanf(CSSRLin -> Line, "%*s %4s %9f %9f %9f",
             Atm -> Name.C, &Atm -> x, &Atm -> y, &Atm -> z);
        sscanf(CSSRLin -> Line + Offset, "%f", &Atm -> Charge);
        AtmName2Elem(Atm);
      } else break;
    }
  } while(fgets(CSSRLin -> Line, VG_LINELEN, CSSRIN));
  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;

    /**** Load the connectivity ****/

    if ((ConMtx = AllocAtmTable(InizAtm, *TotAtomi, TRUE)) != NULL) {
      fseek(CSSRIN, BegFile, SEEK_SET);
      while(fgets(CSSRLin -> Line, VG_LINELEN, CSSRIN)) {
        AtmNum = 0;
        sscanf(CSSRLin -> Line, "%d", &AtmNum);
        if (AtmNum) {
          for(k = 0; k < MAXBOND; ++k) ConNum[k] = 0;
          if (SubForm)
            sscanf(CSSRLin -> Line + 43, "%d %d %d %d %d", &ConNum[0], &ConNum[1],
                   &ConNum[2], &ConNum[3], &ConNum[4]);
          else
            sscanf(CSSRLin -> Line + 40, "%d %d %d %d %d %d", &ConNum[0], &ConNum[1],
                   &ConNum[2], &ConNum[3], &ConNum[4], &ConNum[5]);
          if (ConNum[0]) {
            Atm = ConMtx[AtmNum - 1];
            for(k = 0; (k < MAXBOND) && (ConNum[k]); ++k) {
              Bnd = ConMtx[ConNum[k] - 1];
              if (!BndCheck(Atm, Bnd, NULL)) BndMake(Atm, Bnd, VG_BOND_SINGLE);
            } /* End of for */
          }
        }
      } /* End of while */
      GLOBSW_CONNCALC = FALSE;
      FREE(ConMtx);
    }
  }

  return InizAtm;
}

/**** CSSR Saver ****/

VG_BOOL CSSRSave(FILE *OUT, register ATOMO *Atm, VG_ULONG Tot, VG_UWORD Form)
{
  char            *Temp1, *Temp2, *Temp3;
  VG_ULONG           k, TotLeg;

  VG_BOOL            Ret   = TRUE;
  register VG_ULONG  Count = 1;

  if (Form) {
    Temp1  = "%4d %-5.4s %10.5f %10.5f %10.5f";
    Temp2  = "%5d";
    Temp3  = "    0";
    TotLeg = 4;
    if (fprintf(OUT, "%4d\n\n", Tot) < 0)
      Ret = PrintDosErr();
  } else {
    Temp1  = "%4d %-5.4s %9.5f %9.5f %9.5f";
    Temp2  = "%4d";
    Temp3  = "   0";
    TotLeg = MAXBOND;
    if (fprintf(OUT, " \n \n%4d   1 %s\n     0 %60s\n", Tot, VEGAHdr, " ") < 0)
      Ret = PrintDosErr();
  }

  if (Ret) {
    do {
      if (fprintf(OUT, Temp1, Count, Atm -> Name.C, Atm -> x, Atm -> y, Atm -> z) >= 0) {
        for(k = 0;(Ret) && (k < TotLeg);++k) {
          if (Atm -> Conn[k]) {
            if (fprintf(OUT, Temp2, Atm -> Conn[k] -> Num) < 0)
              Ret = PrintDosErr();
          } else if (fprintf(OUT, Temp3) < 0) Ret = PrintDosErr();
        }
        if (Ret) {
          if (Form) {
            if (fprintf(OUT, "    0   %8.5f\n", Atm -> Charge) < 0)
              Ret = PrintDosErr();
          } else if (fprintf(OUT, "   0   0%8.3f\n", Atm -> Charge) < 0)
            Ret = PrintDosErr();
          ++Count;
          Atm = Atm -> Ptr;
        }
      } else Ret = PrintDosErr();
    } while((Ret) && (Atm));
  }

  return Ret;
}
