
/*************************************************
****            VEGA - File database          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "formats.h"
#include "db_engine.h"

#ifdef WIN32
#  include <windows.h>
#else
#  include <dirent.h>
#endif


/**** Close the file database ****/

void DbFileClose(VG_DBINFO *Dbh)
{
  fclose((FILE *)Dbh -> Handle);
}


/**** Create a new database ****/

VG_BOOL DbFileCreate(VG_DBINFO *Dbh)
{
  VG_BOOL       Ret = FALSE;

#ifdef WIN32
  if (CreateDirectory(Dbh -> FileName, NULL)) {
    SetCurrentDirectory(Dbh -> FileName);
#else
  if (!mkdir(Dbh -> FileName)) {
    chdir(Dbh -> FileName);
#endif
    if (!DbDatCreate((char *)DbDataStr, Dbh)) {
#ifdef WIN32
      SetCurrentDirectory("..");
      RemoveDirectory(Dbh -> FileName);
#else
      chdir("..");
      rmdir(Dbh -> FileName);
#endif
    } else Ret = TRUE;
  }

  return Ret;
}


/**** Get a molucule ****/

ATOMO *DbFileGet(VG_DBINFO *Dbh, char *MolName, VG_LONG *FormatID)
{
  ATOMO                 *LastSeg;
  char                  OldDir[VG_MAX_PATH];
  VG_ULONG              TmpTotAtm;

  ATOMO                 *TmpIniz = NULL;

#ifdef WIN32
  GetCurrentDirectory(VG_MAX_PATH, OldDir);
  if (SetCurrentDirectory(Dbh -> FileName)) {
#else
  getcwd(OldDir, VG_MAX_PATH);
  if (!chdir(Dbh -> FileName)) {
#endif

    LastSeg         = LastAtm;
    GLOBSW_CONNCALC = TRUE;
    TmpIniz         = Loader(MolName, &TmpTotAtm, FormatID, NULL, 0, &BegSrf, &TotalSrf);
    if ((TmpIniz) && (TmpIniz != (ATOMO *)-1) && (TmpIniz != (ATOMO *)-2)) {
      TotalAtm += TmpTotAtm;
      if (BegAtm) {
        LastSeg -> Ptr  = TmpIniz;
        TmpIniz -> Prev = LastSeg;
      } else BegAtm = TmpIniz;
      if (GLOBSW_CONNCALC) Connect(TmpIniz, TmpTotAtm, Prefs.CONNTOL, FALSE);
      else GLOBSW_CONNCALC = TRUE;
    } else TmpIniz = NULL;

#ifdef WIN32
    SetCurrentDirectory(OldDir);
#else
    chdir(OldDir);
#endif
  }

  return TmpIniz;
}


/**** Read the molecule list ****/

VG_BOOL DbFileMolListRead(VG_DBINFO *Dbh)
{
  char                  *Ptr;
  FILEFORMAT            *FI;
  VG_LONG               j, k;

  VG_BOOL               Ret = TRUE;

#ifdef WIN32
  HANDLE                Dir;
  WIN32_FIND_DATA       FileData;

  strcat(Dbh -> FileName, "\\*.*");
  if ((Dir = FindFirstFile(Dbh -> FileName, &FileData)) != INVALID_HANDLE_VALUE) {
    do {
      k = strlen(FileData.cFileName);
      if ((k > 4) && (strcasecmp(FileData.cFileName, DbDataStr))) {
        for(FI = FileInfo; FI -> Id; ++FI) {
          j = strlen(FI -> Ext);
          if ((j < k) &&
              (FI -> Id & FORM_TYPE_MOLE) &&
              (FileData.cFileName[k - j - 1] == '.') &&
              (!strcasecmp(FileData.cFileName + k - j, FI -> Ext))) {
            break;
          }
        } /* End of for */

        if (FI -> Id) {
          if (DbMolListAdd(Dbh, FileData.cFileName) == NULL) {
            Ret = FALSE;
            break;
          }
        }
      }
    } while(FindNextFile(Dir, &FileData));
    FindClose(Dir);
  } else Ret = FALSE;
  Dbh -> FileName[strlen(Dbh -> FileName) - 4] = 0;

#else

  DIR           *Dir;
  struct dirent *Dp;

  if ((Dir = opendir(Dbh -> FileName)) != NULL) {
    while((Dp = readdir(Dir)) != NULL) {
      if ((*Dp -> d_name != '.') &&
          (DbMolListAdd(Dbh, Dp -> d_name) == NULL)) {
        Ret = FALSE;
        break;
      }
    } /* End of while */
    closedir(Dir);
  } else Ret = FALSE;
#endif

  return Ret;
}


/**** Open an existing database ****/

VG_BOOL DbFileOpen(VG_DBINFO *Dbh)
{
  if (DbDatRead(Dbh -> FileName, Dbh)) {
    GetFilePath(Dbh -> FileName);
    Dbh -> FileName[strlen(Dbh -> FileName) - 1] = 0;
    return TRUE;
  }

  return FALSE;
}


/**** Put a molecule ****/

VG_BOOL DbFilePut(VG_DBINFO *Dbh, char *MolName)
{
  char                  OldDir[VG_MAX_PATH];

  VG_BOOL               Ret = FALSE;

#ifdef WIN32
  GetCurrentDirectory(VG_MAX_PATH, OldDir);
  if (SetCurrentDirectory(Dbh -> FileName)) {
#else
  getcwd(OldDir, VG_MAX_PATH);
  if (!chdir(Dbh -> FileName)) {
#endif
    Ret = Saver(MolName, Dbh -> MolFormat, Dbh -> MolPack, BegAtm, TotalAtm);
#ifdef WIN32
    SetCurrentDirectory(OldDir);
#else
    chdir(OldDir);
#endif
  }

  return Ret;
}


/**** Remove a molecule ****/

VG_BOOL DbFileRemove(VG_DBINFO *Dbh, VG_DBMOLLIST *Itm)
{
  char                  OldDir[VG_MAX_PATH];

  VG_BOOL               Ret = FALSE;

#ifdef WIN32
  GetCurrentDirectory(VG_MAX_PATH, OldDir);
  if (SetCurrentDirectory(Dbh -> FileName)) {
    if (DeleteFile(Itm -> MolName)) Ret = TRUE;
    SetCurrentDirectory(OldDir);
  }
#else
  getcwd(OldDir, VG_MAX_PATH);
  if (!chdir(Dbh -> FileName)) {
    if (!remove(Itm -> MolName)) Ret = TRUE;
    chdir(OldDir);
  }
#endif

  return Ret;
}


/**** Rename a molecule ****/

VG_BOOL DbFileRen(VG_DBINFO *Dbh, VG_DBMOLLIST *Itm, char *NewName)
{
  char                  OldDir[VG_MAX_PATH];

  VG_BOOL               Ret = FALSE;

#ifdef WIN32
  GetCurrentDirectory(VG_MAX_PATH, OldDir);
  if (SetCurrentDirectory(Dbh -> FileName)) {
    if (MoveFile(Itm -> MolName, NewName)) Ret = TRUE;
    SetCurrentDirectory(OldDir);
  }
#else
  getcwd(OldDir, VG_MAX_PATH);
  if (!chdir(Dbh -> FileName)) {
    if (!rename(Itm -> MolName, NewName)) Ret = TRUE;
    chdir(OldDir);
  }
#endif

  return Ret;
}

