
/*************************************************
****         VEGA - Format Definitions        ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __FORMATS_H
#define  __FORMATS_H

/**** File format types ****/

#define  FORM_TYPE_MOLE      65536  /* Molecule                           */
#define  FORM_TYPE_SURF     131072  /* Surface                            */
#define  FORM_TYPE_PLOT     262144  /* Plot                               */
#define  FORM_TYPE_CALC     524288  /* Calculation                        */
#define  FORM_TYPE_FIELD   1048576  /* COMFA field                        */
#define  FORM_TYPE_SCREEN  2097152  /* Screen output                      */

/**** File formats ****/

#define  FORM_UNK               (  0 ) 
#define  FORM_PDB_2             (  0 | FORM_TYPE_MOLE)
#define  FORM_PDB               (  1 | FORM_TYPE_MOLE)
#define  FORM_PDB_NONSTD        (  2 | FORM_TYPE_MOLE)
#define  FORM_BIOSYM_OLD        (  3 | FORM_TYPE_MOLE)
#define  FORM_BIOSYM            (  4 | FORM_TYPE_MOLE)
#define  FORM_IFF               (  5 | FORM_TYPE_MOLE)
#define  FORM_CSSR              (  6 | FORM_TYPE_MOLE)
#define  FORM_MOPINT            (  7 | FORM_TYPE_MOLE)
#define  FORM_XYZ               (  8 | FORM_TYPE_MOLE)
#define  FORM_PDB_Q             (  9 | FORM_TYPE_MOLE)
#define  FORM_QUANTA_SRF        ( 10 | FORM_TYPE_SURF)
#define  FORM_BIOSYM_SRF        ( 11 | FORM_TYPE_SURF)
#define  FORM_PDB_FAT           ( 12 | FORM_TYPE_MOLE)
#define  FORM_QMC               ( 13 | FORM_TYPE_MOLE)
#define  FORM_QUANTA_MSF        ( 14 | FORM_TYPE_MOLE)
#define  FORM_VRML_SRF_POINTS   ( 15 | FORM_TYPE_MOLE)
#define  FORM_VRML_SRF_CPK      ( 16 | FORM_TYPE_MOLE)
#define  FORM_VRML              ( 17 | FORM_TYPE_MOLE)
#define  FORM_VRML_SOLID        ( 18 | FORM_TYPE_MOLE)
#define  FORM_INFO              ( 19 | FORM_TYPE_CALC)
#define  FORM_FASTA             ( 20 | FORM_TYPE_MOLE)
#define  FORM_ENER_CVFF         ( 21 | FORM_TYPE_CALC)
#define  FORM_MOL2              ( 22 | FORM_TYPE_MOLE)
#define  FORM_CRD               ( 23 | FORM_TYPE_MOLE)
#define  FORM_GROMOS            ( 24 | FORM_TYPE_MOLE)
#define  FORM_QUANTA_LOGP       ( 25 | FORM_TYPE_SURF)
#define  FORM_QUANTA_MEP        ( 26 | FORM_TYPE_SURF)
#define  FORM_GROMOS_NM         ( 27 | FORM_TYPE_MOLE)
#define  FORM_PLOT_CSV          ( 28 | FORM_TYPE_PLOT)
#define  FORM_PLOT_QUANTA       ( 29 | FORM_TYPE_PLOT)
#define  FORM_PLOT_BIN          ( 30 | FORM_TYPE_PLOT)
#define  FORM_COMFAFLD          ( 31 | FORM_TYPE_FIELD)
#define  FORM_OPENGL            ( 32 | FORM_TYPE_SCREEN)
#define  FORM_QUANTA_ILM        ( 33 | FORM_TYPE_SURF)
#define  FORM_HIN               ( 34 | FORM_TYPE_MOLE)
#define  FORM_PDB_ATDL          ( 35 | FORM_TYPE_MOLE)
#define  FORM_MDL               ( 36 | FORM_TYPE_MOLE)
#define  FORM_GAMESS            ( 37 | FORM_TYPE_MOLE)
#define  FORM_ALCHEMY           ( 38 | FORM_TYPE_MOLE)
#define  FORM_CSV_SRF           ( 39 | FORM_TYPE_SURF)
#define  FORM_CSV_ILM           ( 40 | FORM_TYPE_SURF)
#define  FORM_CSV_LOGP          ( 41 | FORM_TYPE_SURF)
#define  FORM_CSV_MEP           ( 42 | FORM_TYPE_SURF)
#define  FORM_PSFX              ( 43 | FORM_TYPE_MOLE)
#define  FORM_C3DCC1            ( 44 | FORM_TYPE_MOLE)

/**** Trajectory formats ****/

#define  FTRJ_NONE               0
#define  FTRJ_ARC                1
#define  FTRJ_BIODOCK            2
#define  FTRJ_CSR                3
#define  FTRJ_DCD                4
#define  FTRJ_ESCHERNG           5
#define  FTRJ_PDB                6
#define  FTRJ_XTC                7

/**** Plot data flags ****/

#define  FPLOT_FLG_TRAJ          256

/**** Plot data formats ****/

#define  FPLOT_UNK                0
#define  FPLOT_CHARMMENE         (1 | FPLOT_FLG_TRAJ)
#define  FPLOT_CSV                2
#define  FPLOT_GROMACSLOG        (3 | FPLOT_FLG_TRAJ)
#define  FPLOT_NAMDOUT           (4 | FPLOT_FLG_TRAJ)

/**** Surface output formats ****/

#define  SRF_QUANTA              0
#define  SRF_CSV                 1
#define  SRF_IFF                 2
#define  SRF_INSIGHT             3
#define  SRF_RAW                 4
#define  SRF_VRML_POINTS         5
#define  SRF_VRML_SOLID          6

/**** Surface properties ****/

#define  SRF_PROP_VDW        0x100
#define  SRF_PROP_VLOGP      0x200
#define  SRF_PROP_MEP        0x300
#define  SRF_PROP_ILM        0x400
#define  SRF_PROP_PSA        0x500

/**** Surface flags ****/

#define  SRF_FLG_ALLATM          0
#define  SRF_FLG_NOWAT           1
#define  SRF_FLG_SELONLY         2

/**** Biosym subformats ****/

#define  BIOSYM_OLD              1
#define  BIOSYM_NEW              3

/**** CSSR subformats ****/

#define  CSSR_PURE               0
#define  CSSR_QMC                1

/**** PDB subformats ****/

#define  PDB_PURE                0
#define  PDB_NONSTD              1
#define  PDB_PDBQ                2
#define  PDB_FAT                 3
#define  PDB_ATDL                4
#define  PDB_ORAC                5
#define  PDB_2                   6

/**** PSF subformats ****/

#define  PSF_CHARMM              0
#define  PSF_XPLOR               1

/**** Chem3D subformats ****/

#define C3D_CC1                  0
#define C3D_CC2                  1
#define C3D_MMADS                2

/**** Selection types ****/

#define  SL_DISTANCE             0
#define  SL_ANGLE                1
#define  SL_TORSION              2
#define  SL_PLANEANG             3
#define  SL_MULTI                4
#define  SL_NONE                 5

/**** Merge fields ****/

#define  VG_MERGE_NONE           0
#define  VG_MERGE_ATMCHARGE      1
#define  VG_MERGE_ATMNAME        2
#define  VG_MERGE_ATMTYPE        4
#define  VG_MERGE_CHAINID        8
#define  VG_MERGE_CONN          16
#define  VG_MERGE_CONSTR        32
#define  VG_MERGE_COORD         64
#define  VG_MERGE_ELEMENT      128
#define  VG_MERGE_MOLID        256
#define  VG_MERGE_RESNAME      512
#define  VG_MERGE_RESSEQ      1024
#define  VG_MERGE_SEGMENTS    2048

#define  VG_MERGE_ALL          (0xffffffff)
#define  VG_MERGE_CAR          (VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ|VG_MERGE_SEGMENTS|VG_MERGE_ATMCHARGE|VG_MERGE_ATMTYPE)
#define  VG_MERGE_MOL2         (VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ|VG_MERGE_ATMCHARGE|VG_MERGE_ATMTYPE|VG_MERGE_CHAINID|VG_MERGE_CONN)
#define  VG_MERGE_PDB          (VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ|VG_MERGE_CHAINID|VG_MERGE_SEGMENTS|VG_MERGE_CONN)

/**** Type of mesure ****/

#define  MS_NONE                 0      /* Please don't chenge the order */
#define  MS_DISTANCE             1
#define  MS_ANGLE                2
#define  MS_TORSION              4
#define  MS_PLANEANG             8
#define  MS_VLOGP               16
#define  MS_DIPOLE              32
#define  MS_SURFACE             64
#define  MS_SURFDIA            128
#define  MS_VOLUME             256
#define  MS_VOLDIA             512
#define  MS_PSA               1024
#define  MS_ILM               2048
#define  MS_LIPBROTO          4096
#define  MS_LIPCRIPPEN        8192
#define  MS_RMSD             16384

#define  MS_ALL                 MS_DISTANCE|MS_ANGLE|MS_TORSION|         \
                                MS_PLANEANG|MS_PLANEANG|MS_VLOGP|        \
                                MS_DIPOLE|MS_SURFACE|MS_SURFACE|         \
                                MS_SURFDIA|MS_VOLUME|MS_VOLDIA|          \
                                MS_PSA|MS_ILM|MS_LIPBROTO|MS_LIPCRIPPEN| \
                                MS_RMSD

/**** Control flags for file formats ****/

#define  FORM_FLAG_NONE         0  /* Nothing                            */
#define  FORM_FLAG_CONN         1  /* Allow the connectivity calculation */
#define  FORM_FLAG_CONNAL       2  /* The connectivity is needed         */
#define  FORM_FLAG_FFCALC       4  /* Allow the force field attribuition */
#define  FORM_FLAG_CHARGE       8  /* Allow atomic charges attribuition  */
#define  FORM_FLAG_STDOUT      16  /* Allow the stdout use               */
#define  FORM_FLAG_CHKCHG      32  /* Check the charges                  */
#define  FORM_FLAG_CHKFF       64  /* Check the force field              */
#define  FORM_FLAG_VDW        128  /* Assign VdW radii                   */
#define  FORM_FLAG_RINGS      256  /* Search for the rings               */
#define  FORM_FLAG_INONLY     512  /* Input only                         */

/**** Shape types for solvatation ****/

#define  SOL_SHAPE_BOX          0
#define  SOL_SHAPE_SPHERE       1
#define  SOL_SHAPE_LAYER        2


#ifdef __MAIN
FILEFORMAT FileInfo[] = {
/* PDB 2.2         */ { FORM_PDB_2         , "PDB2"      , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN,
                        MS_NONE,
                        VG_MERGE_PDB },

/* PDB             */ { FORM_PDB            , "PDB"       , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN,
                        MS_NONE,
                        VG_MERGE_PDB },

/* PDB Not Std.    */ { FORM_PDB_NONSTD     , "PDBNOTSTD" , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN,
                        MS_NONE,
                        VG_MERGE_PDB },

/* Old Biosym      */ { FORM_BIOSYM_OLD     , "OLDBIOSYM" , "car" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE,
                        VG_MERGE_CAR },

/* New Biosym      */ { FORM_BIOSYM         , "BIOSYM"    , "car" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        VG_MERGE_CAR },

/* IFF             */ { FORM_IFF            , "IFF"       , "iff" ,
                        FORM_FLAG_CONN|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE,
                        VG_MERGE_ALL },

/* CSSR            */ { FORM_CSSR           , "CSSR"      , "cssr",
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_ATMCHARGE|VG_MERGE_CONN },

/* Mopac Int.      */ { FORM_MOPINT         , "MOPINT"    , "dat" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_NONE,
                        VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_ATMCHARGE },

/* Xyz             */ { FORM_XYZ            , "XYZ"       , "xyz" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD },

/* PDBQ            */ { FORM_PDB_Q          , "PDBQ"      , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE,
                        VG_MERGE_PDB },

/* Quanta Surface  */ { FORM_QUANTA_SRF     , "QUANTASRF" , "srf" ,
                        0,
                        SRF_QUANTA|SRF_PROP_VDW,
                        VG_MERGE_NONE },

/* Insight Surf.   */ { FORM_BIOSYM_SRF     , "BIOSYMSRF" , "srf" ,
                        FORM_FLAG_STDOUT,
                        SRF_INSIGHT|SRF_PROP_VDW,
                        VG_MERGE_NONE },

/* PDB Fat         */ { FORM_PDB_FAT        , "PDBF"      , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE,
                        VG_MERGE_PDB|VG_MERGE_ATMCHARGE|VG_MERGE_ATMTYPE },

/* QMC             */ { FORM_QMC            , "QMC"       , "qmc" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_ATMCHARGE|VG_MERGE_CONN },

/* Quanta Msf      */ { FORM_QUANTA_MSF     , "MSF"       , "msf" ,
                        FORM_FLAG_CONN|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ|VG_MERGE_ATMCHARGE },

/* VRML Dot Surf.  */ { FORM_VRML_SRF_POINTS, "VRMLPTS"   , "wrl" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_VDW,
                        MS_NONE,
                        VG_MERGE_NONE },

/* VRML CPK        */ { FORM_VRML_SRF_CPK   , "VRMLCPK"   , "wrl" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE,
                        VG_MERGE_NONE },

/* VRML wireframe  */ { FORM_VRML           , "VRML"      , "wrl" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL,
                        MS_NONE },
/* VRML Solid Srf  */ { FORM_VRML_SOLID     , "VRMLSOL"   , "wrl" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_VDW,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Informations    */ { FORM_INFO           , "INFO"      , "inf" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Fasta           */ { FORM_FASTA          , "FASTA"     , "fas" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Inter. Energy   */ { FORM_ENER_CVFF      , "CVFF"      , "ene" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Sybyl Mol 2     */ { FORM_MOL2           , "MOL2"      , "ml2",
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_MOL2 },

/* CHARMm CRD      */ { FORM_CRD            , "CRD"       , "CRD" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ|VG_MERGE_ATMCHARGE },

/* Gromos          */ { FORM_GROMOS         , "GROMOS"    , "gro" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ },

/* Quanta LogP Srf */ { FORM_QUANTA_LOGP    , "QUANTALOGP", "srf" ,
                        FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Quanta Mep Srf  */ { FORM_QUANTA_MEP     , "QUANTAMEP" , "srf" ,
                        FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_VDW,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Gromos nm       */ { FORM_GROMOS_NM      , "GROMOSNM"  , "gro" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ },

/* CSV Plot        */ { FORM_PLOT_CSV       , "CSV"       , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_ALL,
                        VG_MERGE_NONE },

/* Quanta Plot     */ { FORM_PLOT_QUANTA    , "QUANTAPLT" , "plt" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_ALL,
                        VG_MERGE_NONE },

/* Binary Plot     */ { FORM_PLOT_BIN       , "BINPLT"    , "bin" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_ALL,
                        VG_MERGE_NONE },

/* COMFA fld       */ { FORM_COMFAFLD       , "COMFAFLD"  , "fld" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CHARGE,
                        MS_VLOGP,
                        VG_MERGE_NONE },

/* OpenGL          */ { FORM_OPENGL         , "OPENGL"    , ""    ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_VDW,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Quanta ILM Srf  */ { FORM_QUANTA_ILM     , "QUANTAILM" , "srf"  ,
                        FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_NONE },

/* HyperChem HIN   */ { FORM_HIN            , "HIN"       , "hin",
                        FORM_FLAG_INONLY|FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_RESNAME|VG_MERGE_RESSEQ|VG_MERGE_SEGMENTS|VG_MERGE_ATMCHARGE|VG_MERGE_ATMTYPE },

/* PDB ATDL        */ { FORM_PDB_ATDL       , "PDBA"     , "pdb" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_FFCALC|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        VG_MERGE_PDB|VG_MERGE_ATMCHARGE|VG_MERGE_ATMTYPE,
                        VG_MERGE_NONE },

/* MDL             */ { FORM_MDL            , "MDLMOL"   , "mol" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD },

/* GAMESS          */ { FORM_GAMESS         , "GAMESS"   , "inp" ,
                        FORM_FLAG_STDOUT,
                        MS_NONE,
                        VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_ATMCHARGE },

/* ALCHEMY         */ { FORM_ALCHEMY        , "ALCHEMY"  , "alc" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_ATMCHARGE|VG_MERGE_CONN },

/* Csv Surface     */ { FORM_CSV_SRF        , "CSVSRF"   , "csv" ,
                        FORM_FLAG_STDOUT|SRF_CSV|SRF_PROP_VDW,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Csv ILM Srf     */ { FORM_CSV_ILM        , "CSVILM"   , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Csv LogP Srf    */ { FORM_CSV_LOGP       , "CSVLOGP"  , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_VDW|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Csv Mep Srf     */ { FORM_CSV_MEP        , "CSVMEP"   , "csv" ,
                        FORM_FLAG_STDOUT|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_VDW,
                        MS_NONE,
                        VG_MERGE_NONE },

/* PSF X-Plor      */ { FORM_PSFX          , "PSFX"      , "psf",
                        FORM_FLAG_STDOUT|FORM_FLAG_FFCALC|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHARGE|FORM_FLAG_CHKCHG|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_NONE },

/* Chem3D          */ { FORM_C3DCC1        , "CC1"       , "cc1",
                        FORM_FLAG_INONLY|FORM_FLAG_STDOUT|FORM_FLAG_CONN|FORM_FLAG_CONNAL|FORM_FLAG_CHKFF|FORM_FLAG_RINGS,
                        MS_NONE,
                        VG_MERGE_ATMNAME|VG_MERGE_ELEMENT|VG_MERGE_COORD|VG_MERGE_ATMTYPE },

/* End */             { 0                   , NULL        , NULL,
                        FORM_FLAG_NONE,
                        MS_NONE,
                        VG_MERGE_NONE}
};
#else
extern FILEFORMAT  FileInfo[];
#endif
#endif


