
/*************************************************
****     VEGA - Gasteiger-Marsilli Charges    ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "gasteiger.h"


VG_BOOL Gasteiger(char *Template, ATOMO *InizAtm, VG_ULONG TotAtm, VG_BOOL ActiveOnly)
{
  char			Buf[256], *Ptr;
  FILE			*FH;
  float			*x, *xx;
  float			a, b, c, d, Charge;
  float			d1, d2, z1, q1;
  GASTPAR		*InizPar;
  VG_OCHAR		AtmType;
  register ATOMO        *Atm, *Atm2;
  register GASTPAR	*Gast;
  VG_UWORD		k;
  VG_ULONG		i, j, t;

  VG_BOOL		Chk    = TRUE;
  VG_BOOL		Ret    = FALSE;
  VG_ULONG		Ass    = 0;
  VG_ULONG              SelAtm = 0;
  VG_UWORD		cycle  = 0;

  /**** Count the atoms ****/

  if (ActiveOnly) {
    for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
      if ((!ActiveOnly) || (Atm -> Active)) ++SelAtm;
    } /* End of for */
  } else SelAtm = TotalAtm;

  if ((FH = (FILE *)fopen(Template, "r"))) {
    if ((InizPar = (GASTPAR *)Alloca(sizeof(GASTPAR) * TotAtm))) {
      if ((xx = (float *)Alloca(sizeof(float) * TotAtm))) {

       /**** Load Gasteiger parameters ****/

        while((Chk) && (fgets(Buf, 255, FH))) {
          if ((*Buf != '\n') && (*Buf != '#') && (*Buf != ';')) {
            k          = 0;
            AtmType.DL = 0;
            for(Ptr = Buf; *Ptr; ++Ptr) {
              if ((*Ptr != '\n') && (*Ptr != ' ') && (*Ptr != '\t')) {
                AtmType.C[k++] = *Ptr;
                if (k == 8) break;
              } else if (k) break;
            } /* End of for */
            if (*Ptr) {
              sscanf(Buf, "%*s %f %f %f %*s %f", &a, &b, &c, &Charge);
              d = a + b + c;
              if (d == 0.0f) d = 1.0f;
              x    = xx;
              Gast = InizPar;
              for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
                if (((!ActiveOnly) || (Atm -> Active)) &&
                    (Atm -> Pot.DL == AtmType.DL)) {
                  Gast -> a      = a;
                  Gast -> b      = b;
                  Gast -> c      = c;
                  Gast -> d      = d;
                  Atm  -> Charge = Charge;
                  *x             = a;
                  ++Ass;
                  if (Ass == SelAtm) {
                    Chk = FALSE;
                    break;
                  }
                }
                ++Gast;
                ++x;
              } /* End of for */
            }
          }
        } /* End of while */

        /**** Check if all atoms have got the parameters ****/

        Gast = InizPar;
        for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
          if ((!ActiveOnly) || (Atm -> Active)) {
            if (!Gast -> d) {
              CatPrintf(stdout, MSG_GASTEIGER_ERR_NOPAR, Atm -> Pot.C);
              Gast -> d = 1.0;
            }
          }
          ++Gast;
        } /* End of while */
        /**** Smoothing charges ****/

        z1 = 1.0f;
        do {
          z1  *= 0.5f;
          d1   = 0.0f;
          i    = 0;
          for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
            if ((!ActiveOnly) || (Atm -> Active)) {
              if (InizPar[i].d != 1.0) {
                q1 = Atm -> Charge;
                for (j = 0; j < (VG_ULONG)Atm -> NSost; j++) {
                  if ((!ActiveOnly) || (Atm -> Conn[j] -> Active)) {
                    t = (Atm -> Conn[j] -> Num) - 1;
                    if (InizPar[t].d != 1.0) {
                      Atm2 = Atm -> Conn[j];
                      d2 = InizPar[t].d;
                      if (xx[t] > xx[i]) d2 = InizPar[i].d;
                      if (Atm -> Elem.S == *(VG_WORD *)"H")
                        d2 = 20.02f;
                      if (Atm2 -> Elem.S == *(VG_WORD *)"H")
                        d2 = 20.02f;
                      Atm -> Charge += (xx[t] - xx[i]) / d2 * z1;
                    }
                  }
                } /* End of for */
                q1 = Atm -> Charge - q1;
                FastAbs(q1);
                if (q1 > d1) d1 = q1;
              }
            }
            ++i;
          } /* End of for */

          if (d1 >= 0.001f) {
            i = 0;
            for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
              if ((!ActiveOnly) || (Atm -> Active)) {
                xx[i] = InizPar[i].a + InizPar[i].b * Atm -> Charge +
                        InizPar[i].c * Quad(Atm -> Charge);
              }
              ++i;
            } /* End of for */
/*
            Atm = InizAtm;
            for(i = 0; i < TotAtm; ++i) {
              xx[i] = InizPar[i].a + InizPar[i].b * Atm -> Charge +
                      InizPar[i].c * Quad(Atm -> Charge);
              Atm = Atm -> Ptr;
            }
*/
          }
          cycle++;
        } while ((d1 > 0.001f) && (cycle <= 5));
        Ret = TRUE;

        /**** Calculate the total charge ****/

        a = 0.0f;
        for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
          if ((!ActiveOnly) || (Atm -> Active))
            a += Atm -> Charge;
        } /* End of for */
        b = a;
        FastAbs(b);
        if (b < 0.01f) a = 0.0f;
        if (!GLOBSW_STDOUT) CatPrintf(stdout, MSG_GASTEIGER_TOTCHG, a);
        FREE(xx);
      }
      FREE(InizPar);
    }
    fclose(FH);
  }

  return Ret;
}
