
/*************************************************
****   VEGA - Anti aliasing & depth cueing    ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/

/*
 * Please remember that the anti-aliasing hardware mode works only if your
 * graphic card has this capability. If you have a partial implementation may
 * work only with the lines but not with the polygons.
 */

#ifdef __WIN32__
#  include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "gl_global.h"
#include "gl_prefs.h"


static VG_UWORD         PrevAa;


/**** Change the anti aliasing mode ****/

void GL_AntiAlias(VG_UWORD AaMode, VG_BOOL Force)
{
  if ((AaMode != PrevAa) || (Force)) {

    /**** Disable the previous anti-alias mode ****/

    switch(PrevAa) {
    case VG_GLAA_HARDWARE:              /* Hardware mode */
      glDisable(GL_POINT_SMOOTH);
      glDisable(GL_LINE_SMOOTH);
      glDisable(GL_POLYGON_SMOOTH);
      glDisable(GL_BLEND);
      break;

    case VG_GLAA_ACCUM:
      break;
    } /* End of switch */

    /**** Enable the anti-alias ****/

    switch(AaMode) {
    case VG_GLAA_HARDWARE:              /* Hardware mode */
      glFinish();
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
      glEnable(GL_POINT_SMOOTH);
      glEnable(GL_LINE_SMOOTH);
      glEnable(GL_POLYGON_SMOOTH);
      glHint(GL_POINT_SMOOTH_HINT  , GL_NICEST);
      glHint(GL_LINE_SMOOTH_HINT   , GL_NICEST);
      glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);
      break;

    case VG_GLAA_ACCUM:
      break;
    } /* End of switch */

    PrevAa = AaMode;
  }
}


/**** Set the depth-cue mode ****/

void GL_DepthCue(VG_BOOL DepthCue)
{
  if (DepthCue)
    glEnable(GL_FOG);
  else
    glDisable(GL_FOG);
}

