
/*************************************************
****     VEGA - Routines for OpenGL Demo      ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <gl\gl.h>
#include <stdio.h>

#include "../../Fmod/api/inc/fmod.h"

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "formats.h"
#include "gl_global.h"
#include "gl_colors.h"
#include "gl_demo.h"
#include "gl_menu.h"
#include "gl_prefs.h"
#include "gl_wrkspace.h"
#include "surface.h"

#ifdef WIN32
#  include "Win32\winutils.h"
#endif

#include "gl_dmprg.h"


/**** Local variables ****/

static DEMO_EVENT    *PC;
static float         DemoCnt;
static GLPREFS       *GlPrfBack;
static VG_WRKSPACE   *WksDemo, *WksOld;

/**** Local prototypes ****/

static VG_BOOL GL_DemoGoto(void);


/**** Callback function ****/

VG_BOOL GL_DemoCallBack(VG_GLPREFS *Prf, float TS, VG_BOOL *Force)
{
  char                  *Str;
  GLYPHMETRICS          Metrics;
  register ATOMO        *Atm;
  VG_ULONG              Len;

  VG_BOOL               Ret = TRUE;
  VG_BOOL               Brk = FALSE;

  while ((Ret) && (!Brk)) {
    switch(PC -> Event) {

    case DEMO_COM_ATMLBL:
      GL_SetAtmLbl(BegAtm, PC -> Par.I);
      break;

    case DEMO_COM_CATTEXT:
      if (PC -> Par.I)
        Prf -> TxtStr = GetStr(PC -> Par.I);
      else
        Prf -> TxtStr = NULL;
      break;

    case DEMO_COM_CENTX:
      Prf -> ViewCenter.x = PC -> Par.F;
      break;

    case DEMO_COM_CENTY:
      Prf -> ViewCenter.y = PC -> Par.F;
      break;

    case DEMO_COM_CENTZ:
      Prf -> ViewCenter.z = PC -> Par.F;
      break;

    case DEMO_COM_COLAT:
      GL_ColorByAtm(BegAtm);
      break;

    case DEMO_COM_COLOR:
      GL_ColorMol(BegAtm, PC -> Par.I);
      break;

    case DEMO_COM_DRAW:
      Prf -> DrawMode = PC -> Par.I;
      break;

    case DEMO_COM_EXPLODE:
      DemoCnt += TS;
      if (DemoCnt < (float)(PC -> Par.I)) {
        for(Atm = BegAtm;Atm; Atm = Atm -> Ptr) {
          Atm -> x *= PC -> Par.F;
          Atm -> y *= PC -> Par.F;
          Atm -> z *= PC -> Par.F;
        }
        Brk = TRUE;
        --PC;
      } else DemoCnt = 0.0f;
      break;

    case DEMO_COM_FX:
      Prf -> DemoFX = !Prf -> DemoFX;
      if (Prf -> DemoFX)
        glEnable(GL_TEXTURE_2D);
      else
        glDisable(GL_TEXTURE_2D);
      break;

    case DEMO_COM_GOTO:
      GL_DemoGoto();
      break;

    case DEMO_COM_IF:
      if (PC -> Par.F == DMFL_NOTSUBTITLES) {
        if (!Prf -> DemoText) GL_DemoGoto();
      } /* End of switch */
      break;

    case DEMO_COM_LOAD:
      if (BegAtm = Loader(GL_DemoGetPath(PC -> Par.C), &TotalAtm, NULL, NULL, 1,
                          &BegSrf, &TotalSrf)) {
        if (BegAtm != (ATOMO *)-2) {
          Connect(BegAtm, TotalAtm, VG_CONNTOL, FALSE);
          AssignVdwNew(BegAtm, 0, 0);
          *Force          = TRUE;
        } else BegAtm = NULL;
      } else Ret = FALSE;
      break;

    case DEMO_COM_NEW:
      GL_Reset(Prf);
      Prf -> Animation = TRUE;
      Prf -> DemoFX    = FALSE;
      break;

    case DEMO_COM_NORM:
      Normalize(BegAtm);
      break;

    case DEMO_COM_PLAYSONG:

#if defined(WIN32) || defined(LINUX)
      if (ViewPrefs.PlayMusic)
        GL_FmodPlayStream(GL_DemoGetPath(PC -> Par.C), FSOUND_LOOP_NORMAL);
#endif
      break;

    case DEMO_COM_ROTX:
      Prf -> StepRot.x = PC -> Par.F;
      break;

    case DEMO_COM_ROTY:
      Prf -> StepRot.y = PC -> Par.F;
      break;

    case DEMO_COM_ROTZ:
      Prf -> StepRot.z = PC -> Par.F;
      break;

    case DEMO_COM_SKIP:
      PC += PC -> Par.I;
      break;

    case DEMO_COM_SLEEP:
      DemoCnt += TS;
      if (DemoCnt < (float)(PC -> Par.I)) {
        Brk = TRUE;
        --PC;
      } else DemoCnt = 0.0f;
      break;

    case DEMO_COM_SOLVS:
      Prefs.SOL_SHAPE = SOL_SHAPE_SPHERE;
      Prefs.SOL_RAD   = PC -> Par.F;
      GLOBSW_CONNCALC = TRUE;
      Ret = Solvate(GL_DemoGetPath(".." C_DIRSEP "Data" C_DIRSEP "Clusters"
                    C_DIRSEP "Water"), BegAtm, &TotalAtm, NULL);
      break;

    case DEMO_COM_STEPZ:
      Prf -> StepTrans.z = PC -> Par.F;
      break;

    case DEMO_COM_STOPSONG:
#if defined(WIN32) || defined(LINUX)
      GL_FmodReleaseStream();
#endif
      break;

    case DEMO_COM_SURFCALC:
      BegSrf = SrfCalc(&LastSrf, &TotalSrf, BegAtm, TotalAtm, PC -> Par.I, 0.0,
                       SRF_PROP_MEP, NULL, SRF_FLG_ALLATM);
      ViewPrefs.SrfAct = TRUE;
      break;

    case DEMO_COM_SURFCLR:
      SrfClose();
      break;

    case DEMO_COM_SURFCOLAT:
      GL_ColorSrfAtm(BegSrf, BegAtm);
      break;

    case DEMO_COM_SURFCOLP:
      SrfColorByVal(BegSrf);
      break;

    case DEMO_COM_TEXT:
      if (*PC -> Par.C)
        Prf -> TxtStr = PC -> Par.C;
      else Prf -> TxtStr = NULL;
      break;

    case DEMO_COM_VOLUME:
#if defined(WIN32) || defined(LINUX)
      GL_FmodSetVolume(PC -> Par.I);
#endif
      break;

    } /* End of switch */

    ++PC;
    if (PC -> Event == DEMO_COM_LOOP) {
      PC = EventList;
      break;
    }
  }

  if (!Ret)
    GL_DemoStop(Prf);

  return Ret;
}


/**** Goto function ****/

static VG_BOOL GL_DemoGoto(void)
{
  register DEMO_EVENT    *NewPC = EventList;
  VG_BOOL                Ret    = TRUE;

  while(Ret) {
    if (NewPC -> Event != DEMO_COM_END) {
      if ((NewPC -> Event == DEMO_COM_LABEL) && (PC -> Par.I == NewPC -> Par.I)) {
        PC = NewPC;
        break;
      }
      ++NewPC;
    } else Ret = FALSE;
  } /* End of for */

  return Ret;
}


/**** Initialize the OpenGL demo ****/

void GL_DemoStart(VG_GLPREFS *Prf)
{
  if (FileExists(GL_DemoGetPath("ReadMe.txt"))) {

    /**** Create a new workspace and enable it ****/

    if ((WksDemo = GL_WksAdd()) != NULL) {
      WksOld = WksCur;
      GL_WksChange(WksDemo, 0, FALSE);
      GL_WksSetName("Demo");
      GL_WksLock(FALSE);
      GL_ChangeMenu(VG_CM_DEMO);
    }

    /**** Backup the preferences ****/

    GlPrfBack = GlPrefs;
    if ((GlPrefs = Alloca(sizeof(GLPREFS))) != NULL) {
      memcpy(GlPrefs, GlPrfBack, sizeof(GLPREFS));
      GL_PrefsDefaultDisplay(GlPrefs);

      GL_Reset(Prf);
      GL_DemoInitFX();
      GL_FmodInit();

      DemoCnt                   = 0.0f;
      PC                        = EventList;
      Prf -> Animation          = TRUE;
      Prf -> Demo               = TRUE;
      GlPrefs -> GlMultiVecWire = TRUE;
      GL_DrawScene(Prf, TRUE);
      GL_KillFont();
      GL_BuildFont(-12, 8);
    } else GlPrefs = GlPrfBack;
  } else {
    GL_ChangeMenu(VG_CM_NEW);
    CatErr(MSG_GLDEMO_ERR_NOTINST);
  }
}


/**** Stop the OpenGL demo ****/

void GL_DemoStop(VG_GLPREFS *Prf)
{
#if defined(WIN32) || defined(LINUX)
  GL_FmodReleaseStream();
#endif
  Prf -> Demo = FALSE;
  if (Prf -> DemoFX) {
    glDisable(GL_TEXTURE_2D);
    Prf -> DemoFX = FALSE;
  }
  GL_WksUnLock();
  GL_WksRemove(WksDemo, 0, FALSE);

  GL_DemoRelaseFX();
  FREE(GlPrefs);
  GlPrefs = GlPrfBack;
  GL_KillFont();
  GL_BuildFont(-11, 5);
  GL_WksChange(WksOld, 0, TRUE);
}


/**** Get the demo directory with path ****/

char *GL_DemoGetPath(char *File)
{
  static char         Buf[512];

  GetPrgPath(Buf, FALSE);
  strcat(Buf, "Demo\\");
  strcat(Buf, File);

  return &Buf[0];
}

