
/*************************************************
****                   VEGA                   ****
****      Routines for OpenGL Demo V1.0       ****
**** Copyright 1996-2002, Alessandro Pedretti ****
*************************************************/

/**** Tokens ****/

#define  DEMO_COM_ATMLBL        1
#define  DEMO_COM_CATTEXT       2
#define  DEMO_COM_CENTX         3
#define  DEMO_COM_CENTY         4
#define  DEMO_COM_CENTZ         5
#define  DEMO_COM_COLOR         6
#define  DEMO_COM_COLAT         7
#define  DEMO_COM_DRAW          8
#define  DEMO_COM_END           9
#define  DEMO_COM_EXPLODE      10
#define  DEMO_COM_FX           11
#define  DEMO_COM_GOTO         12
#define  DEMO_COM_IF           13
#define  DEMO_COM_LABEL        14
#define  DEMO_COM_LOAD         15
#define  DEMO_COM_LOOP         16
#define  DEMO_COM_NEW          17
#define  DEMO_COM_NORM         18
#define  DEMO_COM_PLAYSONG     19
#define  DEMO_COM_ROTX         20
#define  DEMO_COM_ROTY         21
#define  DEMO_COM_ROTZ         22
#define  DEMO_COM_SOLVS        23
#define  DEMO_COM_SKIP         24
#define  DEMO_COM_SLEEP        25
#define  DEMO_COM_STEPZ        26
#define  DEMO_COM_STOPSONG     27
#define  DEMO_COM_SURFCALC     28
#define  DEMO_COM_SURFCLR      29
#define  DEMO_COM_SURFCOLAT    30
#define  DEMO_COM_SURFCOLP     31
#define  DEMO_COM_TEXT         32
#define  DEMO_COM_VOLUME       33

/**** Demo language macros ****/

#define  GLDM_ATMLBL(X)          {DEMO_COM_ATMLBL   , {  0,   0, (X)}},
#define  GLDM_BEGIN              static DEMO_EVENT EventList[] = {
#define  GLDM_CATTEXT(X)         {DEMO_COM_CATTEXT  , {  0,   0, (X)}},
#define  GLDM_CENTX(X)           {DEMO_COM_CENTX    , {  0, (X),   0}},
#define  GLDM_CENTY(X)           {DEMO_COM_CENTY    , {  0, (X),   0}},
#define  GLDM_CENTZ(X)           {DEMO_COM_CENTZ    , {  0, (X),   0}},
#define  GLDM_COLAT              {DEMO_COM_COLAT    , {  0,   0,   0}},
#define  GLDM_COLOR(X)           {DEMO_COM_COLOR    , {  0,   0, (X)}},
#define  GLDM_DRAW(X)            {DEMO_COM_DRAW     , {  0,   0, (X)}},
#define  GLDM_EXPLODE(X, T)      {DEMO_COM_EXPLODE  , {  0, (X), (T)}},
#define  GLDM_END                {DEMO_COM_END      , {  0,   0,   0}}};
#define  GLDM_FX(X)              {DEMO_COM_FX       , {  0,   0, (X)}},
#define  GLDM_IF(X, T)           {DEMO_COM_IF       , {  0, (X), (T)}},
#define  GLDM_GOTO(X)            {DEMO_COM_GOTO     , {  0,   0, (X)}},
#define  GLDM_LABEL(X)           {DEMO_COM_LABEL    , {  0,   0, (X)}},
#define  GLDM_LOAD(X)            {DEMO_COM_LOAD     , {(X),   0,   0}},
#define  GLDM_LOOP               {DEMO_COM_LOOP     , {  0,   0,   0}},
#define  GLDM_NEW                {DEMO_COM_NEW      , {  0,   0,   0}},
#define  GLDM_NORM               {DEMO_COM_NORM     , {  0,   0,   0}},
#define  GLDM_PLAYSONG(X)        {DEMO_COM_PLAYSONG , {(X),   0,   0}},
#define  GLDM_ROTX(X)            {DEMO_COM_ROTX     , {  0, (X),   0}},
#define  GLDM_ROTY(X)            {DEMO_COM_ROTY     , {  0, (X),   0}},
#define  GLDM_ROTZ(X)            {DEMO_COM_ROTZ     , {  0, (X),   0}},
#define  GLDM_SKIP(X)            {DEMO_COM_SKIP     , {  0,   0, (X)}},
#define  GLDM_SLEEP(X)           {DEMO_COM_SLEEP    , {  0,   0, (X)}},
#define  GLDM_SOLVS(X)           {DEMO_COM_SOLVS    , {  0, (X),   0}},
#define  GLDM_STEPZ(X)           {DEMO_COM_STEPZ    , {  0, (X),   0}},
#define  GLDM_STOPSONG           {DEMO_COM_STOPSONG , {  0,   0,   0}},
#define  GLDM_SURFCALC(X)        {DEMO_COM_SURFCALC , {  0,   0, (X)}},
#define  GLDM_SURFCLR            {DEMO_COM_SURFCLR  , {  0,   0,   0}},
#define  GLDM_SURFCOLAT          {DEMO_COM_SURFCOLAT, {  0,   0,   0}},
#define  GLDM_SURFCOLP           {DEMO_COM_SURFCOLP , {  0,   0,   0}},
#define  GLDM_TEXT(S, P)         {DEMO_COM_TEXT     , {(S),   0, (P)}},
#define  GLDM_VOLUME(X)          {DEMO_COM_VOLUME   , {  0,   0, (X)}},

/**** Demo language flags ****/

#define  DMFL_NOTSUBTITLES       1


/**** Text positions ****/

#define  TXT_LOWLEFT             0
#define  TXT_CENTER              1


/**** Position Matrix ****/

/*
static const struct TEXTPOS {
  float         x, y;
} TextPos[] = {{-8.0, -8.0},   // Lower left
               { 0.0,  0.0},   // Center
              };
*/

typedef struct {
  char          *C;
  float         F;
  int           I;
} DM_PAR;


typedef struct {
  VG_UWORD      Event;
  DM_PAR        Par;
} DEMO_EVENT;

