
/*************************************************
****          VEGA - OpenGL objects           ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef  __GL_OBJS
#  define  __GL_OBJS

#ifndef __VG_TYPES
#  include "vgtypes.h"
#endif

/**** Object types ****/

#define  VG_GLOBJ_NONE          0
#define  VG_GLOBJ_ANGA          1
#define  VG_GLOBJ_BONDA         2
#define  VG_GLOBJ_CUBE          3
#define  VG_GLOBJ_CROSS         4
#define  VG_GLOBJ_CYLINDER      5
#define  VG_GLOBJ_DISC          6
#define  VG_GLOBJ_DISCA         7
#define  VG_GLOBJ_DISTA         8
#define  VG_GLOBJ_LINE          9
#define  VG_GLOBJ_LINEA        10
#define  VG_GLOBJ_PLANGA       11
#define  VG_GLOBJ_TEXT3        12
#define  VG_GLOBJ_TORA         13
#define  VG_GLOBJ_TRIANGLE     14
#define  VG_GLOBJ_TRIANGLEA    15

/**** Flags ****/

#define  VG_OBJFLAG_NONE        0
#define  VG_OBJFLAG_BLEND       1
#define  VG_OBJFLAG_MONITOR     2
#define  VG_OBJFLAG_STIPPLE     4
#define  VG_OBJFLAG_HIDE        8

/**** Groups ****/

#define  VG_OBJGRP_GENERIC      0
#define  VG_OBJGRP_ANGLE        1
#define  VG_OBJGRP_BLDCLUST     2
#define  VG_OBJGRP_DISTANCE     3
#define  VG_OBJGRP_OVERLAY      4
#define  VG_OBJGRP_PLANG        5
#define  VG_OBJGRP_TORSION      6
#define  VG_OBJGRP_BOND         7

#define  VG_OBJGRP_SELECT       0x8000

/**** Colors ****/

#define  VG_MEASCOL_ANGLE        0xffffffaa
#define  VG_MEASCOL_DISTANCE     0xffffffff
#define  VG_MEASCOL_PLANGCUBE    0xffffffff
#define  VG_MEASCOL_PLANGLINE    0xff00ffff
#define  VG_MEASCOL_SUPLINE      0xffffffff
#define  VG_MEASCOL_TEXT         0xffff00ff
#define  VG_MEASCOL_TORSION      0xffffffaa

/**** Vertex ****/

typedef struct {
  float         Vect[3];
  VG_LONG       Color;
} VG_GLVERTEX;

/**** Atom vertex  ****/

typedef struct {
  ATOMO         *Atm;
  VG_LONG       Color;
} VG_GLVERTEXA;

/**** Angle monitor between three atoms ****/

typedef struct {
  ATOMO         *Atm[3];
  VG_LONG       Color;
  char          LabelStr[4];
} VG_GLANGA;

/**** Cylinder around a bond ****/

typedef struct {
  ATOMO         *Atm[2];
  VG_LONG       Res;
  VG_LONG       Color;
  float         Rad;
} VG_GLBONDA;

/**** Cube ****/

typedef struct {
  VG_GLVERTEX   Vertex[8];
} VG_GLCUBE;

/**** Cross ****/

typedef struct {
  VG_GLVERTEX   Vertex;
  float         Size;
} VG_GLCROSS;

/**** Cylinder ****/

typedef struct {
  VG_GLVERTEX   Vertex[2];
  VG_LONG       Res;
  float         Rad;
  VG_BOOL       Disc;
} VG_GLCYLINDER;

/**** Disc ****/

typedef struct {
  VG_GLVERTEX   Vertex[2];
  VG_LONG       RodRes;
  float         RodRad;
  float         RodTopRad;
} VG_GLDISC;

/**** Disc (atom coordinates) ****/

typedef struct {
  VG_GLVERTEXA  Vertex[4];
  VG_LONG       RodRes;
  float         RodRad;
  float         RodTopRad;
} VG_GLDISCA;

/**** Distance monitor between two atoms ****/

typedef struct {
  ATOMO         *Atm[2];
  VG_LONG       Color;
  char          LabelStr[4];
} VG_GLDISTA;

/**** Line ****/

typedef struct {
  VG_GLVERTEX   Vertex[2];
} VG_GLLINE;

/**** Line (atom coordinates) ****/

typedef struct {
  VG_GLVERTEXA  Vertex[2];
} VG_GLLINEA;

/**** Object ****/

typedef struct _VG_GLOBJ {
  struct _VG_GLOBJ      *Prev;          /* Ponter to previous object */
  struct _VG_GLOBJ      *Next;          /* Pointer to next object    */
  VG_UWORD              Group;          /* Object group              */
  VG_UWORD              Type;           /* Object type               */
  VG_LONG               Flags;          /* Rendering flags           */
  void                  *Data;          /* Pointer to data           */
  void                  *UserData;      /* Pointer to user data      */
} VG_GLOBJ;

/**** Plane angle monitor between six atoms ****/

typedef struct {
  ATOMO         *Atm[6];
  VG_LONG       Color;
  char          LabelStr[4];
} VG_GLPLANGA;

/**** Text ****/

typedef struct {
  VG_GLVERTEX   Vertex;
  char          Str[4];
} VG_GLTEXT;

/**** Torsion monitor between three atoms ****/

typedef struct {
  ATOMO         *Atm[4];
  VG_LONG       Color;
  char          LabelStr[4];
} VG_GLTORA;

/**** Triangle ****/

typedef struct {
  VG_GLVERTEX   Vertex[3];
} VG_GLTRIANGLE;

/**** Triangle (atom coordinates) ****/

typedef struct {
  VG_GLVERTEXA  Vertex[3];
} VG_GLTRIANGLEA;

/**** Global variables ****/

extern VG_GLOBJ         *BegObj, *LastObj;

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_GLOBJ *GL_ObjAdd(VG_ULONG, VG_ULONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjAngA(ATOMO **, VG_LONG, VG_LONG, VG_UWORD, char *);
VG_GLOBJ *GL_ObjBondA(ATOMO *, ATOMO *, VG_LONG, float, VG_LONG, VG_LONG, VG_UWORD);
void      GL_ObjChgText(VG_GLOBJ *, char *);
void      GL_ObjChgVertex(VG_GLVERTEX *, float *, VG_LONG);
void      GL_ObjChgVertexA(VG_GLVERTEXA *, ATOMO *, VG_LONG);
VG_GLOBJ *GL_ObjCCube(float *, float, VG_LONG, VG_LONG, VG_UWORD);
void      GL_ObjColor(VG_LONG);
VG_GLOBJ *GL_ObjCube(float [6][3], VG_LONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjCross(float *, float, VG_LONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjCylinder(float *, float *, VG_LONG, float, VG_LONG, VG_BOOL, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjDisc(float *, float *, VG_LONG, float, float, VG_LONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjDiscA(ATOMO **, VG_LONG, float, float, VG_LONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjDistA(ATOMO *, ATOMO *, VG_LONG, VG_LONG, VG_UWORD, char *);
VG_GLOBJ *GL_ObjFind(VG_GLOBJ *, VG_UWORD, VG_UWORD, void *);
void      GL_ObjHideAll(VG_BOOL);
VG_GLOBJ *GL_ObjLine(float *, float *, VG_LONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjLineA(ATOMO *, ATOMO *, VG_LONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjPlangA(ATOMO **, VG_LONG, VG_LONG, VG_UWORD, char *);
VG_BOOL   GL_ObjRemove(VG_UWORD *, VG_UWORD);
void      GL_ObjRemoveAll(void);
void      GL_ObjRemoveAtm(ATOMO *);
VG_BOOL   GL_ObjRemoveGrp(VG_UWORD);
void      GL_ObjRemoveSingle(VG_GLOBJ **, VG_GLOBJ **, VG_GLOBJ *);
void      GL_ObjRemoveSingleSafe(VG_GLOBJ **, VG_GLOBJ **, VG_GLOBJ **);
void      GL_ObjRemoveSingleWks(VG_GLOBJ **);
void      GL_ObjRemoveUser(VG_UWORD, void *, VG_BOOL);
void      GL_ObjRender(void);
void      GL_ObjRenderCross(VG_GLVERTEX *, float);
void      GL_ObjRenderCube(VG_GLVERTEX *);
void      GL_ObjRenderCCube(float *, float);
VG_GLOBJ *GL_ObjText3(float *, VG_LONG, VG_LONG, VG_UWORD, char *, ...);
VG_GLOBJ *GL_ObjTorA(ATOMO **, VG_LONG, VG_LONG, VG_UWORD, char *);
VG_GLOBJ *GL_ObjTriangle(float [3][3], VG_LONG, VG_LONG, VG_UWORD);
VG_GLOBJ *GL_ObjTriangleA(ATOMO **, VG_LONG, VG_LONG, VG_UWORD);
void      GL_ObjVertex(VG_GLVERTEX *, VG_ULONG);
void      GL_ObjVertexA(VG_GLVERTEXA *, VG_ULONG);

#  ifdef __cplusplus
}
#  endif
#endif