
/*************************************************
****                   VEGA                   ****
****    Prefs for OpenGL graphic interface    ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __GL_PREFS_H
#define __GL_PREFS_H

#include "globdef.h"

/**** Constants ****/

#define  VG_GLPRF_VERSION          0x0100             /* 1.0 */
#define  VG_GLPRF_FILE             "glprefs.%d"
#define  VG_GLPRF_FILEHIST         4
#define  VG_GLPRF_FILELEN          30

#define  VG_DEF_CYLRES             10
#define  VG_DEF_LIQSCALE           0.2
#define  VG_DEF_SPHERERES          12

#ifdef BIG_ENDIAN
#  define  VG_GLPRF_HDR            0x56474c50
#else
#  define  VG_GLPRF_HDR            0x504c4756
#endif

/**** Window preferences ****/

typedef struct {
  VG_ULONG      PosX, PosY;             /* Position          */
  VG_ULONG      SizeX, SizeY;           /* Size              */
} WINPREFS;

/**** OpenGL general preferences ****/

typedef struct {
  VG_ULONG      Hdr;                               /* Header                  */
  VG_ULONG      Len;                               /* Structure lenght        */
  VG_UWORD      Version;                           /* Version                 */
  VG_UWORD      OsType;                            /* Operating system        */
  WINPREFS      MainWin;                           /* Main window             */
  WINPREFS      ConsoleWin;                        /* Console window          */
  char          LastFile[VG_GLPRF_FILEHIST][256];  /* Last opened files       */
  VG_UBYTE      GlSmoothWire;                      /* Smooth wireframe        */
  VG_UBYTE      MM_Connect;                        /* Connectivity            */
  VG_UWORD      MM_PackMode;                       /* Compression             */
  VG_UWORD      GlVdwSphereRes;                    /* Vdw sphere resolution   */
  VG_UWORD      GlCpkCylRes;                       /* Cpk cylinder resolution */
  float         GlCpkCylRad;                       /* Cpk cylinder radius     */
  float         GlCpkScale;                        /* Cpk VdW radius scale    */
  float         GlWireTick;                        /* Wireframe tickness      */
  float         GlLiqCylRad;                       /* Liquorice radius        */

  /**** Release 1.3.2 ***/

  float         GlVdwDotSize;                      /* Vdw dot size            */
  float         GlCpkSphereRes;                    /* Cpk sphere resolution   */
  float         GlZClip;                           /* Z clip                  */
  VG_UWORD      GlLiqCylRes;                       /* Liquorice cylinder res. */
  VG_UWORD      GlLiqSphereRes;                    /* Liquorice sphere res.   */
  VG_UBYTE      GlAntiAlias;                       /* Anti aliasing           */
  VG_UBYTE      GlDepthCue;                        /* Depth cueing            */

  /**** Release 1.4.0 ****/

  float         JoyRotStep;                        /* Joystick rotation step  */
  float         JoyScaleStep;                      /* Joystick scale step     */
  float         JoyTranStep;                       /* Joystick trans. step    */
  VG_UWORD      JoyPolling;                        /* Joystick polling        */
  VG_UBYTE      JoyActive;                         /* Joystick activated      */

  /**** Release 1.4.2 ****/

  VG_UBYTE      SmartMoveEnable;                   /* Enable the smart move   */
  VG_ULONG      SmartMoveAtoms;                    /* Max atom for std move   */

  /**** Release 1.5.0 ****/

  VG_UBYTE      MM_FixSav;                         /* Save the constraints    */
  VG_UBYTE      GlMultiVecWire;                    /* Multivector wireframe   */
} GLPREFS;

#ifdef __GL_PREFS_DEF
GLPREFS         *GlPrefs;

/**** Default values ****/

static const GLPREFS   GlPrefsDef = { VG_GLPRF_HDR,              /* Header                  */
                                      sizeof(GLPREFS),           /* Structure lenght        */
                                      VG_GLPRF_VERSION,          /* Version                 */
                                      VEGA_OSTYPE,               /* Operating system        */
                                      {0, 0, 640, 480},          /* Main window             */
                                      {0, 0,   0,   0},          /* Console Window          */
                                      {{""}, {""}, {""}, {""} }, /* Last opened files       */
                                      TRUE,                      /* Smooth wireframe        */
                                      TRUE,                      /* Connectivity            */
                                      0,                         /* Compression             */
                                      VG_DEF_SPHERERES,          /* Vdw sphere resolution   */
                                      VG_DEF_CYLRES,             /* Cpk cylinder resolution */
                                      0.1,                       /* Cpk cylinder radius     */
                                      0.2,                       /* Cpk VdW radius scale    */
                                      1.0,                       /* Wireframe tickness      */
                                      VG_DEF_LIQSCALE,           /* Liquorice radius        */

                                      /**** Release 1.3.2 ***/

                                      1.0,                       /* Vdw dot size            */
                                      VG_DEF_SPHERERES,          /* Cpk sphere resolution   */
                                      200.0,                     /* Z clip                  */
                                      VG_DEF_CYLRES,             /* Liquorice cylinder res. */
                                      VG_DEF_SPHERERES,          /* Liquorice sphere res.   */
                                      FALSE,                     /* Anti aliasing           */
                                      FALSE,                     /* Depth cueing            */

                                      /**** Release 1.4.0 ****/

                                      0.09,                      /* Joystick rotation step  */
                                      0.2,                       /* Joystick scale step     */
                                      1.0,                       /* Joystick trans. step    */
                                      100,                       /* Joystick polling        */
                                      FALSE,                     /* Joystick activated      */

                                      /**** Release 1.4.2 ****/

                                      TRUE,                      /* Enable the smart move   */
                                      500,                       /* Max atom for std move   */

                                      /**** Release 1.5.0 ****/

                                      FALSE,                     /* Save the constraints    */
                                      FALSE                      /* Multivector wireframe   */
                             };
#endif
extern GLPREFS  *GlPrefs;

/**** Prototypes ****/
#  ifdef __cplusplus
extern "C" {
#  endif

void    GL_PrefsAddLastFile(GLPREFS *, char *);
void    GL_PrefsDefaultDisplay(GLPREFS *);
char    *GL_PrefsGetLastFile(VG_ULONG, VG_BOOL);
void    GL_PrefsFree(GLPREFS *);
GLPREFS *GL_PrefsLoad(void);
VG_BOOL GL_PrefsSave(GLPREFS *);
void    GL_PrefsSet(GLPREFS *);
void    MC_RefreshLastFile(GLPREFS *, char *);

#  ifdef __cplusplus
}
#  endif
#endif