
/*************************************************
****     VEGA - HyperChem loader & saver      ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"


/**** HIN Loader ****/

ATOMO *HINLoad(FILE *IN, RECORD *Lin, VG_ULONG *TotAtomi)
{
  char		    AtmName[8], ResSeqStr[20], Tmp;
  VG_QCHAR          ResName, ResSeq;
  VG_ULONG          j, k;

  ATOMO             *InizAtm = NULL;
  register ATOMO    *Atm     = NULL;

  ResName.L = 0;
  ResSeq.L  = 0;

  while(fgets(Lin -> Line, VG_LINELEN, IN)) {

    /**** atom record ****/

    if (!strncmp(Lin -> Line, "atom", 4)) {
      if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
        sscanf(Lin -> Line, "%*s %*s %4s %2s %4s %*s %f %f %f %f",
               AtmName, Atm -> Elem.C, Atm -> Pot.C, &Atm -> Charge,
               &Atm -> x, &Atm -> y, &Atm -> z);
        if (*AtmName == '-') {
          Atm -> Name.L    = 0;
          Atm -> Name.C[0] = Atm -> Elem.C[0];
          Atm -> Name.C[1] = Atm -> Elem.C[1];
        } else {
          for(k = 0; (isdigit(*AtmName)) && (k < 2); ++k) {
            j = strlen(AtmName);
            AtmName[j]     = AtmName[0];
            AtmName[j + 1] = 0;
            for(j = 0; (AtmName[j]) && (j < 4); ++j)
              AtmName[j] = AtmName[j + 1];
          } /* End of for */
          Str2Qchar(&Atm -> Name, AtmName);
        }
        if (ResName.L) {
          Atm -> ResName.L = ResName.L;
          Atm -> ResSeq.L  = ResSeq.L;
        }
      } else break;
    }

    /**** endmol record ****/

    if ((!strncmp(Lin -> Line, "endmol", 6)) && (Atm))
      Atm -> Flags |= VG_ATMF_MOLEND;

    /**** endres record ****/

    if (!strncmp(Lin -> Line, "endres", 6))
      ResName.L = 0;

    /**** res record ****/

    if (!strncmp(Lin -> Line, "res", 3)) {
      ResName.L = 0;
      sscanf(Lin -> Line, "%*s %18s %48s", ResSeqStr, ResName.C);
      Str2Qchar(&ResSeq, ResSeqStr);
    }
  } /* End of while */

  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm      = Atm;
  }

  return InizAtm;
}


