
/*************************************************
****       VEGA - Hybridization template      ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VG_HYBTEM_H
#  define  __VG_HYBTEM_H

#  ifndef __VG_TYPES
#    include "vgtypes.h"
#  endif

#  ifndef __VG_LIST_H
#    include "vglist.h"
#  endif

/**** Hybridization templates ****/

#define  VG_HYB_TEM_NA                  "NA.hyb"
#define  VG_HYB_TEM_PROT                "PROTEIN.hyb"

/**** Flags for VG_ADDHPOT ****/

#define  VG_HYB_FLGPOT_NONE             0       /* No spacial flags               */
#define  VG_HYB_FLGPOT_CONTINUE         1       /* Continue search                */

/**** Jolly character ****/

#ifdef LITTLE_ENDIAN
#  define  VG_ADDH_ASTQ                 0x0000002a
#else
#  define  VG_ADDH_ASTQ                 0x2a000000
#endif

/**** Structures ****/

typedef struct __vg_hyb_pot {
  struct __vg_hyb_pot   *Next;          /* Pointer to the next element     */
  struct __vg_hyb_pot   *Prev;          /* Pointer to the prevoius element */
  VG_QCHAR              ResName;        /* Residue name                    */
  VG_QCHAR              Name;           /* Atom name                       */
  VG_OCHAR              Pot;            /* Atom type                       */
  VG_WORD               Flags;          /* Flags                           */
  VG_WORD               Warn;           /* Warning message                 */
} VG_HYBPOT;

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_WORD         HybTemAtmCheck(ATOMO *, VG_LIST *, VG_OCHAR *);
VG_LIST        *HybTemLoad(char *);

#  ifdef __cplusplus
}
#  endif
#endif