
/*************************************************
****     VEGA - Quanta MSF loader & saver     ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/

/*
 * The saver requires an existing msf file. The numeric format of msf file
 * is little-endian and thus you must change the endian for compatibility.
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#ifdef LITTLE_ENDIAN
#  define  VG_SWAPENDIAN          TRUE
#else
#  define  VG_SWAPENDIAN          FALSE
#endif


/**** Header for Quanta MSF ****/

typedef struct {
  VG_ULONG   ns, nr, na;
  char       version[10];
  char       header[200];
} MSFHDR;


struct ResInfo {
  VG_QCHAR   Resnam;
  VG_QCHAR   idres;
};


/**** Local variables ****/

static char Linea[0x50];


/**** MSF Loader ****/

ATOMO *MsfLoad(FILE *FH, VG_ULONG *TotAtomi)
{
  ATOMO             *PrecAtm;
  char              Name[6];
  struct ResInfo    *InizInfo, *Info;
  MSFHDR            Hdr;
  VG_ULONG          k, Ret;
  VG_UWORD          j, ires;

  ATOMO             *InizAtm = NULL;
  register ATOMO    *Atm     = NULL;
  VG_BOOL           Chk      = TRUE;

  *TotAtomi = 0;
  fseek(FH, 0, SEEK_SET);
  if (ForRead(FH, &Hdr, 222)) {

#ifdef LITTLE_ENDIAN
    Swap(&Hdr.ns);
    Swap(&Hdr.nr);
    Swap(&Hdr.na);
#endif

    if (Hdr.na) {
      do {
        if ((Ret = fread(&k, sizeof(int), 1, FH))) {
#ifdef LITTLE_ENDIAN
          Swap(&k);
#endif
          Ret = fread(Linea, k, 1, FH);
          fseek(FH, sizeof(int), SEEK_CUR);
        }
      } while((Ret) && (strncmp(Linea, "END", 3)));

      if (Ret) {

        /**** Allocate all atoms ****/

        for(k = 0; k < Hdr.na; ++k) {
          if ((Atm = AllocAtm(&InizAtm, TotAtomi)) == NULL) {
            Chk = FALSE;
            break;
          }
        } /* End of for */

        if ((Chk) && (ForSeek(FH, 3, VG_SWAPENDIAN))) {
          LastAtm       = Atm;
          Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
          if ((InizInfo = (struct ResInfo *)Alloca(sizeof(struct ResInfo) * Hdr.nr))) {

            /**** Read the residue number ****/

            Info = InizInfo;
            fseek(FH, sizeof(int), SEEK_CUR);
            for(k = 0;k < Hdr.nr; ++k) {
              fread(Name, 6, 1, FH);
              strncpy(Info -> idres.C, Name + 1, 4);
              ++Info;
            }

            /**** Read the residue name ****/

            Info = InizInfo;
            fseek(FH, sizeof(int) * 2, SEEK_CUR);
            for(k = 0;k < Hdr.nr; ++k) {
              fread(Info -> Resnam.C, sizeof(VG_QCHAR), 1, FH);
              for(j = 3; (j) && (Info -> Resnam.C[j] == ' '); --j)
                Info -> Resnam.C[j] = 0;
              ++Info;
            }
            fseek(FH, sizeof(int), SEEK_CUR);
            ForSeek(FH, 7, VG_SWAPENDIAN);

            /**** Read X coordinates ****/

            fseek(FH, sizeof(int), SEEK_CUR);
            for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
              if (fread(&Atm -> x, sizeof(float), 1, FH) != 1)
                PrintDosErr();
#ifdef LITTLE_ENDIAN
              Swap(&Atm -> x);
#endif
            }

            /**** Read Y coordinates ****/

            fseek(FH, sizeof(int) * 2, SEEK_CUR);
            for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
              fread(&Atm -> y, sizeof(float), 1, FH);
#ifdef LITTLE_ENDIAN
              Swap(&Atm -> y);
#endif
            }

            /**** Read Z coordinates ****/

            fseek(FH, sizeof(int) * 2, SEEK_CUR);
            for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
              fread(&Atm -> z, sizeof(float), 1, FH);
#ifdef LITTLE_ENDIAN
              Swap(&Atm -> z);
#endif
            }

            /**** Read atom names ****/

            fseek(FH, sizeof(int) * 2, SEEK_CUR);
            for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
              fread(&Name, 6, 1, FH);
              ForStrCpy(Atm -> Name.C, Name, 4);
              AtmName2Elem(Atm);
            } /* End of for */

            /**** Read the residue for each atom ****/

            fseek(FH, sizeof(int) * 2, SEEK_CUR);
            for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
               fread(&ires, sizeof(VG_UWORD), 1, FH);
 
#ifdef LITTLE_ENDIAN
              SwapW(&ires);
#endif
              if ((VG_ULONG)ires <= Hdr.nr) {
                Info = InizInfo + (ires - 1);
                Atm -> ResName.L = Info -> Resnam.L;
                memset(Name, 0, sizeof(Name));
                sprintf(Name, "%d", ires);
                memcpy(Atm -> ResSeq.C, Name, 4);
              }
            }
            fseek(FH, sizeof(int), SEEK_CUR);

            /**** Don't read latyp record ****/

            if (ForSeek(FH, 1, VG_SWAPENDIAN)) {

              /**** Read the charges ****/

              fseek(FH, sizeof(int), SEEK_CUR);
              for(Atm = InizAtm; Atm;Atm = Atm -> Ptr) {
                fread(&Atm -> Charge, sizeof(float), 1, FH);
#ifdef LITTLE_ENDIAN
                Swap(&Atm -> Charge);
#endif
              }
            }
            FREE(InizInfo);

            /**** Find water molecules ****/

            PrecAtm = InizAtm;
            for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
              if ((PrecAtm -> ResSeq.L != Atm -> ResSeq.L) &&
                  (((Atm -> ResName.C[0] ==  'H') && (Atm -> ResName.C[1] ==  'O') &&
                   (Atm -> ResName.C[2] ==  'H')) ||
                  ((Atm -> ResName.C[0] ==  'T') && (Atm -> ResName.C[1] ==  'I') &&
                   (Atm -> ResName.C[2] ==  'P') && (Atm -> ResName.C[3] ==  '3')))) {
                PrecAtm -> Flags |= VG_ATMF_SEGEND;
              }
              PrecAtm = Atm;
            }
          }
        }
      }
    }
  }

  return InizAtm;
}


/**** Change an existing msf file ****/

VG_BOOL MsfWrite(FILE *FH, ATOMO *InizAtm, VG_ULONG TotAtm)
{
  float           Tmp;
  MSFHDR          MsfHdr;
  register ATOMO  *Atm;
  VG_BOOL         Ret;

  if ((Ret = ForRead(FH, &MsfHdr, 222))) {
    if (!strncmp(MsfHdr.version, "QUANTA", 6)) {
#ifdef LITTLE_ENDIAN
      Swap(&MsfHdr.na);
#endif
      if (MsfHdr.na == TotAtm) {
        while((Ret = ForRead(FH, Linea, 0x50)) && (strncmp(Linea, "END", 3)));
        if (Ret) {
          if ((Ret = ForSeek(FH, 12, VG_SWAPENDIAN))) {

            /**** Write X coodinates ****/

            fseek(FH, sizeof(int), SEEK_CUR);
            for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
              Tmp = Atm -> x;
#ifdef LITTLE_ENDIAN
              Swap(&Tmp);
#endif
              if (fwrite(&Tmp, sizeof(float), 1, FH) != 1)
                Ret = PrintDosErr();
            } /* End of atom loop */
            if (Ret) {

              /**** Write Y coordinates ****/

              fseek(FH, sizeof(int) * 2, SEEK_CUR);
              for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
                Tmp = Atm -> y;
#ifdef LITTLE_ENDIAN
                Swap(&Tmp);
#endif
                if (fwrite(&Tmp, sizeof(float), 1, FH) != 1)
                  Ret = PrintDosErr();
              } /* End of atom loop */
              if (Ret) {

                /**** Write Z coordinates ****/

                fseek(FH, sizeof(int) * 2, SEEK_CUR);
                for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
                  Tmp = Atm -> z;
#ifdef LITTLE_ENDIAN
                  Swap(&Tmp);
#endif
                  if (fwrite(&Tmp, sizeof(float), 1, FH) != 1)
                    Ret = PrintDosErr();
                } /* End of atom loop */
                if (Ret) {
                  fseek(FH, sizeof(int), SEEK_CUR);
                  if ((Ret = ForSeek(FH, 3, VG_SWAPENDIAN))) {

                  /**** Write the charges ****/

                    fseek(FH, sizeof(int), SEEK_CUR);
                    for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
                      Tmp = Atm -> Charge;
#ifdef LITTLE_ENDIAN
                      Swap(&Tmp);
#endif
                      if (fwrite(&Tmp, sizeof(float), 1, FH) != 1)
                        Ret = PrintDosErr();
                    } /* End of atom loop */
                  }
                }
              }
            }
          }
        }
      } else Ret = CatErr(MSG_ERR_MSF_NOTCOMP);
    } else Ret = CatErr(MSG_ERR_MSF_NOTMSF);
  }

  return Ret;
}

