
/*************************************************
****      VEGA - Molecule superimposition     ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VG_OVERLAY_H
#  define  __VG_OVERLAY_H

#  ifndef  __VG_TYPES
#    include "vgtypes.h"
#  endif

/**** Types ****/

typedef struct
{
  VG_ULONG      rows;
  VG_ULONG      cols;
  float         *element;
} VG_MATRIX;

/**** Constants ****/

#define  VG_OVER_BEGSELSIZE                      10
#define  VG_OVER_TOLERANCE                       0.000000175
#define  VG_OVER_MAXITERS                        100000
#define  VG_OVER_MONCOL                          0x00ffffff

enum {XAXIS, YAXIS, ZAXIS};

/**** Macros ****/

#define  MatrixElementPtr(mat, i, j)            (((mat) -> element) + ((j) * (mat) -> rows) + (i))
#define  MatrixSetElement(mat, i, j, val)       (*(MatrixElementPtr(mat, i, j)) = (val))
#define  MatrixGetElement(mat, i, j)		(*(MatrixElementPtr(mat, i, j)))

/**** Global variables ****/

extern VG_MATRIX        MySpos;

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_BOOL    CalcRmsd(float *, ATOMO **, ATOMO **, VG_BOOL);
VG_BOOL    CalcSuperposMtx(VG_ULONG,  ATOMO **, ATOMO **, VG_MATRIX *, XYZ *, XYZ *, VG_BOOL);
VG_BOOL    MatrixAlloc(VG_MATRIX *, int, int);
void       MatrixForget(VG_MATRIX *);
VG_MATRIX *MatrixMakeUnit(VG_MATRIX *);
VG_MATRIX *MatrixMult(VG_MATRIX *, VG_MATRIX *, VG_MATRIX *);
VG_BOOL    SuperimposeAll(double *, ATOMO *, ATOMO *, VG_BOOL);

#ifdef __VG_OPENGL
float      CalcSuperposRms(VG_ULONG,  ATOMO **, ATOMO **);
VG_BOOL    SuperimposeMol(VG_ULONG , ATOMO **, ATOMO **, VG_ULONG, XYZ **);
#endif

#  ifdef __cplusplus
}
#  endif
#endif
