
/*************************************************
****             VEGA - PSF saver             ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <time.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "count.h"


/**** PSF Saver ****/

VG_BOOL PsfSave(FILE *OUT, ATOMO *InizAtm, VG_ULONG TotA, VG_WORD Type)
{
  ATOMO                 *Atm1, **Ptr;
  char                  *SegName, Buf[FIELDLEN];
  float                 Mass;
  VG_DLONG              *OldFF;
  VG_ULONG              j, k, Count, Tot;
  VG_BOOL               Chk;

  time_t                Data          = time(NULL);
  VG_BOOL               Ret           = TRUE;
  ATOMO                 **AngleMtx    = NULL;
  ATOMO                 **BondMtx     = NULL;
  ATOMO                 **ImproperMtx = NULL;
  ATOMO                 **TorsionMtx  = NULL;

  strcpy(Buf, ctime(&Data));
  Buf[24] = 0;

  /**** Header ****/

  if (fprintf(OUT, "PSF\n"\
                   "\n" \
                   "       2 !NTITLE\n" \
                   "* %s *\n" \
                   "* DATE: %s\n" \
                   "\n" \
                   "%8d !NATOM\n",
                   VEGAHdr, Buf, TotA) > 0) {

    /**** Atom types and masses ****/

    SegName = "MOL";
    for(Atm1 = InizAtm; (Ret) && (Atm1); Atm1 = Atm1 -> Ptr) {
      if (fprintf(OUT, "%8d %-4s %-4.4s %-4.4s %-4.4s %-4.4s ",
                  Atm1 -> Num, SegName, Atm1 -> ResSeq.C, Atm1 -> ResName.C,
                  Atm1 -> Name.C, Atm1 -> Pot.C) > 0) {
        if (Atm1 -> Charge < 0.1) {
          if (fprintf(OUT, "%14.6E   ", Atm1 -> Charge) <= 0)
            Ret = PrintDosErr();
        } else if (fprintf(OUT, "%10.6f       ", Atm1 -> Charge) <= 0) {
          Ret = PrintDosErr();
        }
        if (Ret) {
          Mass = GetAtmMass(Atm1 -> Elem.S);
          if (Mass < 10.0) {
            if (fprintf(OUT, "%7.5f           0\n", Mass) <= 0)
              Ret = PrintDosErr();
          } else if (Mass < 100.0) {
            if (fprintf(OUT, "%7.4f           0\n", Mass) <= 0)
              Ret = PrintDosErr();
          } else if (fprintf(OUT, "%7.3f           0\n", Mass) <= 0) {
            Ret = PrintDosErr();
          }
        }
      } else Ret = PrintDosErr();
    } /* End of for */

    /**** Bonds ****/

    if (Ret) {
      Count = 0;
      Chk   = FALSE;

      if ((Tot = GenBondMtx(InizAtm, &BondMtx)) != 0) {
        if (fprintf(OUT, "\n%8d !NBOND: bonds\n", Tot) > 0) {
          Ptr = BondMtx;
          for(k = 0; (Ret) && (k < Tot); ++k) {
            if (fprintf(OUT, "%8d%8d", Ptr[0] -> Num, Ptr[1] -> Num) > 0) {
              if (++Count == Tot) Chk = TRUE;
              else if ((Count % 4) == 0) Chk = TRUE;
              if (Chk) {
                if (fprintf(OUT, "\n") <= 0)
                  Ret = PrintDosErr();
                Chk = FALSE;
              }
            } else Ret = PrintDosErr();
            Ptr += 2;
          } /* End of for */
        } else Ret = PrintDosErr();
      }

      /**** Angles ****/

      if (Ret) {
        Count = 0;
        Chk   = FALSE;
        if ((Tot = GenAngleMtx(BondMtx, &AngleMtx)) != 0) {
          FREE(BondMtx);
          BondMtx = NULL;
          if (fprintf(OUT, "\n%8d !NTHETA: angles\n", Tot) > 0) {
            Ptr = AngleMtx;
            for(k = 0; (Ret) && (k < Tot); ++k) {
              if (fprintf(OUT, "%8d%8d%8d", Ptr[0] -> Num, Ptr[1] -> Num, Ptr[2] -> Num) > 0) {
                if (++Count == Tot) Chk = TRUE;
                else if ((Count % 3) == 0) Chk = TRUE;
                if (Chk) {
                  if (fprintf(OUT, "\n") <= 0)
                    Ret = PrintDosErr();
                  Chk = FALSE;
                }
              } else Ret = PrintDosErr();
              Ptr += 3;
            } /* End of for */
          } else Ret = PrintDosErr();

          /**** Torsions ****/

          if (Ret) {
            Count = 0;
            Chk   = FALSE;
            Tot   = GenTorsionMtx(AngleMtx, &TorsionMtx);
            if (fprintf(OUT, "\n%8d !NPHI: dihedrals\n", Tot) > 0) {
              if (Tot) {
                Ptr = TorsionMtx;
                for(k = 0; (Ret) && (k < Tot); ++k) {
                  if (fprintf(OUT, "%8d%8d%8d%8d",
                              Ptr[0] -> Num, Ptr[1] -> Num,
                              Ptr[2] -> Num, Ptr[3] -> Num) > 0) {
                    if (++Count == Tot) Chk = TRUE;
                    else if ((Count % 2) == 0) Chk = TRUE;
                    if (Chk) {
                      if (fprintf(OUT, "\n") <= 0)
                        Ret = PrintDosErr();
                      Chk = FALSE;
                    }
                  } else Ret = PrintDosErr();
                  Ptr += 4;
                } /* End of for */
              }
            } else Ret = PrintDosErr();
          }

          /**** Impropers ****/

          if (Ret) {
            Count = 0;
            Chk   = FALSE;
            Tot   = GenImproperMtx(AngleMtx, &ImproperMtx);
            if (fprintf(OUT, "\n%8d !NIMPHI: impropers\n", Tot) > 0) {
              if (Tot) {
                Ptr = ImproperMtx;
                for(k = 0; (Ret) && (k < Tot); ++k) {
                  if (fprintf(OUT, "%8d%8d%8d%8d",
                              Ptr[0] -> Num, Ptr[1] -> Num,
                              Ptr[2] -> Num, Ptr[3] -> Num) > 0) {
                    if (++Count == Tot) Chk = TRUE;
                    else if ((Count % 2) == 0) Chk = TRUE;
                    if (Chk) {
                      if (fprintf(OUT, "\n") <= 0)
                        Ret = PrintDosErr();
                      Chk = FALSE;
                    }
                  } else Ret = PrintDosErr();
                  Ptr += 4;
                } /* End of for */
              }
            } else Ret = PrintDosErr();
          }

          /**** H-bonds ****/

          if (Ret) {
            if ((OldFF = FFPush(BegAtm, TotalAtm)) != NULL) {
              GetPrgPath(Buf, TRUE);
              strcat(Buf, PSF_HBFF);
              if ((Ret = AssignFF(Buf, BegAtm, TotalAtm, FALSE, TRUE))) {

                /**** H-bond donors ****/

                Count = 0;
                Chk   = FALSE;
                Tot = CountHbDonor(BegAtm);
                if (fprintf(OUT, "\n%8d !NDON: donors\n", Tot) > 0) {
                  for(Atm1 = BegAtm; Atm1; Atm1 = Atm1 -> Ptr) {
                    if (*Atm1 -> Pot.C == 'h') {
                      if (fprintf(OUT, "%8d%8d",
                              Atm1 -> Conn[0] -> Num, Atm1 -> Num) > 0) {
                        if (++Count == Tot) Chk = TRUE;
                        else if ((Count % 4) == 0) Chk = TRUE;
                        if (Chk) {
                          if (fprintf(OUT, "\n") <= 0)
                            Ret = PrintDosErr();
                          Chk = FALSE;
                        }
                      } else Ret = PrintDosErr();
                    }
                  } /* End of for */
                } else Ret = PrintDosErr();

                /**** H-bond acceptors ****/

                if (Ret) {
                  Count = 0;
                  Chk   = FALSE;
                  Tot = CountHbAcceptor(BegAtm);
                  if (fprintf(OUT, "\n%8d !NACC: acceptors\n", Tot) > 0) {
                    for(Atm1 = BegAtm; Atm1; Atm1 = Atm1 -> Ptr) {
                      if ((*Atm1 -> Pot.C != 'h') && (*Atm1 -> Pot.C != 'x')) {
                        if (Atm1 -> NSost == 1) k = Atm1 -> Conn[0] -> Num;
                        else k = 0;
                        if (fprintf(OUT, "%8d%8d",
                                Atm1 -> Num, k) > 0) {
                          if (++Count == Tot) Chk = TRUE;
                          else if ((Count % 4) == 0) Chk = TRUE;
                          if (Chk) {
                            if (fprintf(OUT, "\n") <= 0)
                              Ret = PrintDosErr();
                            Chk = FALSE;
                          }
                        } else Ret = PrintDosErr();
                      }
                    } /* End of for */
                  } else Ret = PrintDosErr();

                  /**** NNB ****/

                  if (Ret) {
                    Chk   = FALSE;
                    if (fprintf(OUT, "\n       0 !NNB\n", Tot) > 0) {
                      for(Count = 1; Count <= TotalAtm; ++Count) {
                        if (fprintf(OUT, "       0") > 0) {
                          if (Count == TotalAtm) Chk = TRUE;
                          else if ((Count % 8) == 0) Chk = TRUE;
                          if (Chk) {
                            if (fprintf(OUT, "\n") <= 0)
                              Ret = PrintDosErr();
                            Chk = FALSE;
                          }
                        }
                      } /* End of for */
                    } else Ret = PrintDosErr();

                    /**** NGRP ****/

                    if (Ret) {
                      Count = 0;
                      Chk   = FALSE;
                      Tot   = CountRes(BegAtm);
                      if (fprintf(OUT, "\n%8d       0 !NGRP NST2\n", Tot) > 0) {
                        j = 0;
                        k = 0;
                        for(Atm1 = BegAtm; Atm1; Atm1 = Atm1 -> Ptr) {
                          if ((Atm1 -> ResName.L != (VG_LONG)j) ||
                              (Atm1 -> ResSeq.L  != (VG_LONG)k)) {
                            j = Atm1 -> ResName.L;
                            k = Atm1 -> ResSeq.L;
                            if (fprintf(OUT, "%8d       2       0", Atm1 -> Num - 1) > 0) {
                              if (++Count == Tot) Chk = TRUE;
                              else if ((Count % 3) == 0) Chk = TRUE;
                              if (Chk) {
                                if (fprintf(OUT, "\n") <= 0)
                                  Ret = PrintDosErr();
                                Chk = FALSE;
                              }
                            } else Ret = PrintDosErr();
                          }
                        } /* End of for */
                      } else Ret = PrintDosErr();
                    }
                  }
                }
              }

              FFPop(BegAtm, OldFF);
              FREE(OldFF);
            } else Ret = FALSE;
          }
        }
      }
    }
  } else Ret = PrintDosErr();

  if (AngleMtx)    FREE(AngleMtx);
  if (BondMtx)     FREE(BondMtx);
  if (ImproperMtx) FREE(ImproperMtx);
  if (TorsionMtx)  FREE(TorsionMtx);

  return Ret;
}