
/*************************************************
****      VEGA - Molecule selector header     ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __SELMOL
#  define  __SELMOL

#  ifndef __VG_TYPES
#    include "vgtypes.h"
#  endif

#  ifndef __VGLIST_H
#    include "vglist.h"
#  endif

/**** Definitions ****/

typedef struct __VG_MOLLIST {
  struct __VG_MOLLIST   *Ptr;           /* Pointer to the next list element     */
  VG_ULONG              Num;            /* Number of the molecule               */
  ATOMO                 *Begin;         /* Starting atom                        */
  ATOMO                 *End;           /* Ending atom                          */
} VG_MOLLIST;

typedef struct __VG_RESLIST {
  struct __VG_RESLIST   *Next;          /* Pointer to the next list element     */
  struct __VG_RESLIST   *Prev;          /* Pointer to the previous list element */
  VG_ULONG              NMol;           /* Number of the molecule               */
  ATOMO                 *Begin;         /* Starting atom                        */
  ATOMO                 *End;           /* Ending atom                          */
} VG_RESLIST;

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_ULONG        MolListFindMol(ATOMO *);

#  ifdef __VG_OPENGL

VG_ULONG        MolElemCrc(ATOMO *, VG_BOOL);
VG_MOLLIST     *MolListAtm2List(VG_MOLLIST *, VG_ULONG);
VG_MOLLIST     *MolListBuild(ATOMO *, VG_BYTE);
VG_ULONG        MolListCountMol(void);
VG_ULONG        MolListGet(VG_ULONG, ATOMO **, ATOMO **);
void            MolListFree(VG_MOLLIST **);
void            MolListRemAtm(ATOMO *, VG_ULONG, VG_ULONG);
void            MolRotate(ATOMO *, float, float, float, XYZ *, float [4][4]);
void            MolTranslate(ATOMO *, float, float, float, XYZ *, float [4][4]);
VG_LIST        *ResListBuild(ATOMO *);

#  endif
#  ifdef __cplusplus
}
#  endif
#endif

