
/*************************************************
****       VEGA - Sybyl Rgn Loader only       ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#define SCANXYZ(X)           sscanf(Lin -> Line, "%*s %*s %f %f %f", \
                                    &(X).x, &(X).y, &(X).z);


/**** Read a Sybyl reg file ****/

VG_BOOL SybRgnLoad(FILE *FH, RECORD *Lin, SPACEREG *Reg)
{
  char          LfChk[4];
  TRJPAR        *Tmp;

  VG_BOOL       Ret   = TRUE;
  VG_UWORD      Count = 0;

  /**** Reset the values ****/

  Tmp = Reg -> Par;
  memset(Reg, 0, sizeof(SPACEREG));
  Reg -> Par = Tmp;

  while ((Ret) && (fgets(Lin -> Line, VG_LINELEN, FH))) {
    sscanf(Lin -> Line, "%2s", LfChk);
    if (*LfChk != '\n') {
      if (strncmp(Lin -> Line, "Points:", 7)) {
        if (Reg -> Points) {
          switch(Count) {
          case 0:
            if (!strncmp(Lin -> Line, "  Box 1", 7)) ++Count;
            break;
          case 1:
            SCANXYZ(Reg -> Low);
            ++Count;
            break;
          case 2:
            SCANXYZ(Reg -> Hi);
            ++Count;
            break;
          case 3:
            SCANXYZ(Reg -> StepS);
            if ((Reg -> StepS.x <= 0) ||
                (Reg -> StepS.y <= 0) ||
                (Reg -> StepS.z <= 0)) Ret = CatErr(MSG_ERR_SYBRGN_STPSIZE);
            else ++Count;
            break;
          case 4:
            sscanf(Lin -> Line, "%*s %*s %d %d %d",
                   &Reg -> StX, &Reg -> StY, &Reg -> StZ);
            if (((VG_LONG)Reg -> StX <= 0) ||
                ((VG_LONG)Reg -> StY <= 0) ||
                ((VG_LONG)Reg -> StZ <= 0)) Ret = CatErr(MSG_ERR_SYBRGN_NUMSTPS);
            else ++Count;
            break;
          } /* End of switch */
        }
      } else {
        sscanf(Lin -> Line, "%*s %d", &Reg -> Points);
        if ((VG_LONG)Reg -> Points <= 0)
          Ret = CatErr(MSG_ERR_SYBRGN_POINTS);
      }
    }
  } /* End of while */

  if (!Count) Ret = CatErr(MSG_ERR_SYBRGN_CORRUPTED);

  return Ret;
}

