
/*************************************************
****         VEGA - Sysyem Utilities          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <malloc.h>

#ifndef __WIN32__
#  include <unistd.h>
#  include <errno.h>
#endif

#ifdef __BORLANDC__
#  pragma hdrstop
#  ifdef __cplusplus
extern "C" {
#    endif

void WinPrgPath(char *);

#  ifdef __cplusplus
}
#  endif
#endif

#ifdef AMIGA
#  include <dos/dos.h>
#  include <exec/types.h>
#  include <exec/memory.h>
#  include <exec/execbase.h>
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "comerr.h"


/**** Global variables ****/

extern int   errno;


/**** Allocate the memory with error check ****/

void *Alloca(VG_ULONG Mem)
{
  void		*Ind;

  if ((Ind = (void *)ALLOC(Mem)) == NULL)
    CatErr(MSG_ERR_UTILS_OUTOFMEM);

  return Ind;
}


/**** The file exists ****/

VG_BOOL FileExists(char *File)
{
  FILE          *FH;
  VG_BOOL       Ret = FALSE;

  if ((FH = fopen(File, "r")) != NULL) {
    fclose(FH);
    Ret = TRUE;
  }

  return Ret;
}


/**** Calculate the file length ****/

VG_ULONG FileLength(FILE *FH)
{
  VG_ULONG         Cur, Len;

  Cur = ftell(FH);            /* Current position            */
  fseek(FH, 0, SEEK_END);
  Len = ftell(FH);            /* Length of file              */
  fseek(FH, Cur, SEEK_SET);   /* Return to starting position */

  return Len;
}


/**** Return the file name ****/

char *GetFileName(char *Str)
{
  register char *Ptr = Str + strlen(Str);

  while ((Ptr != Str) &&
#ifdef AMIGA
         (*Ptr != ':') &&
#endif
         (*Ptr != '\\') && (*Ptr != '/')) --Ptr;

  if (Ptr != Str) ++Ptr;

  return Ptr;
}


/**** Get the file path ****/

void GetFilePath(char *Str)
{
  register char *Ptr = Str + strlen(Str);

  while ((Ptr != Str) &&
#ifdef AMIGA
         (*Ptr != ':') &&
#endif

#ifdef WIN32
         (*Ptr != '\\')
#else
         (*Ptr != '/')
#endif
        ) --Ptr;

  if (Ptr != Str) ++Ptr;
  *Ptr = 0;
}


/**** Copy in a string the path of Vega   ****
 **** The VEGADIR environment variable    ****
 **** it's only needed for Unix systems,  ****
 **** but if setted can be used also from ****
 **** other operating systems             ****/

VG_BOOL GetPrgPath(char *Str, VG_BOOL DataDir)
{
  char          *CharPtr;

  if (!getenv("VEGADIR")) {
#ifdef AMIGA
    strcpy(Str, "PROGDIR:");
#else
#  ifdef __BORLANDC__
   WinPrgPath(Str);
#  else
    return CatErr(MSG_ERR_UTILS_VEGADIR);
#  endif
#endif
  } else strcpy(Str, (char *)getenv("VEGADIR"));

  CharPtr = Str + strlen(Str) - 1;

#ifndef WIN32
  if ((*CharPtr != ':') && (*CharPtr != '/')) strcat(Str, "/");
#else
  if (*CharPtr != '\\') strcat(Str, "\\");
#endif

  /**** If requested, adds the Data subdirectory ****/

  if (DataDir) strcat(Str, "Data" C_DIRSEP);

  return TRUE;
}


/**** Show a system error ****/

VG_BOOL PrintDosErr(void)
{
  return CatErr(MSG_ERR_UTILS_DOSERR, strerror(errno));
}


/**** Print warning message ****/

void PrintWarn(char *Msg)
{
  if ((!GLOBSW_STDOUT) && (ErrMode != VG_ERRMOD_QUIET))
#ifdef WIN32
    LocPrintf(stdout, "%s %s\n\n", GetStr(MSG_WARN_UTILS_WARN), Msg);
#else
    printf("\033[33m%s\033[0m %s\n\n", GetStr(MSG_WARN_UTILS_WARN), Msg);
#endif
}


/**** Change the endian ****/

void Swap(register void *Val)
{
  register VG_UBYTE    T;

  T = ((VG_UBYTE *)Val)[0];
  ((VG_UBYTE *)Val)[0] = ((VG_UBYTE *)Val)[3];
  ((VG_UBYTE *)Val)[3] = T;
  T = ((VG_UBYTE *)Val)[1];
  ((VG_UBYTE *)Val)[1] = ((VG_UBYTE *)Val)[2];
  ((VG_UBYTE *)Val)[2] = T;
}


/**** Change the endian 64 bit ****/

void Swap64(register void *Val)
{
  register VG_UBYTE    T;

  T = ((VG_UBYTE *)Val)[0];
  ((VG_UBYTE *)Val)[0] = ((VG_UBYTE *)Val)[7];
  ((VG_UBYTE *)Val)[7] = T;
  T = ((VG_UBYTE *)Val)[1];
  ((VG_UBYTE *)Val)[1] = ((VG_UBYTE *)Val)[6];
  ((VG_UBYTE *)Val)[6] = T;
  T = ((VG_UBYTE *)Val)[2];
  ((VG_UBYTE *)Val)[2] = ((VG_UBYTE *)Val)[5];
  ((VG_UBYTE *)Val)[5] = T;
  T = ((VG_UBYTE *)Val)[3];
  ((VG_UBYTE *)Val)[3] = ((VG_UBYTE *)Val)[4];
  ((VG_UBYTE *)Val)[4] = T;
}


/**** Change the endian for float ****/

double SwapD(double Num)
{
  register VG_UBYTE    T;
  register VG_UBYTE    *Val = (VG_UBYTE *)&Num;

  T = ((VG_UBYTE *)Val)[0];
  ((VG_UBYTE *)Val)[0] =  ((VG_UBYTE *)Val)[7];
  ((VG_UBYTE *)Val)[7] = T;
  T = ((VG_UBYTE *)Val)[1];
  ((VG_UBYTE *)Val)[1] =  ((VG_UBYTE *)Val)[6];
  ((VG_UBYTE *)Val)[6] = T;
  T = ((VG_UBYTE *)Val)[2];
  ((VG_UBYTE *)Val)[2] =  ((VG_UBYTE *)Val)[5];
  ((VG_UBYTE *)Val)[5] = T;
  T = ((VG_UBYTE *)Val)[3];
  ((VG_UBYTE *)Val)[3] =  ((VG_UBYTE *)Val)[4];
  ((VG_UBYTE *)Val)[4] = T;

  return Num;
}


/**** Change the endian for int ****/

int SwapI(int Val)
{
  Swap(&Val);
  return Val;
}


/**** Change the endian for word ****/

void SwapW(register void *Val)
{
  register VG_UBYTE    T;

  T = ((VG_UBYTE *)Val)[0];
  ((VG_UBYTE *)Val)[0] =  ((VG_UBYTE *)Val)[1];
  ((VG_UBYTE *)Val)[1] = T;
}



