
/*************************************************
****               VEGA - Types               ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef  __VG_TYPES
#define  __VG_TYPES

#ifndef __STDIO_H
#  include <stdio.h>
#endif

#define  MAXBOND                6       /* Max bonded atoms */

/****************************
****     Bond orders     ****
**** See ATOMO structure ****
****************************/

#define  VG_BOND_NONE           0       /* Atom not bonded */
#define  VG_BOND_SINGLE         1       /* Single bond     */
#define  VG_BOND_DOUBLE         2       /* Double bond     */
#define  VG_BOND_TRIPLE         3       /* Triple bond     */
#define  VG_BOND_PARDOUBLE      4       /* Partial double  */

/****************************
****      Label types    ****
**** See ATOMO structure ****
****************************/

#define  VG_ATMLBL_NONE         0       /* Don't change the order */
#define  VG_ATMLBL_NAME         1
#define  VG_ATMLBL_ELEMENT      2
#define  VG_ATMLBL_NUMBER       3
#define  VG_ATMLBL_TYPE         4
#define  VG_ATMLBL_CHARGE       5
#define  VG_ATMLBL_FIX          6

/**** Residue labels ****/

#define  VG_ATMLBL_RESNAMESEQ   7
#define  VG_ATMLBL_RESNAME      8
#define  VG_ATMLBL_RESSEQ       9


/****************************
****  Color definitions  ****
**** See ATOMO structure ****
****************************/

#define  VGCOL_NONE             0
#define  VGCOL_BLACK            1
#define  VGCOL_WHITE            2
#define  VGCOL_RED              3
#define  VGCOL_GREEN            4
#define  VGCOL_CYAN             5
#define  VGCOL_YELLOW           6
#define  VGCOL_FIREBIRCK        7
#define  VGCOL_MAGENTA          8
#define  VGCOL_PINK             9
#define  VGCOL_VIOLET          10
#define  VGCOL_GRAY            11
#define  VGCOL_ORANGE          12
#define  VGCOL_DARKGREEN       13
#define  VGCOL_BLUE            14
#define  VGCOL_DARKYELLOW      15
#define  VGCOL_BROWN           16
#define  VGCOL_SKYBLUE         17
#define  VGCOL_DARKGRAY        18
#define  VGCOL_GHOSTPINK       19
#define  VGCOL_GHOSTGREEN      20
#define  VGCOL_GHOSTBLUE       21
#define  VGCOL_GHOSTYELLOW     22
#define  VGCOL_GHOSTGRAY       23
#define  VGCOL_SAND            24

#define  VGCOL_NUM             24


/********************************
**** Bit values of the Flags ****
****     ATOMO structure     ****
********************************/

#define  VG_ATMF_NONE          0
#define  VG_ATMF_HETATM        1
#define  VG_ATMF_SEGEND        2
#define  VG_ATMF_MOLEND        4
#define  VG_ATMF_CENTROID      8
#define  VG_ATMF_CENTROIDFIX  16
#define  VG_ATMF_ORGANIC      32


/********************************
**** Bit values of the Flags ****
****   VG_SURFACE structure  ****
********************************/

#define  VG_SRFF_NONE          0
#define  VG_SRFF_END           1


/**************************
**** Boolean constants ****
**************************/

#ifndef FALSE
#  define  FALSE               0
#endif
#ifndef TRUE
#  define  TRUE                1
#endif


/****************************
**** VEGA specific types ****
****************************/

typedef unsigned short      VG_BOOL;
typedef char                VG_BYTE;
typedef unsigned char       VG_UBYTE;
typedef short               VG_WORD;
typedef unsigned short      VG_UWORD;
typedef int                 VG_LONG;
typedef unsigned int        VG_ULONG;

#ifdef __BORLANDC__
typedef __int64             VG_DLONG;
typedef unsigned __int64    VG_UDLONG;
#else
typedef long long           VG_DLONG;
typedef unsigned long long  VG_UDLONG;
#endif

typedef union {
  char      C[2];
  VG_WORD   S;
} VG_DCHAR;

typedef union {
  char      C[4];
  VG_LONG   L;
} VG_QCHAR;

typedef union {
  char      C[8];
  VG_DLONG  DL;
} VG_OCHAR;


/**** ATOMO structure ****/

typedef struct __Atomo {
  struct __Atomo   *Ptr;            /* Address of next structure   */
  struct __Atomo   *Prev;           /* Address of prev. structure  */
  VG_ULONG          Num;            /* Atom number                 */
  VG_QCHAR          Name;           /* Atom name                   */
  VG_DCHAR          Elem;           /* Element                     */
  VG_WORD           Ring;           /* Ring indicator              */
  VG_QCHAR          ResName;        /* Residue name                */
  VG_QCHAR          ResSeq;         /* Number of residue           */
  float             x, y, z;        /* X, Y, Z coodinates          */
  float             Charge;         /* Atomic charge               */
  float             Rad;            /* Atomic radius               */
  float             Fix;            /* Fixing parameter            */
  VG_OCHAR          Pot;            /* Atom type (potential)       */
  struct __Atomo   *Conn[MAXBOND];  /* Connectivity matrix         */
  VG_UBYTE          Order[MAXBOND]; /* Bond order (not used yet)   */
  VG_BYTE           NSost;          /* Number of bonded atoms      */
  VG_BYTE           Flags;          /* See above                   */
  VG_BYTE           ChainID;        /* Chain indicator             */
  VG_UBYTE          ColorID;        /* Color ID (OpenGL)           */
  VG_UBYTE          Alpha;          /* Transparency (OpenGL Alpha) */
  VG_UBYTE          Label;          /* Label (OpenGL)              */
  VG_UBYTE          Active;         /* Active atom (OpenGL)        */
  VG_UBYTE          Reseved;        /* Reserved                    */
} ATOMO;


/**** Surface data structure ****/

typedef struct __vg_surface {
  struct __vg_surface  *Next;       /* Pointer to next element                */
  struct __vg_surface  *Prev;       /* Pointer to prevoius element            */
  VG_ULONG              AtmNum;     /* Atom number                            */
  float                 x, y, z;    /* Coordinates (don't change the order of */
  float                 Val;        /* these two fields)                      */
  VG_UBYTE              Color[3];   /* Color vector                           */
  VG_BYTE               Flags;      /* Flags                                  */
} VG_SURFACE;
#endif
