
/*************************************************
****         VEGA - Alchemy loader            ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "bond.h"


/**** Chem3D loader ****/

ATOMO *Chem3dLoad(FILE *IN, RECORD *Lin, VG_ULONG *TotAtomi)
{
  ATOMO                 *Atm, **ConMtx;
  char			Str[12], *Ptr;
  VG_LONG               i, j, k;

  ATOMO                 *InizAtm = NULL;
  VG_LONG               NumAtoms = 0;

  fseek(IN, 0, SEEK_SET);
  if (fgets(Lin -> Line, VG_LINELEN, IN)) {
    sscanf(Lin -> Line, "%d", &NumAtoms);
    if (NumAtoms <= 0) return NULL;

    i = NumAtoms;
    while((i) && (fgets(Lin -> Line, VG_LINELEN, IN))) {
      if (StrExist(Lin -> Line)) {
        if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
          sscanf(Lin -> Line, "%s %*s %f %f %f %8s",
                 Str, &Atm -> x, &Atm -> y, &Atm -> z, &Atm -> Pot.C);
          Str2Qchar(&Atm -> Name, Str);
          AtmName2Elem(Atm);
          --i;
        } else {
          FreeAtm(InizAtm);
          return NULL;
        }
      }
    } /* End of while */
  } else PrintDosErr();

  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;

    /**** Bonds ****/

    if ((ConMtx = AllocAtmTable(InizAtm, NumAtoms, TRUE)) != NULL) {
      fseek(IN, 0, SEEK_SET);
      i = 0;
      if (fgets(Lin -> Line, VG_LINELEN, IN)) {
        while((i < NumAtoms) && (fgets(Lin -> Line, VG_LINELEN, IN))) {
          if ((StrExist(Lin -> Line)) &&
              ((Ptr = strtok(Lin -> Line, FieldSep)) != NULL)) {
            k = 0;
            while(Ptr = strtok(NULL, FieldSep)) {
              if ((k > 4) && ((j = atoi(Ptr)) > 0) && (j <= NumAtoms)) {
                BndMake(ConMtx[i], ConMtx[j - 1], VG_BOND_SINGLE);
              }
              ++k;
            } /* End of while */
            ++i;
          }
        } /* End of while */
        GLOBSW_CONNCALC = FALSE;
      } else PrintDosErr();
      FREE(ConMtx);
    }

  }

  return InizAtm;
}