
/*************************************************
****        VEGA - Quanta csr analyzer        ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "formats.h"
#include "traj.h"

/**** Local prototypes ****/

static VG_BOOL CsrSkipTor(TRJINFO *);


/**** Close the trajectory ****/

void CsrClose(TRJINFO *Info)
{
  if (Info -> FH)        fclose(Info -> FH);
  if (Info -> VectorBuf) FREE(Info -> VectorBuf);
}


/**** Open the trajectory file ****/

VG_BOOL CsrOpen(char *FileName, TRJINFO *Info)
{
  char          Riga[32];
  float         *Ptr;
  VG_BOOL       Ret;
  VG_ULONG      k;


  if ((Info -> FH = fopen(FileName, "rb"))) {
    /**** Check the endian ****/

    if (fread(Riga, sizeof(int) * 2, 1, Info -> FH) == 1) {
      if (Riga[3] == 1) Info -> SwapEndian = TRUE;   /* Little Endian    */
      else Info -> SwapEndian = FALSE;               /* Big Endian */

#ifdef LITTLE_ENDIAN
      Info -> SwapEndian = !Info -> SwapEndian;
#endif
      Info -> SubFormat = Riga[7];
      fseek(Info -> FH, 8, SEEK_CUR);
      if (fread(&Info -> MolAtm, sizeof(int), 1, Info -> FH) == 1) {
        if (Info -> SwapEndian) Swap(&Info -> MolAtm);
        fseek(Info -> FH, 8, SEEK_CUR);
        if ((Ret = ForSeek(Info -> FH, 2, Info -> SwapEndian))) {

          /**** Number of torsions ****/

          if ((Info -> SubFormat == 'g') &&
              (CsrSkipTor(Info) == FALSE)) {
            CsrClose(Info);
            return FALSE;
          }

          Info -> StartData = ftell(Info -> FH);
          fseek(Info -> FH, 0, SEEK_END);
          Info -> Frames = (ftell(Info -> FH) - Info -> StartData) /
                           (Info -> MolAtm * 12 + 24 + 0x58 + 8);
          Info -> EneFrames = Info -> Frames;
          Info -> EneStep   = 1;

          /**** Read the energy ****/

          if (Info -> Frames) {
            if (Info -> VectorBuf = (XYZ *)Alloca(Info -> MolAtm * sizeof(float))) {
              if (Info -> Energy = (float *)Alloca(Info -> EneFrames * sizeof(float))) {
                Ptr = Info -> Energy;
                fseek(Info -> FH, Info -> StartData, SEEK_SET);
                for(k = 0; (Ret) && (k < Info -> EneFrames); ++k) {
                  fseek(Info -> FH, 8, SEEK_CUR);
                  if (fread(Ptr, sizeof(float), 1, Info -> FH) == 1) {
                    if (Info -> SwapEndian) Swap(Ptr);
                    fseek(Info -> FH, 84, SEEK_CUR);
                    Ret = ForSeek(Info -> FH, 3, Info -> SwapEndian);
                  } else Ret = PrintDosErr();
                  ++Ptr;
                } /* End of for */
              } else Ret = FALSE;
            } else Ret = FALSE;
          }
        }
      } else Ret = PrintDosErr();
    } else Ret = PrintDosErr();
  } else Ret = PrintDosErr();

  if (!Ret) CsrClose(Info);

  return Ret;
}


/**** Read one frame ****/

VG_BOOL CsrReadFrm(TRJINFO *Info, ATOMO *InizAtm)
{
  register ATOMO         *Atm;
  float                  *Ptr, Val;
  VG_BOOL                Ret;
  VG_ULONG               k;

  if ((Ret = ForSeek(Info -> FH, 1, Info -> SwapEndian))) {
    for(k = 0; k < 3; ++k) {
      fseek(Info -> FH, sizeof(VG_ULONG), SEEK_CUR);
      if (fread(Info -> VectorBuf, sizeof(float) * Info -> MolAtm, 1, Info -> FH) == 1) {
        Ptr = (float *)Info -> VectorBuf;
        for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
          if (!(Atm -> Flags & VG_ATMF_CENTROID)) {
            if (Info -> SwapEndian) Swap(Ptr);
            (&Atm -> x)[k] = *Ptr++;
          }
        } /* End of for */
      } else Ret = PrintDosErr();
      fseek(Info -> FH, sizeof(VG_ULONG), SEEK_CUR);
    } /* End of for */
  }

  return Ret;
}


/**** Seek a trajectory frame ****/

VG_BOOL CsrSeekFrm(TRJINFO *Info, VG_LONG Frames, VG_LONG Mode)
{
  VG_LONG      Len;

  if (Mode == SEEK_SET) Len = Info -> StartData;
  else Len = 0;

  Len += (Info -> MolAtm * 12 + 24 + 0x58 + 8) * Frames;
  fseek(Info -> FH, Len, Mode);

  return TRUE;
}


/**** Skip torsion section ****/

static VG_BOOL CsrSkipTor(TRJINFO *Info)
{
  VG_BOOL       Ret;
  VG_ULONG      k;

  if ((Ret = ForRead(Info -> FH, &k, sizeof(VG_ULONG)))) {
    if (Info -> SwapEndian) Swap(&k);
    Ret = ForSeek(Info -> FH, 2 + k, Info -> SwapEndian);
  }

  return Ret;
}

