
/*************************************************
****           VEGA - Database engine         ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VG_DB_ENGINE_H
#define  __VG_DB_ENGINE_H

#ifndef __VGLIST_H
#include "vglist.h"
#endif

/**** Constants ****/

#define  VG_DB_DATFILE_NAME           "database.dat"
#define  VG_DB_DATFILE_VER            "1.0"
#define  VG_DB_MOLNAMESIZE            256

/**** Database flags ****/

#define VG_DB_FLAG_NONE               0
#define VG_DB_FLAG_CR                 1

/**** Get modes ****/

#define  VG_DB_GET_APPEND             0         /* Don't change the order      */
#define  VG_DB_GET_REPLACE            1
#define  VG_DB_GET_WORKSPACE          2

/**** Database types ****/

#define  VG_DB_TYPE_UNK               0         /* Check the DbInfo() function */
#define  VG_DB_TYPE_FILE              1         /* and comrun.c if you change  */
#define  VG_DB_TYPE_SDF               2         /* the order                   */
#define  VG_DB_TYPE_ZIP               3

/**** Database locks ****/

#define  VG_DB_LOCK_NONE              0         /* Database unlocked           */
#define  VG_DB_LOCK_FRAGS             1         /* Locked by add frags         */

/**** DbInfo() IDs ****/

enum {
  VG_DB_INFO_CURMOLNAME,
  VG_DB_INFO_FILENAME,
  VG_DB_INFO_FORMAT,
  VG_DB_INFO_MOLECULES,
  VG_DB_INFO_MOLFLAGS,
  VG_DB_INFO_MOLFORMAT
};

/**** Molecule flags ****/

#define  VG_DB_MOLFLAG_NONE           0                 /* Nothing                */
#define  VG_DB_MOLFLAG_CONN           1                 /* Write the connectivity */
#define  VG_DB_MOLFLAG_FIX            2                 /* Write the constraints  */
#define  VG_DB_MOLFLAG_VERBOSE        0xffffffff        /* Verbose flag           */

/**** Types ****/

typedef struct __Vg_DbMolList {
  struct __Vg_DbMolList *Next;
  struct __Vg_DbMolList *Prev;
  VG_ULONG              Offset;
  char                  MolName[VG_DB_MOLNAMESIZE];
} VG_DBMOLLIST;

typedef struct __VgDbInfo {
  struct __VgDbInfo     *Next;
  struct __VgDbInfo     *Prev;
  char                  FileName[VG_MAX_PATH];          /* Database file name        */
  char                  CurMolName[VG_DB_MOLNAMESIZE];  /* Last managed molecule     */
  void                  *Handle;                        /* Database handle           */
  void                  *GlobalInfo;                    /* Global info (zip)         */
  VG_ULONG              Id;                             /* Identification number     */
  VG_UWORD              Type;                           /* Database format           */
  VG_LONG               Flags;                          /* Database flags            */
  FILEFORMAT            *MolFormat;                     /* Default molecule format   */
  VG_LONG               MolFlags;                       /* Default molecule flags    */
  VG_LIST               *MolList;                       /* List of the molecules     */
  VG_ULONG              TotMol;                         /* Molecules in the database */
  VG_WORD               Lock;                           /* Lock mode                 */
  VG_UWORD              MolPack;                        /* Compression mode          */
} VG_DBINFO;

/**** Global variables ****/

extern const char       *DbDataStr;
extern VG_LIST          *DbList;

/**** Prototypes  ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_BOOL         DbClose(VG_DBINFO *, VG_BOOL, VG_BOOL);
void            DbCloseAll(VG_LIST **, VG_BOOL);
VG_DBINFO      *DbCreate(char *, VG_LONG, FILEFORMAT *, VG_UWORD, VG_LONG);
VG_BOOL         DbDatCreate(char *, VG_DBINFO *);
VG_BOOL         DbDatRead(char *, VG_DBINFO *);

void            DbFileClose(VG_DBINFO *);
VG_BOOL         DbFileCreate(VG_DBINFO *);
ATOMO          *DbFileGet(VG_DBINFO *, char *, VG_LONG *);
VG_BOOL         DbFileMolListRead(VG_DBINFO *);
VG_BOOL         DbFileOpen(VG_DBINFO *);
VG_BOOL         DbFilePut(VG_DBINFO *, char *);
VG_BOOL         DbFileRemove(VG_DBINFO *, VG_DBMOLLIST *);
VG_BOOL         DbFileRen(VG_DBINFO *, VG_DBMOLLIST *, char *);

VG_BOOL         DbGet(VG_DBINFO *, char *, VG_ULONG, VG_LONG, VG_BOOL);
void            DbInfo(VG_DBINFO *, VG_ULONG);
VG_DBINFO      *DbInfoFromId(VG_ULONG);
VG_DBMOLLIST   *DbMolListAdd(VG_DBINFO *, char *);
VG_BOOL         DbMolListChk(VG_DBINFO *, char *);
void            DbMolListClear(VG_DBINFO *);
VG_DBMOLLIST   *DbMolListGet(VG_DBINFO *, char *, VG_ULONG);
VG_BOOL         DbMolListRead(VG_DBINFO *);
void            DbMolListRemove(VG_DBINFO *, VG_DBMOLLIST *);
VG_DBINFO      *DbOpen(char *, VG_BOOL);
VG_BOOL         DbPut(VG_DBINFO *, char *, VG_BOOL);
VG_BOOL         DbRemove(VG_DBINFO *, VG_DBMOLLIST *);
VG_BOOL         DbRen(VG_DBINFO *, VG_DBMOLLIST *, char *);

void            DbZipClose(VG_DBINFO *);
VG_BOOL         DbZipCreate(VG_DBINFO *);
ATOMO          *DbZipGet(VG_DBINFO *, char *, VG_LONG *);
VG_BOOL         DbZipMolListRead(VG_DBINFO *);
VG_BOOL         DbZipOpen(VG_DBINFO *);
VG_BOOL         DbZipPut(VG_DBINFO *, char *);
VG_BOOL         DbZipRemove(VG_DBINFO *, VG_DBMOLLIST *);

void            DbSdfClose(VG_DBINFO *);
VG_BOOL         DbSdfCreate(VG_DBINFO *);
ATOMO          *DbSdfGet(VG_DBINFO *, char *);
VG_BOOL         DbSdfMolListRead(VG_DBINFO *);
VG_BOOL         DbSdfOpen(VG_DBINFO *);
VG_BOOL         DbSdfPut(VG_DBINFO *, char *, VG_ULONG *);
VG_BOOL         DbSdfRemove(VG_DBINFO *, VG_DBMOLLIST *);
VG_BOOL         DbSdfRen(VG_DBINFO *, VG_DBMOLLIST *, char *);

#  ifdef __cplusplus
}
#  endif
#endif

