
/*************************************************
****       VEGA - Interactive measures        ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef  __GL_MEASURE
#  define  __GL_MEASURE

#ifndef __VG_TYPES
#  include "vgtypes.h"
#endif

/**** Constants ****/

#define  VG_SELBUFSIZE          512
#define  VG_SELSIZE             15.0

/**** Measure flags ****/

#define  VG_MEASFLAG_NONE       0
#define  VG_MEASFLAG_3DOBJ      1
#define  VG_MEASFLAG_3DTXT      2
#define  VG_MEASFLAG_CONTXT     4
#define  VG_MEASFLAG_SELECT     8

#define  VG_MEASFLAG_ALL        (VG_MEASFLAG_3DOBJ | VG_MEASFLAG_3DTXT | VG_MEASFLAG_CONTXT)

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

ATOMO     *GL_FindAtmByNum(VG_ULONG);
void       GL_Measure(VG_GLPREFS *, ATOMO *);
float      GL_MeasureObj(VG_ULONG, ATOMO **, VG_ULONG, void *, char *);
ATOMO     *GL_PickAtom(VG_GLPREFS *, int, int);
float      GL_PlaneAngle(ATOMO **);
void       GL_ObjRemoveMon(void);

#  ifdef __cplusplus
}
#  endif
#endif

