
/*************************************************
****          VEGA - OpenGL Surfaces          ****
**** Copyright 1996-2001, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <GL\gl.h>
#include <GL\glu.h>
#include <stdio.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "formats.h"
#include "gl_global.h"
#include "gl_colors.h"
#include "surface.h"


/**** Global variables ****/

extern char     *SrfDefExt;


/**** Show the surface in OpenGL window ****/

void GL_ShowSrf(register VG_SURFACE *Dot)
{
  glPushMatrix();
    glBegin(GL_POINTS);
      while(Dot) {
        glColor3ubv(Dot -> Color);
        glVertex3f(Dot -> x, Dot -> y, Dot -> z);
        Dot = Dot -> Next;
      }
    glEnd();
  glPopMatrix();
}


/**** Save the surface in specified format ****/

VG_BOOL GL_SrfSave(char *File, VG_SURFACE *InizSrf, ATOMO *InizAtm,
                VG_UWORD Form, VG_UWORD PackMode)
{
  char          *Ext, *OpenWrtOpt;
  FILE          *FH;
  VG_UWORD      k;

  VG_BOOL       Ret = TRUE;

  Form &= 0x00ff;
  if ((Form == SRF_IFF) || (Form == SRF_QUANTA) ||
      (Form == SRF_RAW)) OpenWrtOpt = "wb+";
  else OpenWrtOpt = "w";

  /**** Set the file extension (if needed) ****/

  if (!strchr(File, '.')) {
    Ext = SrfDefExt;
    for(k = 0; k < Form; ++k)
      Ext += strlen(Ext) + 1;
    strcat(File, ".");
    strcat(File, Ext);
  }
  AddPackExt(File, PackMode);

  if (FH = PkOpen(File, OpenWrtOpt, PackMode, TRUE)) {
    Ret = SrfSave(FH, File, InizSrf, TotalSrf, InizAtm, Form);
    if (!PkClose(FH)) Ret = FALSE;
  } else Ret = FALSE;

  return Ret;
}




