
/*************************************************
****        VEGA - Workspace manager          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <stdio.h>
#include <string.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "gl_global.h"
#include "gl_matrix.h"
#include "gl_update.h"
#include "gl_wrkspace.h"

#ifdef WIN32
#  include "Win32/gl_menu.h"
#endif

/**** Global variables ****/

VG_LIST                 *WksList = NULL;
VG_WRKSPACE             *WksCur  = NULL;

/**** Local variables ****/

static VG_LONG          WksLock  = 0;


/**** Add a new workspace ****/

VG_WRKSPACE *GL_WksAdd(void)
{
  VG_WRKSPACE           *Wks;

  if ((Wks = (VG_WRKSPACE *)ListAppend(WksList)) != NULL) {
    Wks -> MenuActFlag = VG_CM_NEW;
    Wks -> Num         = WksList -> Num - 1;
    Wks -> View.Scale  = 1.0f;
    GL_Mat4Reset(Wks -> View.RotMat);
    strcpy(Wks -> Name, GetStr(MSG_WKS_EMPTY));
  }

  return Wks;
}


/**** Check if all workspaces are empty ****/

VG_BOOL GL_WksAreEmpty(VG_BOOL All)
{
  VG_WRKSPACE           *Wks, *WksBeg;

  if (All) {
    if (BegAtm || BegObj) return FALSE;
    WksBeg = (VG_WRKSPACE *)WksList -> Beg;
  } else {
    if ((WksCur -> Num) && (BegAtm || BegObj)) return FALSE;
    WksBeg = ((VG_WRKSPACE *)WksList -> Beg) -> Next;
  }

  for(Wks = WksBeg; Wks; Wks = Wks -> Next) {
    if ((Wks != WksCur) && ((Wks -> BegAtm) || (Wks -> BegObj)))
      return FALSE;
  } /* End of for */

  return TRUE;
}


/**** Change the current workspace ****/

VG_BOOL GL_WksChange(VG_WRKSPACE *Wks, VG_ULONG Idx, VG_BOOL UpdateList)
{
  if ((WksLock) ||
      ((!Wks) && ((Wks = (VG_WRKSPACE *)ListGet(WksList, Idx)) == NULL)))
    return FALSE;

  if (WksCur == Wks) {
    if (UpdateList) DlgControlsWksUpdate();
    return TRUE;
  }

  GL_WksPush(WksCur);

  ViewPrefs.PickedAtoms = 0;
  GL_WksPop(Wks);
  GL_ChangeMenu(Wks -> MenuActFlag);
  GL_DrawForce();
  WksCur = Wks;

  if (UpdateList) DlgControlsWksUpdate();
  GL_UpdateDialogs();

/*
  DlgAtmSelUpdate();
  DlgRemResUpdate();
  DlgSelMolUpdate();
  DlgSelectUpdate();
  DlgTorsionUpdate();
  DlgTrjAnaUpdate();
*/

  return TRUE;
}


/**** Free all workspaces ****/

VG_BOOL GL_WksFree(VG_BOOL Ask)
{
  VG_WRKSPACE           *Wks, *WksNext;

  if ((Ask) && (!GL_WksAreEmpty(FALSE)) &&
      (GL_MessageBox(GetStr(MSG_WKS_REMALLCONT), NULL,
       MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON2) == IDNO))
    return FALSE;

  Wks = ((VG_WRKSPACE *)WksList -> Beg) -> Next;
  while(Wks) {
    WksNext = Wks -> Next;
    GL_WksRemove(Wks, 0, FALSE);
    Wks = WksNext;
  } /* End of while */
  GL_WksChange(NULL, 0, TRUE);

  return TRUE;
}


/**** Free all workspaces including the main workspace ****/

void GL_WksFreeAll(void)
{
  VG_WRKSPACE           *Wks;

  MC_New(FALSE);
  for(Wks = (VG_WRKSPACE *)WksList -> Beg; Wks; Wks = Wks -> Next) {
    if (Wks != WksCur) {
      GL_WksPop(Wks);
      MC_New(FALSE);
    }
  } /* End of for */
  ListClear(WksList);
}


/**** Initialize the workspace ****/

VG_BOOL GL_WksInit(void)
{
  VG_BOOL       Ret = FALSE;

  if ((WksList = ListNew(sizeof(VG_WRKSPACE))) != NULL) {
    if ((WksCur = GL_WksAdd()) != NULL) {
      Ret = TRUE;
    } else ListClear(WksList);
  }

  return Ret;
}


/**** Lock the current workspace ****/

void GL_WksLock(VG_BOOL Repaint)
{
  if (!WksLock) DlgControlsWksEnable(FALSE, Repaint);
  ++WksLock;
}


/**** Pop the workspace ****/

void GL_WksPop(VG_WRKSPACE *Wks)
{
  strcpy(LastFileName, Wks -> LastFileName);

  LastSaveFileFormat    = Wks -> LastSaveFileFormat;
  BegAtm                = Wks -> BegAtm;
  LastAtm               = Wks -> LastAtm;
  TotalAtm              = Wks -> TotalAtm;
  AtmLoaded             = Wks -> AtmLoaded;
  BegSrf                = Wks -> BegSrf;
  LastSrf               = Wks -> LastSrf;
  TotalSrf              = Wks -> TotalSrf;
  BegSel                = Wks -> BegSel;
  LastSel               = Wks -> LastSel;

#ifdef WIN32
  CopyMemory(&TrjInfo, &Wks -> TrjInfo, sizeof(TRJINFO));
#else
  memcpy(&TrjInfo, &Wks -> TrjInfo, sizeof(TRJINFO));
#endif

  /**** OpenGL ****/

  GL_WksViewPop(&Wks -> View);
  ViewPrefs.MoveMol     = Wks -> MoveMol;
  BegObj                = Wks -> BegObj;
  LastObj               = Wks -> LastObj;
  ViewPrefs.MenuActFlag = Wks -> MenuActFlag;
  ViewPrefs.TotMol      = Wks -> TotMol;
}


/**** Pop the workspace view ****/

void GL_WksViewPop(VG_WKSVIEW *View)
{
  GL_Mtx4Copy(RotMat, View -> RotMat);
  ViewPrefs.Scale      = View -> Scale;
  LastCent             = View -> LastCent;
  ViewPrefs.RotCenter  = View -> RotCenter;
  ViewPrefs.ViewCenter = View -> ViewCenter;
}


/**** Push the workspace ****/

void GL_WksPush(VG_WRKSPACE *Wks)
{
  strcpy(Wks -> LastFileName, LastFileName);

  Wks -> LastSaveFileFormat = LastSaveFileFormat;
  Wks -> BegAtm             = BegAtm;
  Wks -> LastAtm            = LastAtm;
  Wks -> TotalAtm           = TotalAtm;
  Wks -> AtmLoaded          = AtmLoaded;
  Wks -> BegSrf             = BegSrf;
  Wks -> LastSrf            = LastSrf;
  Wks -> TotalSrf           = TotalSrf;
  Wks -> BegSel             = BegSel;
  Wks -> LastSel            = LastSel;

#ifdef WIN32
  CopyMemory(&Wks -> TrjInfo, &TrjInfo, sizeof(TRJINFO));
#else
  memcpy(&Wks -> TrjInfo, &TrjInfo, sizeof(TRJINFO));
#endif

  /**** OpenGL ****/

  GL_WksViewPush(&Wks -> View);
  Wks -> MoveMol            = ViewPrefs.MoveMol;
  Wks -> BegObj             = BegObj;
  Wks -> LastObj            = LastObj;
  Wks -> MenuActFlag        = ViewPrefs.MenuActFlag;
  Wks -> TotMol             = ViewPrefs.TotMol;
}


/**** Push the workspace view ****/

void GL_WksViewPush(VG_WKSVIEW *View)
{
  GL_Mtx4Copy(View -> RotMat, RotMat);
  View -> Scale      = ViewPrefs.Scale;
  View -> LastCent   = LastCent;
  View -> RotCenter  = ViewPrefs.RotCenter;
  View -> ViewCenter = ViewPrefs.ViewCenter;
}


/**** Remove a workspace ****/

VG_BOOL GL_WksRemove(VG_WRKSPACE *Wks, VG_ULONG Idx, VG_BOOL Ask)
{
  VG_WRKSPACE           *WksNew, *WksPtr;

  if (((!Wks) && (!Idx)) ||
      (Wks == (VG_WRKSPACE *)WksList -> Beg))
    return FALSE;

  if ((!Wks) && ((Wks = (VG_WRKSPACE *)ListGet(WksList, Idx)) == NULL))
    return FALSE;

  if ((WksLock) && (Wks == WksCur)) return FALSE;

  if ((Ask) && (Wks -> TotalAtm) &&
      (GL_MessageBox(GetStr(MSG_WKS_REMCONT), NULL,
       MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON2) == IDNO))
    return FALSE;

  if (Wks == WksCur) {
    if (Wks -> Next) WksNew = Wks -> Next;
    else WksNew = Wks -> Prev;
    GL_WksPop(Wks);
    MC_New(FALSE);
    GL_WksChange(WksNew, 0, FALSE);
  } else {
    GL_WksPush(WksCur);
    WksNew = WksCur;
    GL_WksPop(Wks);
    WksCur = Wks;
    MC_New(FALSE);
    GL_WksChange(WksNew, 0, FALSE);
  }

  /**** Renumber the workspaces ****/

  for(WksPtr = Wks -> Next; WksPtr; WksPtr = WksPtr -> Next)
    --WksPtr -> Num;

  ListRemove(WksList, (VG_LISTITEM *)Wks);

  return TRUE;
}


/**** Set the workspace name ****/

void GL_WksSetName(char *NewName)
{
  if (!NewName) NewName = GetStr(MSG_WKS_EMPTY);
  strcpy(WksCur -> Name, NewName);
  DlgControlsWksUpdate();
}


/**** Unlock the current workspace ****/

void GL_WksUnLock(void)
{
  --WksLock;
  if (WksLock < 0) WksLock = 0;
  if (!WksLock) DlgControlsWksEnable(TRUE, FALSE);
}


