
/*************************************************
****        VEGA - Workspace manager          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef  __GL_WRKSPACE_H
#  define  __GL_WRKSPACE_H

#ifndef __VG_TYPES
#  include "vgtypes.h"
#endif

#ifndef __VGLIST_H
#  include "vglist.h"
#endif

#ifndef __TRAJ
#  include "traj.h"
#endif

#ifndef  __GL_OBJS
#  include "gl_objs.h"
#endif

/**** View data ****/

typedef struct {
  float                 RotMat[4][4];               /* Rotation matrix             */
  float                 Scale;                      /* Scale                       */
  XYZ                   LastCent;                   /* Last rotation center        */
  XYZ                   RotCenter;                  /* Rotation center             */
  XYZ                   ViewCenter;                 /* View center                 */
} VG_WKSVIEW;

/**** Workspace ****/

typedef struct __VgWorkSpace {
  struct __VgWorkSpace  *Next;                     /* Pointer to next element     */
  struct __VgWorkSpace  *Prev;                     /* Pointer to prevoius element */
  VG_ULONG              Num;                       /* Workspace number            */
  char                  Name[VG_MAX_PATH];         /* Workspace name              */
  char                  LastFileName[VG_MAX_PATH]; /* Last file name              */
  VG_LONG               LastSaveFileFormat;        /* Last save file format       */
  ATOMO                 *BegAtm;                   /* Atom list begin             */
  ATOMO                 *LastAtm;                  /* Last atom pointer           */
  VG_ULONG              TotalAtm;                  /* Number of atoms             */
  VG_ULONG              AtmLoaded;                 /* Loaded atoms                */
  VG_SURFACE            *BegSrf;                   /* Surface list begin          */
  VG_SURFACE            *LastSrf;                  /* Last dot pointer            */
  VG_ULONG              TotalSrf;                  /* Number of surface dots      */
  ATMSEL                *BegSel;                   /* Atom selection              */
  ATMSEL                *LastSel;                  /* Last atom selection         */
  TRJINFO               TrjInfo;                   /* Trajectory data             */

  /**** OpenGL ****/

  VG_WKSVIEW            View;                      /* Workspace view              */
  ATOMO                 *MoveMol;                  /* Molecule to move            */
  VG_GLOBJ              *BegObj;                   /* OpenGL object list          */
  VG_GLOBJ              *LastObj;                  /* Last OpenGL object          */
  VG_ULONG              MenuActFlag;               /* Menu activation             */
  VG_ULONG              TotMol;                    /* Number of molecules         */
} VG_WRKSPACE;

/**** Global variables ****/

extern VG_LIST          *WksList;
extern VG_WRKSPACE      *WksCur;

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_WRKSPACE    *GL_WksAdd(void);
VG_BOOL         GL_WksAreEmpty(VG_BOOL);
VG_BOOL         GL_WksChange(VG_WRKSPACE *, VG_ULONG, VG_BOOL);
VG_BOOL         GL_WksFree(VG_BOOL);
void            GL_WksFreeAll(void);
VG_BOOL         GL_WksInit(void);
void            GL_WksLock(VG_BOOL);
void            GL_WksPop(VG_WRKSPACE *);
void            GL_WksPush(VG_WRKSPACE *);
VG_BOOL         GL_WksRemove(VG_WRKSPACE *, VG_ULONG, VG_BOOL);
void            GL_WksSetName(char *);
void            GL_WksUnLock(void);
void            GL_WksViewPop(VG_WKSVIEW *);
void            GL_WksViewPush(VG_WKSVIEW *);

#  ifdef __cplusplus
}
#  endif
#endif
