
/*************************************************
****            VEGA - Include IFF            ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __IFF
#define  __IFF

/**** Chunk description ****/

#define  IFF_ATOMO  0x41544f4d
#define  IFF_ATYP   0x41545950
#define  IFF_CALC   0x43414c43
#define  IFF_CHAI   0x43484149
#define  IFF_CHRG   0x43485247
#define  IFF_COMM   0x434f4d4d
#define  IFF_CONX   0x434f4e58
#define  IFF_FIXA   0x46495841
#define  IFF_FORM   0x464f524d
#define  IFF_IIUB   0x49495542
#define  IFF_MOLE   0x4d4f4c45
#define  IFF_MOLN   0x4d4f4c4e
#define  IFF_RESI   0x52455349
#define  IFF_RSNA   0x52534e41
#define  IFF_RSNU   0x52534e55
#define  IFF_SEGM   0x5345474d
#define  IFF_SRFA   0x53524641
#define  IFF_SRFC   0x53524643
#define  IFF_SRFV   0x53524656
#define  IFF_SURF   0x53555246
#define  IFF_XYZ1   0x58595a31
#define  IFF_XYZ2   0x58595a32

/**** Special VEGA chunks ****/

#define  IFF_VGAC   0x56474143
#define  IFF_VGCL   0x5647434c
#define  IFF_VGLB   0x56474c42
#define  IFF_VGTR   0x56475452

/**** Chunk lenght ****/

#define  IFF_IIUB_SIZE    (1 + Tot * SizeIIUB)
#define  IFF_ATOMO_SIZE   (Tot * 2 + sizeof(VG_ULONG))
#define  IFF_ATYP_SIZE    (1 + SizeFF * Tot)
#define  IFF_CALC_SIZE    (2 * sizeof(IFFHDR) + strlen(FFName) + 1 + IFF_CHRG_SIZE + IFF_ATYP_SIZE)
#define  IFF_CHAI_SIZE    (Tot)
#define  IFF_CHRG_SIZE    (sizeof(float) * Tot)
#define  IFF_COMM_SIZE    (strlen(VEGAHdr))
#define  IFF_CONX_SIZE    (sizeof(VG_ULONG) + (sizeof(VG_ULONG) * 2 + 1) * nb)
#define  IFF_FIXA_SIZE    (sizeof(float) * Tot)
#define  IFF_FORM_SIZE    (sizeof(IFFHDR))
#define  IFF_MOLN_SIZE    (2 + (8 + 13) * NMol)
#define  IFF_RESI_SIZE    ((3 * sizeof(VG_ULONG) + 1) * NumRes)
#define  IFF_RSNA_SIZE    (sizeof(VG_UWORD) + (sizeof(VG_UWORD) + 3) * NumRes)
#define  IFF_RSNU_SIZE    (sizeof(VG_ULONG) * Tot)
#define  IFF_SEGM_SIZE    (sizeof(VG_ULONG) * TotSeg)
#define  IFF_XYZ1_SIZE    (Tot * 3 * sizeof(float))
#define  IFF_XYZ2_SIZE    (Tot * 3 * sizeof(double))

#define  IFF_SURF_SIZE    (TotSrf * sizeof(XYZ))
#define  IFF_SRFA_SIZE    (TotSrf * sizeof(VG_ULONG))
#define  IFF_SRFC_SIZE    (TotSrf * 4)
#define  IFF_SRFV_SIZE    (TotSrf * sizeof(float))

#define  IFF_VGAC_SIZE    (Tot)
#define  IFF_VGCL_SIZE    (Tot)
#define  IFF_VGLB_SIZE    (Tot)
#define  IFF_VGTR_SIZE    (sizeof(XYZ) * 4 + sizeof(float))

#define  IFF_HDRLEN       sizeof(IFFHDR)

/**** Special definitions for IFF catalog files ****/

#define  IFF_CTLG       0x43544C47  /* CTLG chunk */
#define  IFF_CTLG_LANG  0x4C414E47  /* LANG chunk */
#define  IFF_CTLG_STRS  0x53545253  /* STRS chunk */
#define  IFF_CTLG_FVER  0x46564552  /* $VER chunk */

/**** Read mode for ReadIffHdr ****/

#define  IFF_READ_NOCHK       0
#define  IFF_READ_NODOSERR    1

/**** Chunk header structure ****/

typedef struct __IFFHdr {
  VG_ULONG   ID;
  VG_ULONG   Size;
} IFFHDR;


/**** Specific prototypes ****/

FILE    *OpenIff(char *, VG_ULONG);
VG_BOOL ReadIffHdr(FILE *, IFFHDR *, VG_ULONG);

#endif

