
/*************************************************
****          VEGA - Info saver only          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/

/*
 * This code analyzes a molecule and calculates some properties
 */


#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "count.h"
#include "formats.h"
#include "logp.h"
#include "surface.h"
#include "../LocaleLib/locale.h"


/**** Info viewer ****/

VG_BOOL InfoSave(FILE *FH, ATOMO *InizAtm, VG_ULONG TotAtm)
{
  VG_BOOL           CalcChrg;
  float             AAMass[20], LogP, MaxRad, MomLip;
  float             *Contrib, *VdwRad;
  register ATMTAB   *Table;
  register ATOMO    *Atm;
  register VG_UWORD AA;
  VG_ULONG          AAComp[20], Nu, RealAtms;
  XYZ               BoxMin, BoxMax;
  XYZ               *SfUn;

#ifdef __VG_OPENGL
  VG_DLONG          *Store      = NULL;
#endif

  VG_BOOL           Ret         = TRUE;
  float             Charge      = 0.0;
  float             Gx          = 0.0;
  float             Gy          = 0.0;
  float             Gz          = 0.0;
  float             Mass        = 0.0;
  float             Mx          = 0.0;
  float             My          = 0.0;
  float             Mz          = 0.0;
  VG_LONG           PrecResName = 0;
  VG_LONG           PrecResSeq  = 0;
  VG_ULONG          HeavyAtm    = 0;
  VG_ULONG          Mols        = 0;
  VG_ULONG          Res         = 0;
  VG_ULONG          TotAA       = 0;
  VG_ULONG          Waters      = 0;


  if ((Contrib = (float *)Alloca(TotAtm * sizeof(float)))) {
    if ((VdwRad = AssignVdwRad(InizAtm, TotAtm, 0.0, &MaxRad))) {
        for(AA = 0; AA < 20; ++AA) {
          AAComp[AA] = 0;
          AAMass[AA] = 0;
        } /* End of for */
        RenameWat(InizAtm);
        CalcChrg = ChkCharges(InizAtm, TotAtm, &Charge);
        RealAtms = CountAtms(InizAtm, FALSE);

        if (CatPrintf(FH, MSG_INFO_TITLE) > 0) {
          for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
            if ((Atm -> ResName.L != PrecResName) || (Atm -> ResSeq.L != PrecResSeq)) {
              Nu = AaTranslateName(Atm -> ResName).L;
              for(AA = 0; (AA < 20) && (Nu != (VG_ULONG)AAResTab[AA].L); ++AA);
              PrecResName = Atm -> ResName.L;
              PrecResSeq  = Atm -> ResSeq.L;
              ++Res;
              if (AA < 20) {
                ++AAComp[AA];
                ++TotAA;
              }
            }
            if (Atm -> Flags & VG_ATMF_SEGEND) ++Mols;
            if (Atm -> Elem.S != (*(VG_WORD *)"H")) ++HeavyAtm;
            if ((Atm -> ResName.L == *((VG_LONG *)"HOH")) &&
                (Atm -> Elem.S == (*(VG_WORD *)"O"))) ++Waters;
            for(Table = AtmTable;*Table -> Atom.C; ++Table)
              if (Atm -> Elem.S == Table -> Atom.S) {
                if (AA < 20) AAMass[AA] += Table -> Mass;
                Mass += Table -> Mass;
                Mx   += (Table -> Mass * Atm -> x);
                My   += (Table -> Mass * Atm -> y);
                Mz   += (Table -> Mass * Atm -> z);
                break;
              }
            Gx     += Atm -> x;
            Gy     += Atm -> y;
            Gz     += Atm -> z;
          } /* End of atom loop */

          /**** Dimension of the molecule ****/

          CalcBox(InizAtm, VdwRad, &BoxMin, &BoxMax);
          if (CatPrintf(FH, MSG_INFO_PROP1,
                        RealAtms, HeavyAtm, TotAtm - RealAtms,
                        Res, Mols, Waters, Mass,
                        Gx / TotAtm, Gy / TotAtm, Gz / TotAtm,
                        Mx / Mass, My / Mass, Mz / Mass,
                        BoxMax.x - BoxMin.x, BoxMax.y - BoxMin.y, BoxMax.z - BoxMin.z) > 0) {
            if (CalcChrg) {
              if (CatPrintf(FH, MSG_INFO_CHARGE,
                            Charge, CalcDipole(InizAtm, SRF_FLG_ALLATM)) <= 0)
                Ret = PrintDosErr();
            }

            /**** If the molecule is not too large, calculate other properties ****/

            if (TotAtm <= Prefs.MAXATMINFO) {

#ifdef __VG_OPENGL
              if (GLOBSW_OPENGL) Store = FFPush(InizAtm, TotAtm);
#endif

              /**** Surface area ****/

              if (Ret) {
                AddToRad(InizAtm, VdwRad, Prefs.SAS_PROBERAD);
                if (SfUn = CalcSfUn(Prefs.SAS_POINTS, MaxRad + Prefs.SAS_PROBERAD, &Nu)) {
                  Gx = CalcSrfArea(InizAtm, VdwRad, SfUn, Nu, NULL, MaxRad + Prefs.SAS_PROBERAD, &Gy, SRF_FLG_ALLATM);
                  if ((CatPrintf(FH, MSG_INFO_SURFAREA, Prefs.SAS_PROBERAD, Gx, SQR(Gx / PI)) > 0) &&
                      (CatPrintf(FH, MSG_INFO_PSA, Gy, Gx - Gy)) > 0) {

                    /**** Molecular volume ****/

                    AddToRad(InizAtm, VdwRad, 0 - Prefs.SAS_PROBERAD);
                    Gx = CalcVolume(InizAtm, VdwRad, Prefs.VOL_DEN, &BoxMin, &BoxMax, SRF_FLG_ALLATM);
                    Gz = pow(6.0 * Gx / PI, 1.0 / 3.0);
                    if (CatPrintf(FH, MSG_INFO_VOLUME, Gx, Gz) >  0) {
                       if (fprintf(FH, "%s ", GetStr(MSG_INFO_OVALITY)) > 0) {
                        if (!Prefs.SAS_PROBERAD) {
                          if (fprintf(FH, "%.1f\n", Quad(Gy / 2.0) / Quad(Gz / 2)) <= 0)
                            Ret = PrintDosErr();
                        } else if (CatPrintf(FH, MSG_INFO_OVALNOTAVAIL) <= 0)
                          Ret = PrintDosErr();
                      } else Ret = PrintDosErr();
                    } else Ret = PrintDosErr();
                  } else Ret = PrintDosErr();
                  FREE(SfUn);
                }
              }

              /**** logP Ghose/Crippen ****/

              if (Ret) {
                if (LogPInit(InizAtm, TotAtm, Contrib, VG_LOGP_CRIPPEN)) {
                  LogP = LogPCalc(InizAtm, &MomLip, Contrib, SRF_FLG_ALLATM);
                  if (CatPrintf(FH, MSG_INFO_LOGPCRIPPEN, LogP, MomLip) <= 0)
                    Ret = PrintDosErr();
                }
              }

              /**** logP Broto/Moreau ****/

              if (Ret) {
                if (LogPInit(InizAtm, TotAtm, Contrib, VG_LOGP_BROTO)) {
                  LogP = LogPCalc(InizAtm, &MomLip, Contrib, SRF_FLG_ALLATM);

                  if (CatPrintf(FH, MSG_INFO_LOGPBROTO, LogP, MomLip) > 0) {

                    /**** Virtual logP ****/

#ifdef VLOGP
                    AddToRad(InizAtm, VdwRad, VLOGP_PROBE_RAD);
                    if (SfUn = CalcSfUn(VLOGP_DOT_DENSITY, MaxRad + VLOGP_PROBE_RAD, &Nu)) {
                      LogP = CalcVLogP(InizAtm, VdwRad, MaxRad + VLOGP_PROBE_RAD, SfUn,
                                       Nu, Contrib, SRF_FLG_ALLATM);
                      if (fprintf(FH, "%s %.4f\n", GetStr(MSG_INFO_VLOGP), LogP) <= 0)
                        Ret = PrintDosErr();
                      FREE(SfUn);
                    } else Ret = FALSE;
#else
                    if (LocPrintf(FH, "%s %s\n", GetStr(MSG_INFO_VLOGP),
                                  GetStr(MSG_INFO_NOTAVAIL)) <= 0)
                       Ret = PrintDosErr();

#endif
                  } else Ret = PrintDosErr();
                }
              }

#ifdef __VG_OPENGL
              if (Store) {
                FFPop(InizAtm, Store);
                FREE(Store);
              }
#endif

            } else PrintWarn(GetStr(MSG_INFO_TOOATM));
            if ((Ret) && (TotAA)) {
              if (HeavyAtm != TotAtm) {
                if (CatPrintf(FH, MSG_INFO_PREDCHARGE, FindRes(InizAtm, TotAtm)) <= 0)
                  Ret = PrintDosErr();
              }

              if ((Ret) && (CatPrintf(FH, MSG_INFO_AACOMP, ChargeBySeq(InizAtm)) > 0)) {
                for(AA = 0; (Ret) && (AA < 20); ++AA)
                  if (AAComp[AA]) {
                    if (fprintf(FH, " %-4s %4d  %5.2f %9.3f  %5.2f\n",
                                AAResTab[AA].C, AAComp[AA],
                                (float)((AAComp[AA]  * 100) / (float)TotAA), AAMass[AA],
                                AAMass[AA] * 100.0 / Mass) <= 0)
                      Ret = PrintDosErr();
                  }
              } else Ret = PrintDosErr();
            }
          } else Ret = PrintDosErr();
        } else Ret = PrintDosErr();

      FREE(VdwRad);
    } else Ret = FALSE;
    FREE(Contrib);
  } else Ret = FALSE;

  return Ret;
}
