
/***********************************************/
/**** Test program for libz32.a and z32.dll ****/
/****   (c) 2000-2020, Alessandro Pedretti  ****/
/***********************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "z32.h"

#define  TESTFILE               "test.Z"

/**** Prototypes ****/

void PrintErr(ZSTREAM *);

/**** Main code ****/

int main()
{
  char           DestStr[256];
  int            Num;
  ZSTREAM        *FH;

  const char     *TestStr = "Test_0123456789";

  /**** Open for write ****/

  if ((FH = zopen(TESTFILE, "w", 0)) != NULL) {
    Num = strlen(TestStr) + 1;

    /**** Write Num bytes ****/

    if (zwrite(FH, TestStr, Num) != Num) {
      PrintErr(FH);
      zclose(FH);
      exit(0);
    }
    zclose(FH);

    /**** Reopen for read ****/

    if ((FH = zopen(TESTFILE, "r", 0)) != NULL) {
      Num = strlen(TestStr) + 1;

      /**** Read Num bytes ****/

      if (zread(FH, DestStr, Num) == Num) {

        /**** Check the correct decompression ****/

        if (strcmp(TestStr, DestStr)) {
          printf("%s\n", DestStr);
          fprintf(stderr, "Packing/Unpacking error\n");
        } else printf("Test passed\n");
      } else PrintErr(FH);
      zclose(FH);
    } else fprintf(stderr, "Can't open the file to uncompress\n");
  } else fprintf(stderr, "Can't open the file to compress\n");

  return 0;
}


/**** Shows an error in the z steam ****/

void PrintErr(ZSTREAM *zs)
{
  int           ErrCode;

  char          *MsgErr = zerror(zs, &ErrCode);

  fprintf(stderr, "Z ERROR %d: %s\n\n", ErrCode, MsgErr);
}
