
/********************************************/
/****    libZ32.a and Z32.dll include    ****/
/**** (c) 2000-2020, Alessandro Pedretti ****/
/********************************************/

/*
 * Define Z32_DLL to use and compile Z32_DLL
 */

#ifndef _Z32_H
#define _Z32_H

#if defined(sgi) || defined(linux) || defined(AMIGA)
#  include <sys/types.h>
#endif

#if defined(_WINDOWS) || defined(WINDOWS) || defined(_WIN32) || defined(_WIN32_)
#  ifndef WIN32
#    define WIN32
#endif
//#ifndef __MINGW32__
typedef unsigned char  u_char;
typedef unsigned int   u_int;
typedef unsigned short u_short;
//#endif
#endif

#if defined(WIN32) && defined(Z32_DLL)
#  include <windows.h>
#  if defined(__MINGW32__) ||  defined(_MSC_VER)
#      define  ZEXPORT
#      define  ZEXTERN         __declspec(dllexport)
#  else
#    define  ZEXPORT           __declspec(dllexport) WINAPI
#endif
#endif

#ifndef ZEXTERN
#define  ZEXTERN        extern
#endif

#ifndef ZEXPORT
#  define  ZEXPORT
#endif

/* A code_int must be able to hold 2**Z_BITS values of type int, and also -1. */

typedef long code_int;
typedef long count_int;


typedef u_char         char_type;

#define Z_BITS    16                    /* Default bits.                      */
#define Z_HSIZE   69001                 /* 95% occupancy                      */

typedef struct s_zstate {
  FILE          *zs_fp;                 /* File stream for I/O                */
  int           zs_errno;               /* Error code                         */
  int           dos_errno;              /* Dos error code                     */
  char          zs_mode;                /* r or w                             */
  enum {
    S_START, S_MIDDLE, S_EOF
  } zs_state;                           /* State of computation               */
  int           zs_n_bits;              /* Number of bits/code.               */
  int           zs_maxbits;             /* User settable max # bits/code.     */
  code_int      zs_maxcode;             /* Maximum code, given n_bits.        */
  code_int      zs_maxmaxcode;          /* Should NEVER generate this code.   */
  count_int     zs_htab [Z_HSIZE];
  u_short       zs_codetab [Z_HSIZE];
  code_int      zs_hsize;               /* For dynamic table sizing.          */
  code_int      zs_free_ent;            /* First unused entry.                */

  /*
   * Block compression parameters -- after all codes are used up,
   * and compression rate changes, start over.
   */

  int           zs_block_compress;
  int           zs_clear_flg;
  long          zs_ratio;
  count_int     zs_checkpoint;
  int           zs_offset;
  long          zs_in_count;        /* Length of input.                   */
  long          zs_bytes_out;       /* Length of compressed output.       */
  long          zs_out_count;       /* # of codes output (for debugging). */
  char_type     zs_buf[Z_BITS];
  union {
    struct {
      long      zs_fcode;
      code_int  zs_ent;
      code_int  zs_hsize_reg;
      int       zs_hshift;
    } w;                                /* Write paramenters                  */
    struct {
      char_type *zs_stackp;
      int       zs_finchar;
      code_int  zs_code, zs_oldcode, zs_incode;
      int       zs_roffset, zs_size;
      char_type zs_gbuf[Z_BITS];
    } r;              /* Read parameters                    */
  } u;
} ZSTREAM;


/**** Prototypes ****/

/*
 * Close a ZSTREAM. The return value is -1 if an error occurs, otherwise is 0.
 */

ZEXTERN int       ZEXPORT zclose(ZSTREAM *);

/*
 * Return the code error and the explicative character string. It reseta all
 * error vectors.
 */

ZEXTERN char *    ZEXPORT zerror(ZSTREAM *, int *);

/*
 * Open a stream Z copmressed. File name, mode (r, w) and number of bits (0-16)
 * are needed. If an error occurs, the return value is 0, otherwise is the
 * pointer to ZSTREAM structure.
 */

ZEXTERN ZSTREAM * ZEXPORT zopen(const char *, const char *, int);

/*
 * Read a zstream and return the number of readed bytes. If an error occurs,
 * the return value is -1.
 */

ZEXTERN int       ZEXPORT zread(ZSTREAM *, char *, int);

/*
 * Write a zstream and return the number of written bytes. If an error occurs,
 * the return value is -1.
 */

ZEXTERN int       ZEXPORT zwrite(ZSTREAM *, const char *, int);


/**** Error codes ****/

#define  Z_ERR_OK               0  /* All rights             */
#define  Z_ERR_MAXBITS          1  /* Too many bits in zopen */
#define  Z_ERR_RDDATA           2  /* Can't read data        */
#define  Z_ERR_RDHDR            3  /* Can't read the header  */
#define  Z_ERR_WRTDATA          4  /* Can't write data       */
#define  Z_ERR_WRTHDR           5  /* Can't write the header */
#endif

