
/*******************************************
****         64 bit I/O library         ****
**** (c) 2005-2020, Alessandro Pedretti ****
*******************************************/

/*
 * BCB WARNING: The library doesn't work if the RTL is
 * linked dynamically.
 */


#ifndef  __IO64_H
#  define  __IO64_H

#  include <stdio.h>

#  ifdef IO64_USE_FASTCALL
#    define  IO64_FASTCALL      __fastcall
#  else
#    define  IO64_FASTCALL
#  endif

/**** Types ****/

#ifdef __BORLANDC__
typedef __int64                 fpos64_t;
typedef __int64                 off64_t;
#else
typedef long long               fpos64_t;
typedef long long               off64_t;
#endif

#  if defined(AMIGA) || defined(WIN64)
#    define  fgetpos64          fgetpos
#    define  fseeko64           fseek
#    define  fsetpos64          fsetpos
#    define  ftello64           ftell
#  endif

#  ifdef linux
#    define  fgetpos64          fgetpos
#    define  fseeko64           fseeko
#    define  fsetpos64          fsetpos
#    define  ftello64           ftello
#  endif

#  if (__BORLANDC__ > 0x0564)
#    ifdef fgetpos64
#      undef fgetpos64
#    endif

#    ifdef fseeko64
#      undef fseeko64
#    endif

#    ifdef fsetpos64
#      undef fsetpos64
#    endif

#    ifdef ftello64
#      undef ftello64
#    endif

#    define  fgetpos64(S, P)    (((*P = _ftelli64(S)) == -1LL) ? -1 : 0)
#    define  fseeko64           _fseeki64
#    define  fsetpos64(S, P)    _fseeki64(S, *P, SEEK_SET)
#    define  ftello64           _ftelli64
#  else

/**** Prototypes ****/

#    ifdef __cplusplus
extern "C" {
#    endif

#      ifdef __BORLANDC__
__int64         IO64_FASTCALL _lseeki64(int FD, __int64 Offset, int Kind);
#      endif

#      if !defined(linux) && !defined(AMIGA) && !defined(WIN64)
int             IO64_FASTCALL fgetpos64(FILE *Stream, fpos64_t *Position);
int             IO64_FASTCALL fseeko64(FILE *Stream, off64_t Offset, int Whence);
int             IO64_FASTCALL fsetpos64(FILE *Stream, const fpos64_t *Position);
off64_t         IO64_FASTCALL ftello64(FILE *Stream);
#      endif
#    ifdef __cplusplus
}
#    endif
#  endif
#endif
