
/*******************************************
****         64 bit I/O library         ****
****           Test software            ****
**** (c) 2005-2020, Alessandro Pedretti ****
*******************************************/


#include <stdio.h>
#include <stdlib.h>
#include <io64.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  pragma argsused

#  ifdef __clang__
#    define  QUAD_PRT           "%lld"
#  else
#    define  QUAD_PRT           "%Ld"
#  endif
#endif

#ifdef __MINGW32__
#  define  QUAD_PRT             "%I64d"
#endif

#ifndef  QUAD_PRT
#  define  QUAD_PRT             "%lld"
#endif

#define  TEST_FILENAME          "E:\\Temp\\Test.bin"


/**** Main code ****/

int main(int argc, char* argv[])
{
  FILE          *FH;
  fpos64_t      Pos;

  unsigned int  k;

  const char    *Ok   = "Ok";
  const char    *Fail = "FAIL";

  if ((FH = fopen(TEST_FILENAME, "rb+")) == NULL) {
    fprintf(stderr, "Can't open the test file\n");
    return 0;
  }

  /**** SEEK_SET test ****/

  fseeko64(FH, sizeof(unsigned int) * 1100000000LL, SEEK_SET);
  if (fread(&k, sizeof(unsigned int), 1, FH) == 1) {
    printf("Value: %d (%s)\n", k, (k == 1100000000LL) ? Ok: Fail);
    Pos = ftello64(FH);
    printf("Position: " QUAD_PRT " (%s)\n", Pos, (Pos == 4400000004LL) ? Ok: Fail);
  } else {
    fprintf(stderr, "Read error\n");
    exit(0);
  }

  /**** SEEK_CUR test ****/

  fseeko64(FH, 4LL, SEEK_CUR);
  if (fread(&k, sizeof(unsigned int), 1, FH) == 1) {
    printf("Value: %d (%s)\n", k, (k == 1100000002LL) ? Ok: Fail);
    Pos = ftello64(FH);
    printf("Position: " QUAD_PRT " (%s)\n", Pos, (Pos == 4400000012LL) ? Ok: Fail);
  } else {
    fprintf(stderr, "Read error\n");
    exit(0);
  }

  /**** SEEK_END test ****/

  fseeko64(FH, -4LL, SEEK_END);
  if (fread(&k, sizeof(unsigned int), 1, FH) == 1) {
    printf("Value: %d (%s)\n", k, (k == 1999999999LL) ? Ok: Fail);
    Pos = ftello64(FH);
    printf("Position: " QUAD_PRT " (%s)\n", Pos, (Pos == 8000000000LL) ? Ok: Fail);
  } else {
    fprintf(stderr, "Read error\n");
  }

  fclose(FH);

  return 0;
}





