
/*************************************************
****          VEGA - Command errors           ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __COMERR_H
#define __COMERR_H

/**** Return codes ****/

#define  VG_PARET_OK                0     /* No errors                       */

#define  VG_PARET_ABORT             1     /* Abort                           */
#define  VG_PARET_LOCALE            2     /* LocaleLib error                 */
#define  VG_PARET_NOCOM             3     /* No command                      */
#define  VG_PARET_OUTOFMEM          4     /* Out of memory                   */

/**** Input/Output ****/

#define  VG_PARET_IOBZIP2          51     /* Bzip2 error                     */
#define  VG_PARET_IOCANTPACK       52     /* Can't pack the file             */
#define  VG_PARET_IODOS            53     /* DOS I/O error                   */
#define  VG_PARET_IOGZIP           54     /* Gzip error                      */
#define  VG_PARET_IONOSTDOUT       55     /* Stdout not allowed              */
#define  VG_PARET_IOPKSTDOUT       56     /* No stdout with packed output    */
#define  VG_PARET_IOPOWERPK        57     /* PowerPacker error               */
#define  VG_PARET_IOPOWERPKCR      58     /* PowerPacker comp. AmigaOS only  */
#define  VG_PARET_IOPOWERPKLIB     59     /* PowerPacker.library not found   */
#define  VG_PARET_IOPOWERPSHORT    60     /* File too short                  */
#define  VG_PARET_IOUNKPACK        61     /* Unknown compressor              */
#define  VG_PARET_IOVEGADIR        62     /* Set the environment variable    */
#define  VG_PARET_IOXPK            63     /* xPK error                       */
#define  VG_PARET_IOZ32            64     /* Z32 error                       */

#define  VG_PARET_UNKCOM          101     /* Unknown command                 */
#define  VG_PARET_TOOARGS         102     /* Too many arguments              */
#define  VG_PARET_FEWARGS         103     /* Too few arguments               */
#define  VG_PARET_ILLARG          104     /* Illegal type of argument        */
#define  VG_PARET_EXCRANGE        105     /* Value exceed the legal range    */
#define  VG_PARET_UNKKEYWORD      106     /* Unknown keyword in argument     */

#define  VG_PARET_NOTIMP          201     /* Command not already implemented */
#define  VG_PARET_OGLONLY         202     /* Command for OpenGL only         */
#define  VG_PARET_NOMOL           203     /* No molecule                     */
#define  VG_PARET_NOSRF           204     /* No surface present              */

/**** Command line ****/

#define  VG_PARET_AGPATMNUM       301     /* Total number of atoms exceeded  */
#define  VG_PARET_AGPDUPDESC      302     /* Duplicate description           */
#define  VG_PARET_AGPILLATN       303     /* Illegal atom number             */
#define  VG_PARET_AGPILLNMES      304     /* Illegal number of atoms in meas */
#define  VG_PARET_AGPINCDESC      305     /* Incorrect atom description      */
#define  VG_PARET_AGPINPFILE      306     /* It don't match the input file   */
#define  VG_PARET_AGPMATCH        307     /* Description with multiple match */
#define  VG_PARET_AGPTOOFEW       308     /* Too few atoms to measure        */
#define  VG_PARET_AGPTOOLONG      309     /* Atom description too long       */
#define  VG_PARET_AGPUNKMES       310     /* Unknown measure mode            */

/**** Load and save operations ****/

#define  VG_PARET_MOLBIOSNS       401     /* Biosym subformat not supported  */
#define  VG_PARET_MOLCOMFAFL      402     /* Field type not specified        */
#define  VG_PARET_MOLCOMFARG      403     /* Sybyl rgn file not loaded       */
#define  VG_PARET_MOLCONBORD      404     /* Unacceptable bond order         */
#define  VG_PARET_MOLCONVDW       405     /* Unknown VDW radius              */
#define  VG_PARET_MOLCRDASS       406     /* No associated molecule file     */
#define  VG_PARET_MOLCRDMEAS      407     /* Type of measure not specified   */
#define  VG_PARET_MOLCSSR         408     /* CSSR/QMC format more than 9999  */
#define  VG_PARET_MOLFASTA        409     /* Input file isn't protein or DNA */
#define  VG_PARET_MOLIFFCORR      410     /* Corrupted IFF file              */
#define  VG_PARET_MOLIFFINV       411     /* Invalid IFF file                */
#define  VG_PARET_MOLIFFNOT       412     /* Not an IFF XXXX file            */
#define  VG_PARET_MOLMOL2CORR     413     /* Corrupted or incoplete Mol2     */
#define  VG_PARET_MOLMOL2NOTF     414     /* Can't find TRIPOS template      */
#define  VG_PARET_MOLMOL2TEMP     415     /* Illegal TRIPOS template         */
#define  VG_PARET_MOLMSFFORMAT    416     /* The file isn't in MSF format    */
#define  VG_PARET_MOLMSFNCOMP     417     /* The MSF file isn't compatible   */
#define  VG_PARET_MOLMOPACATOM    418     /* Faulty atom                     */
#define  VG_PARET_MOLMOPACBADCON  419     /* Bad cartesian to internal conv. */
#define  VG_PARET_MOLNOCHARGE     420     /* The format don't support charge */
#define  VG_PARET_MOLNOFFTAG      421     /* The format don't support ff tag */
#define  VG_PARET_MOLNOTFOUND     422     /* Input file not found            */
#define  VG_PARET_MOLRGNCORRUPT   423     /* Corrupted rgn file              */
#define  VG_PARET_MOLRGNNOMOL     424     /* Region file without a molecule  */
#define  VG_PARET_MOLRGNNUMSTPS   425     /* Illegal number of steps in rgn  */
#define  VG_PARET_MOLRGNPOINTS    426     /* Illegal number of points in rgn */
#define  VG_PARET_MOLRGNSTPSIZE   427     /* Illegal step size in rgn file   */
#define  VG_PARET_MOLUNKINFOR     428     /* Unknown input format            */
#define  VG_PARET_MOLUNKOUTFOR    429     /* Unknown output format           */
#define  VG_PARET_SRFNOMOL        430     /* No molecule loaded              */

/**** Merge ****/

#define  VG_PARET_MERGEUNALLELEM  455     /* Unallowed merge                 */
#define  VG_PARET_MERGEUNCOMP     456     /* Uncompatible molecules          */

/**** Plots ****/

#define  VG_PARET_PLOTSAVER       461     /* With a trajectory only          */
#define  VG_PARET_PLOTPOINTRANGE  462     /* Point out of range              */

/**** Solvatation ****/

#define  VG_PARET_SOLCANTOPEN     471     /* Can't open shell file           */
#define  VG_PARET_SOLNOTHING      472     /* Nothing to add                  */
#define  VG_PARET_SOLSHELLDIM     473     /* Molecule exceeds the shell dim. */

/**** Trajectory analysis ****/

#define  VG_PARET_DCDSELECT       481     /* Incorrect selection             */
#define  VG_PARET_DCDUNCHARGED    482     /* Unassigned atomic charges       */
#define  VG_PARET_DCDUNKTRAJ      483     /* Unknown trajectory file         */
#define  VG_PARET_DCDUNSOUT       484     /* Unsupported output              */
#define  VG_PARET_DCDNOMOL        485     /* No molecule loaded              */
#define  VG_PARET_DCDGRAPH        486     /* Energy graph can't be showed    */
#define  VG_PARET_DCDNOOUT        487     /* Output file not specified       */    

/**** Charges ****/

#define  VG_PARET_CHGNOTASS       501     /* Atomic charges not assigned     */
#define  VG_PARET_CHGILLCOM       502     /* Illagal command in charge temp. */
#define  VG_PARET_CHGUNKCHG       503     /* Unknown charge                  */
#define  VG_PARET_CHGUNKCOM       504     /* Unknown command in charge temp. */

/**** Force field ****/

#define  VG_PARET_FFATYTOOLG      520     /* Atom type too long              */
#define  VG_PARET_FFCANTASS       521     /* Can't assign potential          */
#define  VG_PARET_FFILLNUM        522     /* Illegal number of arguments     */
#define  VG_PARET_FFINCATM        523     /* Incorrect atom description      */
#define  VG_PARET_FFINCSATM       524     /* Incorrect subatom description   */
#define  VG_PARET_FFNOTFOUND      525     /* Template file not found         */
#define  VG_PARET_FFNOTSTD        526     /* Template not in standard format */
#define  VG_PARET_FFSUBLVL        527     /* Sublevel overflow               */
#define  VG_PARET_FFUNBPAR        528     /* Unbalenced parenthesis          */

/**** Calculations ****/

#define  VG_PARET_CALEFFNOTASS    601     /* Force field not assigned        */
#define  VG_PARET_CALENNOBOND     602     /* Non-bond parameters not found   */
#define  VG_PARET_CALENNOFF       603     /* Can't open template             */
#define  VG_PARET_CALENRES        604     /* More than one residue is needed */
#define  VG_PARET_CALENRESNF      605     /* Residue not found               */
#define  VG_PARET_CALENUNKTYP     606     /* Unknown atom type               */
#define  VG_PARET_CALLOGPNOPAR    607     /* Not all atoms are parametrized  */
#define  VG_PARET_CALLOGNOTF      608     /* Parameters not found            */
#define  VG_PARET_CALLOGPUNREC    609     /* Unrecognized parameter file     */
#define  VG_PARET_CALNOVLOGP      610     /* No Virtual logP calculation     */
#define  VG_PARET_CALSRFILM       611     /* A water cluster required        */

/**** Command line options ****/

#define  VG_PARET_OPTCHGTEMP      701     /* Can't find the charge template  */
#define  VG_PARET_OPTCOLUNK       702     /* Unknown color                   */
#define  VG_PARET_OPTFILEMISS     703     /* Missing input file name         */
#define  VG_PARET_OPTFLOATNUM     704     /* Argument must be unsigned float */
#define  VG_PARET_OPTILLDIEL      705     /* Illegal dielectric constant     */
#define  VG_PARET_OPTILLPRORAD    706     /* Illegal probe radius            */
#define  VG_PARET_OPTILLRESNAM    707     /* Illegal residue name            */
#define  VG_PARET_OPTILLSASDEN    708     /* Illegal SAS density             */
#define  VG_PARET_OPTILLSOLRAD    709     /* Illegal solvatation radius      */
#define  VG_PARET_OPTILLSTRRES    710     /* Illegal starting residue        */
#define  VG_PARET_OPTINTNUM       711     /* Argument must be an unsigned int*/
#define  VG_PARET_OPTOGLPORT      712     /* Invalid port number             */
#define  VG_PARET_OPTOGLRUN       713     /* VEGA OpenGL already running     */
#define  VG_PARET_OPTSUBARG       714     /* Missing sub-argument            */
#define  VG_PARET_OPTUNK          715     /* Unknown option                  */
#define  VG_PARET_OPTUNKSHAPE     716     /* Unknown shape type              */
#define  VG_PARET_OPTUNKSHELL     717     /* Shell file not found            */
#define  VG_PARET_OPTUNSCHGTMP    718     /* Unsupported charge template     */
#define  VG_PARET_OPTWIN32        719     /* Option available only in Win32  */

/**** Console ****/

#define  VG_PARET_CONSAVEBUF      801     /* Unable to save the buffer       */

/**** GL initialisation ****/

#define  VG_PARET_GLINIACTCON    1001     /* Can't activate the GL context   */
#define  VG_PARET_GLINICONTEXT   1002     /* Can't create GL device context  */
#define  VG_PARET_GLINICRCONTXT  1003     /* Can't create GL rend. context   */
#define  VG_PARET_GLINIFAIL      1004     /* OpenGL initialization failed    */
#define  VG_PARET_GLINIPXFORM1   1005     /* Can't find suitable pixelformat */
#define  VG_PARET_GLINIPXFORM2   1006     /* Can't set the pixel format      */
#define  VG_PARET_GLINIWNDCLASS  1007     /* Failed to register window class */
#define  VG_PARET_GLINIWNDCREAT  1008     /* Window creation error           */

/**** GL generic ****/

#define  VG_PARET_GLCOLUNK       1101     /* Unknown color                   */
#define  VG_PARET_GLDEVIL        1102     /* DevIL error                     */
#define  VG_PARET_GLFMOD         1103     /* Fmod error                      */
#define  VG_PARET_GLMENCANTEXE   1104     /* Can't execute                   */
#define  VG_PARET_GLMENHELP      1105     /* Can't open help file            */
#define  VG_PARET_GLDEMONOTINST  1106     /* Demo files not installed        */

/**** GL Mopac ****/

#define  VG_PARET_GLMOPACEXE     1201     /* Can't find MoPac executable     */
#define  VG_PARET_GLMOPACNOARC   1202     /* Abnormal termination            */
#define  VG_PARET_GLMOPACTOOATM  1203     /* Too many atoms                  */

/**** GL BioDock ****/

#define  VG_PARET_GLBDARGMIS     1301     /* Missing argument                */
#define  VG_PARET_GLBDBEGMIS     1302     /* Missing BEGIN command           */
#define  VG_PARET_GLBDCONVFACT   1303     /* The value must be lower than 1  */
#define  VG_PARET_GLBDDUPCOM     1304     /* Command duplicated              */
#define  VG_PARET_GLBDFRMSELINV  1305     /* Invalid selection of frames     */
#define  VG_PARET_GLBDFRMSELMIS  1306     /* Missing selection of frames     */
#define  VG_PARET_GLBDMACROCLS   1307     /* Field already closed in macro   */
#define  VG_PARET_GLBDMACROFREQ  1308     /* Field required                  */
#define  VG_PARET_GLBDMACRONCLS  1309     /* Field not closed in macro       */
#define  VG_PARET_GLBDMACRONOPN  1310     /* Field not opened in macro       */
#define  VG_PARET_GLBDMACROOPN   1311     /* Field already opened in macro   */
#define  VG_PARET_GLBDMISCOM     1312     /* Missing command                 */
#define  VG_PARET_GLBDMODULE     1313     /* Unknown module                  */
#define  VG_PARET_GLBDNULLSTR    1314     /* Null string not allowed         */
#define  VG_PARET_GLBDNUMBOOL    1315     /* Boolean value required          */
#define  VG_PARET_GLBDNUMFLOAT   1316     /* Float number required           */
#define  VG_PARET_GLBDNUMFRM     1317     /* Illegal number of frames (> 1)  */
#define  VG_PARET_GLBDNUMNULL    1318     /* The value can't be zero         */
#define  VG_PARET_GLBDNUMINT     1319     /* Integer number required         */
#define  VG_PARET_GLBDNUMPOS     1320     /* Positive integer required       */
#define  VG_PARET_GLBDROTPOS     1321     /* The rotation ranges must be +   */
#define  VG_PARET_GLBDTOOLINES   1322     /* The input file exceeds 65535 l. */
#define  VG_PARET_GLBDTRANSPOS   1323     /* The trans. ranges must be +     */
#define  VG_PARET_GLBDUNKCOM     1324     /* Unknown command                 */
#define  VG_PARET_GLBDUNKEXTRA   1325     /* Unknown extraction mode         */
#define  VG_PARET_GLBDUNKOPTMET  1326     /* Unknown optimization method     */
#define  VG_PARET_GLBDUNTERMSTR  1327     /* Unterminated string             */
#define  VG_PARET_GLBDBIODOCKEXE 1328     /* Can't find BioDock executable   */
#define  VG_PARET_GLBDBIOPRJ     1329     /* Can't open BioDock input file   */
#define  VG_PARET_GLBDBIOOUT     1330     /* Unrecognized BioDock output     */
#define  VG_PARET_GLBSTRUCTOUT   1331     /* BioDock output corrupted        */

/**** GL measure ****/

#define  VG_PARET_GLMEASATMMULTI 1401     /* Multiple selection              */
#define  VG_PARET_GLMEASATMNFND  1402     /* Atom not found                  */

/**** GL select ****/

#define  VG_PARET_GLSELDONTMATCH 1501     /* The selection doesn't match     */
#define  VG_PARET_GLSELILLNUMARG 1502     /* Illegal number of arguments     */
#define  VG_PARET_GLSELUNKTAG    1503     /* Unknown tag                     */

/**** ESCHER Next Generation ****/

#define  VG_PARET_GLESCORRFILE   1601     /* Corrupted ESCHER file           */
#define  VG_PARET_GLESNUMSOL     1602     /* Illegal number of solutions     */
#define  VG_PARET_GLESUNKFORMAT  1603     /* Unknown format                  */

/**** Graph Editor ****/

#define  VG_PARET_GRAPH_ILLID    1701    /* Illegal GraphEd ID               */
#define  VG_PARET_GRAPH_NOCUR    1702    /* No GraphEd window opened         */
#define  VG_PARET_GRAPH_POINTRNG 1703    /* Point out of range               */

/**** Database engine ****/

#define  VG_PARET_DBCREATE       1801     /* Can't create the database       */
#define  VG_PARET_DBGET          1802     /* Unable to get the molecule      */
#define  VG_PARET_DBMOLLIST      1803     /* Unable to read the mol. catalog */
#define  VG_PARET_DBOPEN         1804     /* Database already opened         */
#define  VG_PARET_DBPUT          1805     /* Unable to put the molecule      */
#define  VG_PARET_DBREMOVE       1806     /* Unable to remove the molecule   */
#define  VG_PARET_DBREN          1807     /* Unable to rename the molecule   */
#define  VG_PARET_DBUNKFOR       1808     /* Unknown database format         */
#define  VG_PARET_DBUPDATE       1809     /* Unable to update the molecule   */
#define  VG_PARET_DBZIP32INIT    1810     /* The zip32.dll can't be init.    */

/**** Windows errors ****/

#define  VG_PARET_WINDOWS        3001     /* Windows error                   */
#define  VG_PARET_WINDOWSFADDR   3002     /* Can't get the function address  */
#define  VG_PARET_WINDOWSDLL     3003     /* Can't open the DLL              */
#define  VG_PARET_WINDOWSMCI     3004     /* Windows MCI error               */

#define  VG_PARET_UNKERR         9000     /* Unknown error                   */

#define  VG_PARET_CLIPBOARD      9999     /* Return data in clipboard        */


/**** Error translation table ****/

struct _ErrTab {
  VG_UWORD      ErrCode;
  VG_UWORD      StrId;
};

#ifdef __VG_ERRTRANSTAB

const struct _ErrTab ErrTab[] = {

  /**** Command line ****/

  {VG_PARET_AGPATMNUM     , MSG_ERR_ARGPAR_ATMNUM           },
  {VG_PARET_AGPDUPDESC    , MSG_ERR_ARGPAR_DUPDESC          },
  {VG_PARET_AGPILLATN     , MSG_ERR_ARGPAR_ILLATMNUM        },
  {VG_PARET_AGPILLNMES    , MSG_ERR_ARGPAR_ILLNUMMES        },
  {VG_PARET_AGPINCDESC    , MSG_ERR_ARGPAR_INCDESC          },
  {VG_PARET_AGPINPFILE    , MSG_ERR_ARGPAR_INPFILE          },
  {VG_PARET_AGPMATCH      , MSG_ERR_ARGPAR_MATCH            },
  {VG_PARET_AGPTOOFEW     , MSG_ERR_ARGPAR_TOOFEW           },
  {VG_PARET_AGPTOOLONG    , MSG_ERR_ARGPAR_TOOLONG          },
  {VG_PARET_AGPUNKMES     , MSG_ERR_ARGPAR_UNKMES           },

  /**** Calculations ****/

  {VG_PARET_CALEFFNOTASS  , MSG_ERR_ENER_FFNOTASS           },
  {VG_PARET_CALENNOFF     , MSG_ERR_ENER_FFNOTFOUND         },
  {VG_PARET_CALENNOBOND   , MSG_ERR_ENER_NONBOND            },
  {VG_PARET_CALENRES      , MSG_ERR_ENER_MORERES            },
  {VG_PARET_CALENRESNF    , MSG_ERR_ENER_RESNOTFOUND        },
  {VG_PARET_CALENUNKTYP   , MSG_ERR_ENER_UNKATMTYPE         },
  {VG_PARET_CALLOGPNOPAR  , MSG_ERR_LOGP_NOTALLPAR          },
  {VG_PARET_CALLOGNOTF    , MSG_ERR_LOGP_NOTFOUND           },
  {VG_PARET_CALLOGPUNREC  , MSG_ERR_LOGP_UNRECFILE          },
  {VG_PARET_CALNOVLOGP    , MSG_ERR_MLP_NOVLOGP             },
  {VG_PARET_CALSRFILM     , MSG_ERR_SURFACE_ILM             },

  /**** Charge and potential ****/

  {VG_PARET_CHGNOTASS     , MSG_DLGCHG_ERR_NOTASS           },
  {VG_PARET_CHGILLCOM     , MSG_ERR_CHARGE_ILLCOM           },
  {VG_PARET_CHGUNKCHG     , MSG_ERR_CHARGE_UNKCHARGE        },
  {VG_PARET_CHGUNKCOM     , MSG_ERR_CHARGE_UNKCOM           },

#ifdef __VG_OPENGL

  /**** Database engine ****/

  {VG_PARET_DBCREATE      , MSG_ERR_DBENGINE_CREATE         },
  {VG_PARET_DBMOLLIST     , MSG_ERR_DBENGINE_MOLLIST        },
  {VG_PARET_DBGET         , MSG_ERR_DBENGINE_GET            },
  {VG_PARET_DBOPEN        , MSG_ERR_DBENGINE_OPEN           },
  {VG_PARET_DBPUT         , MSG_ERR_DBENGINE_PUT            },
  {VG_PARET_DBREMOVE      , MSG_ERR_DBENGINE_REMOVE         },
  {VG_PARET_DBREN         , MSG_ERR_DBENGINE_REN            },
  {VG_PARET_DBUNKFOR      , MSG_ERR_DBENGINE_UNKFOR         },
  {VG_PARET_DBUPDATE      , MSG_ERR_DBENGINE_UPDATE         },
  {VG_PARET_DBZIP32INIT   , MSG_ERR_DBENGINE_ZIP32INIT      },

#endif

  /**** Command arguments ****/

  {VG_PARET_EXCRANGE      , MSG_ERR_COM_EXCRANGEF           },
  {VG_PARET_EXCRANGE      , MSG_ERR_COM_EXCRANGEI           },
  {VG_PARET_EXCRANGE      , MSG_ERR_COM_EXCRANGEUI          },
  {VG_PARET_EXCRANGE      , MSG_ERR_COM_EXCRANGEC           },

  /**** Trajectory analysis ****/

  {VG_PARET_DCDSELECT     , MSG_ERR_ANA_SELECT              },
  {VG_PARET_DCDGRAPH      , MSG_ERR_ANA_GRAPH               },
  {VG_PARET_DCDUNCHARGED  , MSG_ERR_DCD_UNCHARGED           },
  {VG_PARET_DCDUNKTRAJ    , MSG_ERR_DCD_UNKTRAJ             },
  {VG_PARET_DCDUNSOUT     , MSG_ERR_DCD_UNSUPPOUT           },
  {VG_PARET_DCDNOMOL      , MSG_ERR_DCD_NOMOL               },
  {VG_PARET_DCDNOOUT      , MSG_ERR_DCD_NOOUT               },

  /**** ESCHER Next Generation ****/

  {VG_PARET_GLESCORRFILE  , MSG_ERR_ESCHER_CORRFILE         },
  {VG_PARET_GLESNUMSOL    , MSG_ERR_ESCHER_NUMSOL           },
  {VG_PARET_GLESUNKFORMAT , MSG_ERR_ESCHER_UNKFORMAT        },

  /**** Graph Editor ****/

  {VG_PARET_GRAPH_ILLID   , MSG_ERR_GRAPH_ILLID             },
  {VG_PARET_GRAPH_NOCUR   , MSG_ERR_GRAPH_NOCUR             },
  {VG_PARET_GRAPH_POINTRNG, MSG_ERR_GRAPH_POINTRANGE        },

  /**** Force field ****/

  {VG_PARET_FFATYTOOLG    , MSG_ERR_FFIELD_ATYPTOOLONG      },
  {VG_PARET_FFCANTASS     , MSG_ERR_FFIELD_CANTASSIGN       },
  {VG_PARET_FFILLNUM      , MSG_ERR_FFIELD_ILLNUM           },
  {VG_PARET_FFINCATM      , MSG_ERR_FFIELD_INCATM           },
  {VG_PARET_FFINCSATM     , MSG_ERR_FFIELD_INCSUBATM        },
  {VG_PARET_FFNOTFOUND    , MSG_ERR_FFIELD_NOTFOUND         },
  {VG_PARET_FFNOTFOUND    , MSG_ERR_MAIN_FFNOTFOUND         },
  {VG_PARET_FFNOTSTD      , MSG_ERR_MAIN_FFNOTSTD           },
  {VG_PARET_FFSUBLVL      , MSG_ERR_FFIELD_SUBLVL           },
  {VG_PARET_FFUNBPAR      , MSG_ERR_FFIELD_UNBPAR           },

#ifdef __VG_OPENGL

  /**** Console ****/

  {VG_PARET_CONSAVEBUF    , MSG_ERR_CON_SAVEBUF             },

  /**** GL BioDock ****/

  {VG_PARET_GLBDARGMIS    , MSG_BIODOCK_ERR_ARGMIS          },
  {VG_PARET_GLBDBEGMIS    , MSG_BIODOCK_ERR_BEGMIS          },
  {VG_PARET_GLBDBIODOCKEXE, MSG_ERR_BIODOCK_BIODOCKEXE      },
  {VG_PARET_GLBDBIOOUT    , MSG_ERR_BIODOCK_BIOOUT          },
  {VG_PARET_GLBDBIOPRJ    , MSG_ERR_BIODOCK_BIOPRJ          },
  {VG_PARET_GLBDCONVFACT  , MSG_BIODOCK_ERR_CONVFACT        },
  {VG_PARET_GLBDDUPCOM    , MSG_BIODOCK_ERR_DUPCOM          },
  {VG_PARET_GLBDFRMSELINV , MSG_BIODOCK_ERR_FRMSELINV       },
  {VG_PARET_GLBDFRMSELMIS , MSG_BIODOCK_ERR_FRMSELMIS       },
  {VG_PARET_GLBDMACROCLS  , MSG_BIODOCK_ERR_MACROCLOSED     },
  {VG_PARET_GLBDMACROFREQ , MSG_BIODOCK_ERR_MACROFREQ       },
  {VG_PARET_GLBDMACRONCLS , MSG_BIODOCK_ERR_MACRONOTCLOSED  },
  {VG_PARET_GLBDMACRONOPN , MSG_BIODOCK_ERR_MACRONOTOPENED  },
  {VG_PARET_GLBDMACROOPN  , MSG_BIODOCK_ERR_MACROOPENED     },
  {VG_PARET_GLBDMISCOM    , MSG_BIODOCK_ERR_MISCOM          },
  {VG_PARET_GLBDMODULE    , MSG_BIODOCK_ERR_MODULE          },
  {VG_PARET_GLBDNULLSTR   , MSG_BIODOCK_ERR_NULLSTR         },
  {VG_PARET_GLBDNUMBOOL   , MSG_BIODOCK_ERR_NUMBOOL         },
  {VG_PARET_GLBDNUMFLOAT  , MSG_BIODOCK_ERR_NUMFLOAT        },
  {VG_PARET_GLBDNUMFRM    , MSG_BIODOCK_ERR_NUMFRM          },
  {VG_PARET_GLBDNUMINT    , MSG_BIODOCK_ERR_NUMINT          },
  {VG_PARET_GLBDNUMNULL   , MSG_BIODOCK_ERR_NULLNUM         },
  {VG_PARET_GLBDNUMPOS    , MSG_BIODOCK_ERR_NUMPOS          },
  {VG_PARET_GLBDROTPOS    , MSG_BIODOCK_ERR_ROTPOS          },
  {VG_PARET_GLBSTRUCTOUT  , MSG_ERR_BIODOCK_STRUCTOUT       },
  {VG_PARET_GLBDTOOLINES  , MSG_BIODOCK_ERR_TOOLINES        },
  {VG_PARET_GLBDTRANSPOS  , MSG_BIODOCK_ERR_TRANSPOS        },
  {VG_PARET_GLBDUNKCOM    , MSG_BIODOCK_ERR_UNKCOM          },
  {VG_PARET_GLBDUNKEXTRA  , MSG_BIODOCK_ERR_UNKEXTRA        },
  {VG_PARET_GLBDUNKOPTMET , MSG_BIODOCK_ERR_UNKOPTMET       },
  {VG_PARET_GLBDUNTERMSTR , MSG_BIODOCK_ERR_UNTERMSTR       },

  /**** GL initialisation ****/

  {VG_PARET_GLINIACTCON   , MSG_ERR_GL_ACTCONTEXT           },
  {VG_PARET_GLINICONTEXT  , MSG_ERR_GL_CONTEXT              },
  {VG_PARET_GLINICRCONTXT , MSG_ERR_GL_CREATECONTEXT        },
  {VG_PARET_GLINIFAIL     , MSG_ERR_GL_FAIL                 },
  {VG_PARET_GLINIPXFORM1  , MSG_ERR_GL_PIXELFORM1           },
  {VG_PARET_GLINIPXFORM2  , MSG_ERR_GL_PIXELFORM2           },
  {VG_PARET_GLINIWNDCLASS , MSG_ERR_GL_WNDCLASS             },
  {VG_PARET_GLINIWNDCREAT , MSG_ERR_GL_WNDCREAT             },

  /**** GL generic ****/

  {VG_PARET_GLDEVIL       , MSG_ERR_DEVIL_PROMPT            },
  {VG_PARET_GLFMOD        , MSG_ERR_FMOD_PROMPT             },
  {VG_PARET_GLMENCANTEXE  , MSG_MENU_ERR_CANTEXE            },
  {VG_PARET_GLMENHELP     , MSG_MENU_ERR_HELP               },
  {VG_PARET_GLDEMONOTINST , MSG_GLDEMO_ERR_NOTINST          },

  /**** GL measure ****/

  {VG_PARET_GLMEASATMMULTI, MSG_GLMEAS_ERR_ATMMULTI         },
  {VG_PARET_GLMEASATMNFND , MSG_GLMEAS_ERR_ATMNOTFND        },

  /**** GL Mopac ****/

  {VG_PARET_GLMOPACNOARC  , MSG_ERR_DLGMOPAC_NOARC          },
  {VG_PARET_GLMOPACEXE    , MSG_ERR_DLGMOPAC_MOPACEXE       },
  {VG_PARET_GLMOPACTOOATM , MSG_ERR_DLGMOPAC_TOOATM         },

  /**** GL select ****/

  {VG_PARET_GLSELDONTMATCH, MSG_SEL_ERR_DONTMATCH           },
  {VG_PARET_GLSELILLNUMARG, MSG_SEL_ERR_ILLNUMARG           },
  {VG_PARET_GLSELUNKTAG   , MSG_SEL_ERR_UNKTAG              },

#endif

  {VG_PARET_FEWARGS       , MSG_ERR_COM_FEWARGS             },
  {VG_PARET_ILLARG        , MSG_ERR_COM_ILLARG              },

  /**** Input/Output ****/

  {VG_PARET_IOBZIP2       , MSG_ERR_BZIP2_ERROR             },
  {VG_PARET_IOCANTPACK    , MSG_ERR_MAIN_CANTPACK           },
  {VG_PARET_IODOS         , MSG_ERR_UTILS_DOSERR            },
  {VG_PARET_IOGZIP        , MSG_ERR_GZIP_ERROR              },
  {VG_PARET_IONOSTDOUT    , MSG_ERR_MAIN_NOSTDOUT           },
  {VG_PARET_IOPKSTDOUT    , MSG_ERR_MAIN_PKNOSTDOUT         },
  {VG_PARET_IOPOWERPK     , MSG_ERR_PKPP_ERROR              },
  {VG_PARET_IOPOWERPKCR   , MSG_ERR_PKPP_NOCRUNCH           },
  {VG_PARET_IOPOWERPKLIB  , MSG_ERR_PKPP_NOPPLIB            },
  {VG_PARET_IOPOWERPSHORT , MSG_ERR_PKPP_TOOSHORT           },
  {VG_PARET_IOUNKPACK     , MSG_ERR_MAIN_UNKPACKMET         },
  {VG_PARET_IOVEGADIR     , MSG_ERR_UTILS_VEGADIR           },
  {VG_PARET_IOZ32         , MSG_ERR_Z32_ERROR               },

#ifdef __VG_OPENGL

  /**** Merge ****/

  {VG_PARET_MERGEUNALLELEM, MSG_DLGMERGE_ERR_UNALLELEM      },
  {VG_PARET_MERGEUNCOMP   , MSG_DLGMERGE_ERR_UNCOMPMOL      },

#endif

  /**** Load and save operations ****/

  {VG_PARET_MOLBIOSNS     , MSG_ERR_BIOSYM_NOTSUPPORTED     },
  {VG_PARET_MOLCOMFAFL    , MSG_ERR_COMFA_FIELD             },
  {VG_PARET_MOLCOMFARG    , MSG_ERR_COMFA_RGN               },

  {VG_PARET_MOLCONBORD    , MSG_ERR_CONNECT_UNACCBD         },
  {VG_PARET_MOLCONVDW     , MSG_ERR_CONNECT_UNKVDW          },

  {VG_PARET_MOLCRDASS     , MSG_ERR_LOADER_CRDASSFILE       },
  {VG_PARET_MOLCRDMEAS    , MSG_ERR_LOADER_CRDMESURE        },

  {VG_PARET_MOLCSSR       , MSG_ERR_MAIN_CSSR               },
  {VG_PARET_MOLFASTA      , MSG_ERR_FASTA_NOPROT            },

  {VG_PARET_MOLIFFCORR    , MSG_ERR_IFF_CORRUPTED           },
  {VG_PARET_MOLIFFINV     , MSG_ERR_IFF_INVFILE             },
  {VG_PARET_MOLIFFNOT     , MSG_ERR_IFF_NOTIFF              },

  {VG_PARET_MOLMOL2CORR   , MSG_ERR_MOL2_CORRUPTED          },
  {VG_PARET_MOLMOL2NOTF   , MSG_ERR_MOL2_NOTFOUND           },
  {VG_PARET_MOLMOL2TEMP   , MSG_ERR_MOL2_ILLTEMP            },

  {VG_PARET_MOLMSFFORMAT  , MSG_ERR_MSF_NOTMSF              },
  {VG_PARET_MOLMSFNCOMP   , MSG_ERR_MSF_NOTCOMP             },

  {VG_PARET_MOLMOPACATOM  , MSG_ERR_MOPAC_ATMFAULT          },
  {VG_PARET_MOLMOPACBADCON, MSG_ERR_MOPAC_BADCONV           },
  {VG_PARET_MOLNOCHARGE   , MSG_ERR_MAIN_NOCHARGE           },
  {VG_PARET_MOLNOFFTAG    , MSG_ERR_MAIN_NOFFTAG            },
  {VG_PARET_MOLNOTFOUND   , MSG_ERR_LOADER_NOTFOUND         },

  {VG_PARET_MOLRGNCORRUPT , MSG_ERR_SYBRGN_CORRUPTED        },
  {VG_PARET_MOLRGNNOMOL   , MSG_ERR_MAIN_RGNNOMOL           },
  {VG_PARET_MOLRGNNUMSTPS , MSG_ERR_SYBRGN_NUMSTPS          },
  {VG_PARET_MOLRGNPOINTS  , MSG_ERR_SYBRGN_POINTS           },
  {VG_PARET_MOLRGNSTPSIZE , MSG_ERR_SYBRGN_STPSIZE          },
  {VG_PARET_MOLUNKINFOR   , MSG_ERR_LOADER_UNKFORMAT        },
  {VG_PARET_MOLUNKOUTFOR  , MSG_ERR_MAIN_UNKOUTFOR          },
  {VG_PARET_SRFNOMOL      , MSG_ERR_SRFNOMOL                },

  /**** Command line options ****/

  {VG_PARET_OPTCHGTEMP    , MSG_ERR_MAIN_CHGFILENOTFOUND    },
  {VG_PARET_OPTCOLUNK     , MSG_ERR_COM_COLUNK              },
  {VG_PARET_OPTFILEMISS   , MSG_ERR_MAIN_FILEMISS           },
  {VG_PARET_OPTFLOATNUM   , MSG_ERR_MAIN_FLOATNUM           },
  {VG_PARET_OPTILLDIEL    , MSG_ERR_MAIN_ILLDIEL            },
  {VG_PARET_OPTILLPRORAD  , MSG_ERR_MAIN_ILLPROBERAD        },
  {VG_PARET_OPTILLRESNAM  , MSG_ERR_MAIN_ILLRESNAME         },
  {VG_PARET_OPTILLSASDEN  , MSG_ERR_MAIN_ILLSASDEN          },
  {VG_PARET_OPTILLSOLRAD  , MSG_ERR_MAIN_ILLSOLRAD          },
  {VG_PARET_OPTILLSTRRES  , MSG_ERR_MAIN_ILLSTRRES          },
  {VG_PARET_OPTINTNUM     , MSG_ERR_MAIN_INTNUM             },
  {VG_PARET_OPTOGLPORT    , MSG_ERR_MAIN_INVALIDPORT        },
  {VG_PARET_OPTOGLRUN     , MSG_ERR_GL_RUNNING              },
  {VG_PARET_OPTSUBARG     , MSG_ERR_MAIN_SUBARG             },
  {VG_PARET_OPTUNK        , MSG_ERR_MAIN_UNKOPT             },
  {VG_PARET_OPTUNKSHELL   , MSG_ERR_MAIN_SHELLFILE          },
  {VG_PARET_OPTUNKSHAPE   , MSG_ERR_MAIN_UNKSHAPE           },
  {VG_PARET_OPTUNSCHGTMP  , MSG_ERR_MAIN_UNSUPCHGTEMP       },
  {VG_PARET_OPTWIN32      , MSG_ERR_MAIN_WIN32ONLY          },

  /**** Plots ****/

  {VG_PARET_PLOTSAVER     , MSG_ERR_SAVER_PLOT              },
  {VG_PARET_PLOTPOINTRANGE, MSG_ERR_GRAPH_POINTRANGE        },

  /**** Solvatation ****/

  {VG_PARET_SOLCANTOPEN   , MSG_ERR_SOLVATE_CANTOPEN        },
  {VG_PARET_SOLSHELLDIM   , MSG_ERR_SOLVATE_SHELLDIM        },
  {VG_PARET_SOLNOTHING    , MSG_ERR_SOLVATE_NOTHING         },

  {VG_PARET_ABORT         , MSG_ERR_MAIN_ABORT              },
  {VG_PARET_NOCOM         , MSG_ERR_COM_NOCOM               },
  {VG_PARET_NOMOL         , MSG_ERR_COM_NOMOL               },
  {VG_PARET_NOSRF         , MSG_ERR_COM_NOSRF               },
  {VG_PARET_NOTIMP        , MSG_ERR_COM_NOTIMP              },
  {VG_PARET_OGLONLY       , MSG_ERR_LODER_OPENGLONLY        },
  {VG_PARET_OGLONLY       , MSG_MAIN_ERR_OPENGL             },
  {VG_PARET_OUTOFMEM      , MSG_ERR_UTILS_OUTOFMEM          },
  {VG_PARET_TOOARGS       , MSG_ERR_COM_TOOARGS             },
  {VG_PARET_UNKCOM        , MSG_ERR_COM_UNKCOM              },
  {VG_PARET_UNKKEYWORD    , MSG_ERR_COM_UNKKEYWORD          },

#ifdef WIN32

  /**** Windows errors ****/

  {VG_PARET_WINDOWSFADDR  , MSG_ERR_WIN_CANTGETADDR         },
  {VG_PARET_WINDOWSDLL    , MSG_ERR_WIN_CANTLOADLIB         },
  {VG_PARET_WINDOWSMCI    , MSG_GLDEMO_ERR_MCI              },

#endif

  {VG_PARET_UNKERR        , MSG_ERR_COM_UNKERR              }
};
#else
extern const struct _ErrTab ErrTab[];
#endif

#endif

