
/*************************************************
****    VEGA - Connectivity Generator V1.2    ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


/* Element, mass, covalent radius and Van Der Waals radius */

#ifndef __CONNECT
#define  __CONNECT
const ATMTAB AtmTable[]        = {{{"H" },   1, 1.008, 0.37, 1.20},
                                  {{"C" },   6, 12.01, 0.77, 1.70},
                                  {{"N" },   7, 14.01, 0.75, 1.55},
                                  {{"O" },   8, 16.00, 0.73, 1.52},
                                  {{"S" },  16, 32.06, 1.02, 1.80},
                                  {{"P" },  15, 30.97, 1.10, 1.80},
                                  {{"F" },   9, 19.00, 0.71, 1.47},
                                  {{"Cl"},  17, 35.45, 0.99, 1.75},
                                  {{"Br"},  35, 79.90, 1.14, 1.85},
                                  {{"I" },  53, 126.9, 1.33, 1.98},

                                  {{"He"},   2, 4.003, 0.50, 1.80},
                                  {{"Li"},   3, 6.941, 1.34, 1.80},
                                  {{"Be"},   4, 9.012, 1.25, 1.82},
                                  {{"B" },   5, 10.81, 0.90, 1.98},
                                  {{"Ne"},  10, 20.18, 0.65, 1.55},
                                  {{"Na"},  11, 22.99, 1.54, 2.30},
                                  {{"Mg"},  12, 24.31, 1.45, 1.70},
                                  {{"Al"},  13, 26.98, 1.30, 1.74},
                                  {{"Si"},  14, 28.09, 1.18, 2.10},
                                  {{"Ar"},  18, 39.95, 0.95, 1.90},
                                  {{"K" },  19, 39.10, 1.96, 2.80},
                                  {{"Ca"},  20, 40.08, 1.74, 1.94},
                                  {{"Sc"},  21, 44.96, 1.44, 1.82},
                                  {{"Ti"},  22, 47.90, 1.32, 2.25},
                                  {{"V" },  23, 50.94, 1.25, 2.18},
                                  {{"Cr"},  24, 52.00, 1.27, 2.11},
                                  {{"Mn"},  25, 54.94, 1.43, 2.03},
                                  {{"Fe"},  26, 55.85, 1.22, 1.22},
                                  {{"Co"},  27, 58.93, 1.26, 1.26},
                                  {{"Ni"},  28, 58.71, 1.20, 1.61},
                                  {{"Cu"},  29, 63.55, 1.38, 1.41},
                                  {{"Zn"},  30, 65.37, 1.25, 1.40},
                                  {{"Ga"},  31, 69.72, 1.25, 1.26},
                                  {{"Ge"},  32, 72.60, 1.22, 1.22},
                                  {{"As"},  33, 74.92, 1.21, 1.20},
                                  {{"Se"},  34, 78.96, 1.17, 1.16},
                                  {{"Kr"},  36, 83.80, 1.11, 1.12},
                                  {{"Rb"},  37, 85.47, 2.16, 2.16},
                                  {{"Sr"},  38, 87.62, 1.91},
                                  {{"Y" },  39, 88.91, 1.62},
                                  {{"Zr"},  40, 91.22, 1.45},
                                  {{"Nb"},  41, 92.91, 1.34},
                                  {{"Mo"},  42, 95.94, 1.30},
                                  {{"Tc"},  43, 99.00, 1.27},
                                  {{"Ru"},  44, 101.1, 1.25},
                                  {{"Rh"},  45, 102.9, 1.25},
                                  {{"Pd"},  46, 106.4, 1.28},
                                  {{"Ag"},  47, 107.9, 1.34},
                                  {{"Cd"},  48, 112.4, 1.41},
                                  {{"In"},  49, 114.8, 1.50},
                                  {{"Sn"},  50, 118.7, 1.40},
                                  {{"Sb"},  51, 121.8, 1.39},
                                  {{"Te"},  52, 127.6, 1.37},
                                  {{"Xe"},  54, 131.3, 1.30},
                                  {{"Cs"},  55, 132.9, 2.35},
                                  {{"Ba"},  56, 137.3, 1.98},
                                  {{"La"},  57, 138.9, 1.69},
                                  {{"Ce"},  58, 140.1, 1.65},
                                  {{"Pr"},  59, 140.9, 1.65},
                                  {{"Nd"},  60, 144.2, 1.64},
                                  {{"Pm"},  61, 147.0, 1.63},
                                  {{"Sm"},  62, 150.4, 1.62},
                                  {{"Eu"},  63, 152.0, 1.85},
                                  {{"Gd"},  64, 157.3, 1.61},
                                  {{"Tb"},  65, 158.9, 1.59},
                                  {{"Dy"},  66, 162.5, 1.59},
                                  {{"Ho"},  67, 164.9, 1.58},
                                  {{"Er"},  68, 167.3, 1.57},
                                  {{"Tm"},  69, 168.9, 1.56},
                                  {{"Yb"},  70, 173.0, 1.56},
                                  {{"Lu"},  71, 175.0, 1.56},
                                  {{"Hf"},  72, 178.5, 1.44},
                                  {{"Ta"},  73, 180.9, 1.34},
                                  {{"W" },  74, 183.9, 1.30},
                                  {{"Re"},  75, 186.2, 1.28},
                                  {{"Os"},  76, 190.2, 1.26},
                                  {{"Ir"},  77, 192.2, 1.27},
                                  {{"Pt"},  78, 195.1, 1.30},
                                  {{"Au"},  79, 197.0, 1.34},
                                  {{"Hg"},  80, 200.6, 1.44},
                                  {{"Tl"},  81, 204.4, 1.55},
                                  {{"Pb"},  82, 207.2, 1.54},
                                  {{"Bi"},  83, 209.0, 1.51},
                                  {{"Po"},  84, 210.0, 1.46},
                                  {{"At"},  85, 210.0, 1.45},
                                  {{"Rn"},  86, 222.0, 1.45},
                                  {{"Fr"},  87, 223.0, 1.00},
                                  {{"Ra"},  88, 226.0, 1.00},
                                  {{"Ac"},  89, 227.0, 1.00},
                                  {{"Th"},  90, 232.0, 1.00},
                                  {{"Pa"},  91, 231.0, 1.00},
                                  {{"U" },  92, 238.0, 1.00},
                                  {{"Np"},  93, 237.0, 1.00},
                                  {{"Pu"},  94, 242.0, 1.00},
                                  {{"Am"},  95, 243.0, 1.00},
                                  {{"Cm"},  96, 248.0, 1.00},
                                  {{"Bk"},  97, 247.0, 1.00},
                                  {{"Cf"},  98, 251.0, 1.00},
                                  {{"Es"},  99, 254.0, 1.00},
                                  {{"Fm"}, 100, 253.0, 1.00},
                                  {{"Md"}, 101, 256.0, 1.00},
                                  {{"No"}, 102, 254.0, 1.00},
                                  {{"Lw"}, 103, 257.0, 1.00},
                                  {{"Rf"}, 104, 261.0, 1.00},
                                  {{"Dd"}, 105, 262.0, 1.00},
                                  {{"Sg"}, 106, 266.0, 1.00},
                                  {{"Bh"}, 107, 264.0, 1.00},
                                  {{"Hs"}, 108, 269.0, 1.00},
                                  {{"Mt"}, 109, 268.0, 1.00},

                                  {{"Du"}, 200, 12.01, 0.77, 1.94},
                                  {{"Lp"}, 201,  0.00, 0.00, 0.00},
                                  {{"Xc"}, 202,  0.00, 0.00, 0.00},

                                  {{0, 0},   0,  0.00, 0.00, 0.00}
                                 };

/**** Aminoacidic residue names ****/

const VG_QCHAR AAResTab[]      = { {"ALA" }, {"ARG" }, {"ASN" }, {"ASP" }, {"CYS" },
                                   {"GLU" }, {"GLN" }, {"GLY" }, {"HIS" }, {"ILE" },
                                   {"LEU" }, {"LYS" }, {"MET" }, {"PHE" }, {"PRO" },
                                   {"SER" }, {"THR" }, {"TRP" }, {"TYR" }, {"VAL" },
                                   {"ARG+"}, {"LYS+"}, {"ASP-"}, {"GLU-"}, {"CYH" },
                                   {"HI+" }, {""    }
                                 };

const VG_QCHAR AAEquivTab[]    = { {"AP-"} , {"ASP"},
                                   {"AP-C"}, {"ASP"},
                                   {"AP-N"}, {"ASP"},
                                   {"ASP-"}, {"ASP"},
                                   {"GL-"} , {"GLU"},
                                   {"GL-C"}, {"GLU"},
                                   {"GL-N"}, {"GLU"},
                                   {"GLU-"}, {"GLU"},
                                   {"AR+"} , {"ARG"},
                                   {"AR+C"}, {"ARG"},
                                   {"AR+N"}, {"ARG"},
                                   {"ARG+"}, {"ARG"},
                                   {"LY+"} , {"LYS"},
                                   {"LY+C"}, {"LYS"},
                                   {"LY+N"}, {"LYS"},
                                   {"LYS+"}, {"LYS"},
                                   {"CYH"} , {"CYS"},
                                   {"HI+"} , {"HIS"},
                                   {"HI+C"}, {"HIS"},
                                   {"HI+N"}, {"HIS"},
                                   {"HIS+"}, {"HIS"},
                                   {""   } , {""   }
                                 };

const char AATab[]          =    "ARNDCEQGHILKMFPSTWYVRKDECH";
#endif

