
/*************************************************
****    VEGA - BMP file loader for OpenGL     ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <malloc.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "gl_bmpload.h"


/**** Get an integer ****/

static VG_BOOL GetInt(VG_ULONG *Dest, FILE *FH)
{
  if (fread(Dest, sizeof(VG_ULONG), 1, FH) != 1)
    return PrintDosErr();

#ifndef LITTLE_ENDIAN
  Swap(Dest);
#endif

  return TRUE;
}


/**** Get a short ****/

static VG_UWORD GetShort(VG_UWORD *Dest, FILE *FH)
{
  if (fread(Dest, sizeof(VG_UWORD), 1, FH) != 1)
    return PrintDosErr();

#ifndef LITTLE_ENDIAN
  SwapW(Dest);
#endif

  return TRUE;
}


/**** Free the image ****/

void GL_BmpFree(VG_IMAGE **Image)
{
  if (*Image) {
    if ((*Image) -> data) FREE((*Image) -> data);
    FREE(Image);
    *Image = NULL;
  }
}


/**** BMP loader (24 bit, 1 plane) ****/

VG_IMAGE *GL_BmpLoad(char *filename)
{
  FILE          *file;
  VG_IMAGE      *image;
  VG_ULONG      size;                   /*  size of the image in bytes. */
  VG_ULONG      i;                      /*  standard counter. */
  VG_UWORD      planes;                 /*  number of planes in image (must be 1)  */
  VG_UWORD      bpp;                    /*  number of bits per pixel (must be 24) */
  VG_UBYTE      temp;                   /*  used to convert bgr to rgb color. */

  VG_BOOL       Ret    = FALSE;


  if ((image = (VG_IMAGE *)Alloca(sizeof(VG_IMAGE))) != NULL) {
    if ((file = fopen(filename, "rb")) != NULL) {
      fseek(file, 18, SEEK_CUR);

      if ((GetInt(&image -> sizeX, file)) &&
          (GetInt(&image -> sizeY, file)) &&
          (GetShort(&planes, file)) &&
          (GetShort(&bpp, file))) {

        /**** Calculate the size (assuming 24 bits or 3 bytes per pixel) ****/

        size = image -> sizeX * image -> sizeY * 3;

        /**** Read the planes & bpp ****/

        if ((planes == 1) && (bpp == 24)) {

          fseek(file, 24, SEEK_CUR);

          /**** Read the data ****/

          if ((image -> data = (VG_UBYTE *)Alloca(size)) != NULL) {
            if ((i = fread(image -> data, size, 1, file)) == 1) {

              /**** Reverse all of the colors (bgr -> rgb) ****/

              for(i = 0; i < size; i += 3) {
                temp               = image -> data[i];
                image -> data[i]   = image -> data[i + 2];
                image -> data[i+2] = temp;
              } /* End of for */
              Ret = TRUE;
            } else PrintDosErr();
          }
        }
      }
      fclose(file);
    } else PrintDosErr();
  }

  if (!Ret) GL_BmpFree(&image);

  return image;
}

