
/*************************************************
****            VEGA - OpenGL Fonts           ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifdef __WIN32__
#  include <windows.h>
#endif

#include <GL\gl.h>
#include <GL\glu.h>
#include <stdio.h>
#include <stdarg.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "globdef.h"
#include "globvar.h"
#include "gl_global.h"

/**** Local variables ****/

static GLuint	base;

/**** Local prototypes ****/

static int GL_ItoA(char *, int);


/**** Build bitmap fonts ****/

VG_BOOL GL_BuildFont(int Height, int Width)
{
  HFONT         font;

//  base = glGenLists(96);		            // Storage For 96 Characters
  base = glGenLists(224);
  if (font = CreateFont( Height,		    // Height Of Font
                         Width,			    // Width Of Font
               	         0,			    // Angle Of Escapement
		         0,			    // Orientation Angle
		         FW_DONTCARE,     	    // Font Weight
		         FALSE,			    // Italic
		         FALSE,			    // Underline
		         FALSE,			    // Strikeout
		         ANSI_CHARSET,		    // Character Set Identifier
		         OUT_TT_PRECIS,		    // Output Precision
		         CLIP_DEFAULT_PRECIS,	    // Clipping Precision
//		         ANTIALIASED_QUALITY,	    // Output Quality
		         NONANTIALIASED_QUALITY,    // Output Quality
		         FF_DONTCARE|DEFAULT_PITCH, // Family And Pitch
		         "Arial")) {

    SelectObject(hDC, font);			    // Selects The Font We Want

//    wglUseFontBitmaps(hDC, 32, 96, base);	    // Builds 96 Characters Starting At Character 32
    wglUseFontBitmaps(hDC, 32, 224, base);
    return TRUE;
  }

  return FALSE;
}


/**** Convert an integer into a string ****/

static int GL_ItoA(char *dst, int val)
{
  char                  buffer[36];
  register char         *p;
  int                   new_val;


  p  = &buffer[sizeof(buffer) - 1];
  *p = '\0';
  new_val = val / 10;
  *--p = '0'+ (char) (val - new_val * 10);
  val = new_val;

  while (val != 0) {
    new_val = val/10;
    *--p = '0' + (char) (val-new_val*10);
    val= new_val;
  }

  new_val = 0;
  while ((*dst++ = *p++) != 0) ++new_val;

  return new_val;
}


/**** Delete the font ****/

void GL_KillFont(void)
{
//  glDeleteLists(base, 96);
  glDeleteLists(base, 224);
}


/**** Generic print routine ****/

void GL_Print(const char *fmt, ...)
{
  char		text[256];
  va_list  	ap;

  if (fmt) {
    va_start(ap, fmt);
    vsprintf(text, fmt, ap);
    va_end(ap);

    glPushAttrib(GL_LIST_BIT);				// Pushes The Display List Bits
//    glListBase(base - 32);				// Sets The Base Character to 32
    glListBase(base - 32);
    glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
    glPopAttrib();					// Pops The Display List Bits
  }
}


/**** Print a DCHAR string ****/

void GL_PrintDchar(VG_DCHAR Str)
{
  VG_LONG       Len;

  if (Str.C[0]) {
    if (Str.C[1]) {
      Len = 2;
    } else Len = 1;
  } else Len = 0;

  glPushAttrib(GL_LIST_BIT);
  glListBase(base - 32);
  glCallLists(Len, GL_UNSIGNED_BYTE, Str.C);
  glPopAttrib();
}


/**** Print an int ****/

void GL_PrintInt(int Num)
{
  char          Str[36];
  VG_LONG       Len;

  Len = GL_ItoA(Str, Num);
  glPushAttrib(GL_LIST_BIT);
  glListBase(base - 32);
  glCallLists(Len, GL_UNSIGNED_BYTE, Str);
  glPopAttrib();
}


/**** Print a QCHAR string ****/

void GL_PrintQchar(VG_QCHAR Str)
{
  VG_LONG       Len;

  if (Str.C[0]) {
    if (Str.C[1]) {
      if (Str.C[2]) {
        if (Str.C[3]) {
          Len = 4;
        } else Len = 3;
      } else Len = 2;
    } else Len = 1;
  } else Len = 0;

  glPushAttrib(GL_LIST_BIT);
  glListBase(base - 32);
  glCallLists(Len, GL_UNSIGNED_BYTE, Str.C);
  glPopAttrib();
}




