
/*************************************************
****       VEGA - Subroutines for OpenGL      ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <ctype.h>

#ifdef __WIN32__
#  include <windows.h>
#endif

#include <GL\gl.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"
#include "bond.h"
#include "formats.h"
#include "surface.h"

#include "gl_global.h"
#include "gl_sub.h"


/**** Invert Z coordinates ****/

void InvertZCoord(register ATOMO *Atm)
{
  SrfClose();

  while(Atm) {
    if (Atm -> Active) Atm -> z *= -1;
    Atm = Atm -> Ptr;
  } /* End of while */
}


/**** Remove in/visible atoms ****/

VG_ULONG RemoveVisAtm(VG_UBYTE Active)
{
  ATOMO                 *Atm, *PrecAtm;
  VG_UBYTE              i;

  VG_ULONG              Count    = 1;
  VG_ULONG              Removed  = 0;

  Atm = PrecAtm = BegAtm;
  while(Atm) {
    if (Atm -> Active == Active) {
      for(i = 0; i < Atm -> NSost; ++i)
        BndUnlink(Atm -> Conn[i], Atm);
      --TotalAtm;
      RemoveAtm(&Atm, &PrecAtm, &BegAtm);
      ++Removed;
    } else {
      PrecAtm    = Atm;
      Atm -> Num = Count++;
      Atm        = Atm -> Ptr;
    }
  } /* End of while */

  if (!BegAtm) MC_New(TRUE);

  return Removed;
}


/**** Find the segments ****/

VG_ULONG SegFind(ATOMO *InizAtm, VG_LONG Flag)
{
  ATOMO        *Atm;

  VG_ULONG     Segs     = 1;
  ATOMO        *PrecAtm = InizAtm;
  VG_BYTE      ChainID  = InizAtm -> ChainID;

  /**** Use the chain strategy ****/

  for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
    if (Atm -> Active) {
      Atm -> Flags = Atm -> Flags &~ Flag;
      if (Atm -> ChainID != ChainID) {
        PrecAtm -> Flags |= Flag;
        ChainID = Atm -> ChainID;
        ++Segs;
      }
    }
    PrecAtm = Atm;
  } /* End of for */

  /**** Use the residue number strategy ****/

  if (Segs == 1) {
    PrecAtm = InizAtm;
    for(Atm = InizAtm; Atm; Atm = Atm -> Ptr) {
      if ((Atm -> Active) &&
          (PrecAtm -> ResSeq.L < PrecAtm -> ResSeq.L)) {
        PrecAtm -> Flags |= Flag;
        ++Segs;
      }
      PrecAtm = Atm;
    } /* End of for */
  }

  return Segs;
}


/**** Fix the segments ****/

void SegFix(ATOMO *InizAtm, VG_LONG Flag)
{
  VG_ULONG      k = SegFind(InizAtm, Flag);

  if (Flag == VG_ATMF_SEGEND) {
    if (k > 1)
      CatPrintf(stdout, MSG_SEG_FOUND, k);
    else
      CatPrintf(stdout, MSG_SEG_NOTFOUND);
  } else {
    if (k > 1)
      CatPrintf(stdout, MSG_MOL_FOUND, k);
    else
      CatPrintf(stdout, MSG_MOL_NOTFOUND);
  }
}


/**** Merge the segments ****/

VG_ULONG SegMerge(register ATOMO *Atm, VG_LONG Flag)
{
  VG_ULONG      Count = 1;

  while(Atm) {
    if (((Atm -> Active) && (Atm != LastAtm)) &&
        (Atm -> Flags & Flag)) {
      Atm -> Flags = Atm -> Flags &~ Flag;
      ++Count;
    }
   Atm = Atm -> Ptr;
  } /* End of while */

  return Count;
}
