
/*************************************************
****       VEGA - Hybridization template      ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/

/*
 * Load the hybridization template and check if an atom respects the
 * canonical geometries. See "addhyd.c"
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "globdef.h"
#include "globvar.h"
#include "globstr.h"

#include "hybtem.h"


/**** Check the atom in the template ****/

VG_WORD HybTemAtmCheck(register ATOMO *Atm, VG_LIST *InizTem,
                        register VG_OCHAR *CorPot)
{
  register VG_HYBPOT            *Tem;

  for(Tem = (VG_HYBPOT *)InizTem -> Beg; Tem; Tem = Tem -> Next) {
    if (((Tem -> ResName.L == Atm -> ResName.L) ||
         (Tem -> ResName.L == VG_ADDH_ASTQ)) &&
        (Tem -> Name.L == Atm -> Name.L)) {
      if (Tem -> Pot.DL != Atm -> Pot.DL) {
        (*CorPot).DL = Tem -> Pot.DL;
        if (!(Tem -> Flags & VG_HYB_FLGPOT_CONTINUE))
          return Tem -> Warn;
      } return 0;
    }
  } /* End of for */

  return 0;
}


/**** Load the hybridization template ****/

VG_LIST *HybTemLoad(char *FileName)
{
  char          Buf[256], *Ptr;
  FILE          *FH;
  VG_HYBPOT     *Pot;
  VG_LONG       TmpI;

  const char    *Sep     =  " \t\012\015";
  VG_BOOL       Ret      = TRUE;
  VG_LIST       *InizTem = 0;
  VG_ULONG      Line     = 1;

  if ((FH = fopen(FileName, "r")) != NULL) {
    if ((InizTem = ListNew(sizeof(VG_HYBPOT))) != NULL) {
      while((Ret) && (fgets(Buf, 255, FH))) {
        if (((Ptr = strtok(Buf, Sep)) != NULL) && (*Ptr)) {
          if (Line == 1) {
            if (strncasecmp(Ptr, "#TemplateHyb", 12)) {
              Ret = CatErr(MSG_ERR_HYB_UNKFORMAT);
              break;
            } else continue;
          } else if (*Ptr != ';') {

            /**** Residue name ****/

            if (strlen(Ptr) <= sizeof(VG_QCHAR)) {
              if ((Pot = (VG_HYBPOT *)ListAppend(InizTem)) != NULL) {
                Str2Qchar(&Pot -> ResName, Ptr);

                /**** Atom name ****/

                if ((Ptr = strtok(NULL, Sep)) != NULL) {
                  if (strlen(Ptr) <= sizeof(VG_QCHAR)) {
                    Str2Qchar(&Pot -> Name, Ptr);

                    /**** Warning code ****/

                    if ((Ptr = strtok(NULL, Sep)) != NULL) {
                      TmpI = atoi(Ptr);
                      if (TmpI >= 0) {
                        Pot -> Warn = (VG_WORD)TmpI;

                        /**** First atom type ****/

                        if ((Ptr = strtok(NULL, Sep)) != NULL) {
                          if (strlen(Ptr) <= sizeof(VG_OCHAR)) {
                            Str2Ochar(&Pot -> Pot, Ptr);
                          } else Ret = CatErr(MSG_ERR_HYB_ATMTYPTOOLONG, Line);
                        } else Ret = CatErr(MSG_ERR_HYB_ATMTYPMIS, Line);

                        /**** Other atom types ****/

                        while((Ptr = strtok(NULL, Sep)) != NULL) {
                          if (strlen(Ptr) <= sizeof(VG_OCHAR)) {
                            Pot -> Flags |= VG_HYB_FLGPOT_CONTINUE;
                            if ((Pot = (VG_HYBPOT *)ListAppend(InizTem)) != NULL) {
                              Pot -> ResName.L = Pot -> Prev -> ResName.L;
                              Pot -> Name.L    = Pot -> Prev -> Name.L;
                              Str2Ochar(&Pot -> Pot, Ptr);
                            } else Ret = FALSE;
                          } else Ret = CatErr(MSG_ERR_HYB_ATMTYPTOOLONG, Line);
                        } /* End of while */
                      } else Ret = CatErr(MSG_ERR_HYB_ATMNAMETOOLONG, Line);
                    } else Ret = CatErr(MSG_ERR_HYB_ATMNAMEMIS, Line);
                  } else Ret = CatErr(MSG_ERR_HYB_WARNCODEILL, Line);
                } else Ret = CatErr(MSG_ERR_HYB_WARNCODEMIS, Line);
              } else Ret = FALSE;
            } else Ret = CatErr(MSG_ERR_HYB_RESNAMETOOLONG, Line);
          }
        }
        ++Line;
      } /* End of while */
    }
    if (!Ret) {
      ListClear(InizTem);
      InizTem = NULL;
    }
    fclose(FH);
  } else PrintDosErr();

  return InizTem;
}
