
/*************************************************
****      VEGA - MDL Mol loader & saver       ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "count.h"
#include "bond.h"


/**** MDL Mol Loader ****/

ATOMO *MdlMolLoad(FILE *IN, RECORD *Lin, VG_ULONG *TotAtomi)
{
  ATOMO                 **ConMtx;
  VG_ULONG              i, j;

  ATOMO                 *Atm     = NULL;
  ATOMO                 *InizAtm = NULL;
  VG_ULONG              k        = 0;
  VG_ULONG              NumAtoms = 0;
  VG_ULONG              NumBonds = 0;

  sscanf(Lin -> Line, "%3d %3d", &NumAtoms, &NumBonds);
  if (!NumAtoms) return NULL;

  /**** Atoms ****/

  k = NumAtoms;
  while((k--) && (fgets(Lin -> Line, VG_LINELEN, IN))) {
    if ((Atm = AllocAtm(&InizAtm, TotAtomi))) {
      sscanf(Lin -> Line, "%9f %9f %9f %3s",
             &Atm -> x, &Atm -> y, &Atm -> z, Atm -> Name.C);
      Atm -> Elem.C[0] = Atm -> Name.C[0];
      Atm -> Elem.C[1] = Atm -> Name.C[1];
    } else break;
  } /* End of while */

  if (Atm) {
    Atm -> Flags |= VG_ATMF_MOLEND|VG_ATMF_SEGEND;
    LastAtm       = Atm;

    /**** Bonds ****/

    if ((NumBonds) && ((ConMtx = AllocAtmTable(InizAtm, NumAtoms, TRUE)) != NULL)) {
      while((NumBonds--) && (fgets(Lin -> Line, VG_LINELEN, IN))) {
        i = j = k = 0;
        sscanf(Lin -> Line, "%d %d %d", &i, &j, &k);
        if ((i > 0) && (i <= NumAtoms) && (j > 0) && (j <= NumAtoms)) {
          if ((!k) || (k > 4)) {
            if (k == 7) k = VG_BOND_DOUBLE;
            else k = VG_BOND_SINGLE;
          }
          BndMake(ConMtx[--i], ConMtx[--j], k);
          GLOBSW_CONNCALC = FALSE;
        }
      } /* End of while */
      FREE(ConMtx);
    }
  }

  return InizAtm;
}


/**** MDL Mol saver ****/

VG_BOOL MdlMolSave(FILE *OUT, ATOMO *InizAtm, VG_ULONG TotAtm, char *FileName,
                   char *Ldem, VG_BOOL Dbase)
{
  ATOMO         *Atm;
  char          Bond, *Name, *Ptr;
  VG_UWORD	k;

  VG_BOOL       Ret    = TRUE;

  if (!Ldem) Ldem = "\n";
  if (fprintf(OUT, "%s%s" \
                   "VEGA%s" \
                   "%s" \
                   "%3d%3d  0  0  0  0  0  0  0  0  1 V2000%s",
                   GetFileName(FileName), Ldem,
                   Ldem,
                   Ldem,
                   TotAtm, CountBond(InizAtm), Ldem) > 0) {
    for(Atm = InizAtm; (Ret) && (Atm); Atm = Atm -> Ptr) {
      if (fprintf(OUT, "%10.4f%10.4f%10.4f %-3.2s 0  0  0  0  0  0  0  0  0  0  0  0%s",
                       Atm -> x, Atm -> y, Atm -> z, Atm -> Elem.C, Ldem) <= 0) {
        Ret = PrintDosErr();
      }
    } /* End of for */

    /**** Bonds ****/

    if ((Ret) && ((Ret = BndAssignTypes(InizAtm, TotAtm, FALSE)))) {
      for(Atm = InizAtm; (Atm) && (Ret); Atm = Atm -> Ptr) {
        for(k = 0; (Ret) && (k < Atm -> NSost); ++k) {
          if (Atm -> Conn[k] -> Num > Atm -> Num) {
            if (Atm -> Order[k] <= VG_BOND_PARDOUBLE) Bond = Atm -> Order[k] + '0';
            else Bond = '1';
            if (fprintf(OUT, "%3d%3d  %c  0  0  0  0%s",
                        Atm -> Num, Atm -> Conn[k] -> Num, Bond, Ldem) <= 0)
              Ret = PrintDosErr();
          }
        } /* End of for */
      } /* End of for */

      if ((Ret) && (fprintf(OUT, "M  END%s", Ldem) > 0)) {
        if ((Dbase) && (fprintf(OUT, "$$$$%s", Ldem) <= 0))
          Ret = PrintDosErr();
      } else Ret = PrintDosErr();
    }
  } else Ret = PrintDosErr();

  return Ret;
}

