
/*************************************************
****            VEGA - Mol2 header            ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __MOL2
#  define  __MOL2

#  ifndef __VG_TYPES
#    include "vgtypes.h"
#  endif

/**** Constants ****/

#define  VG_TRIPOS_TAG_ATOM             0
#define  VG_TRIPOS_TAG_BOND             1
#define  VG_TRIPOS_TAG_MOLECULE         2
#define  VG_TRIPOS_TAG_SUBSTR           3
#define  VG_TRIPOS_TAG_UNK              4

#define  VG_TRIPOS_FIELDLEN             256
#define  VG_TRIPOS_TEMPLATE             "TRIPOS.tem"

#ifdef LITTLE_ENDIAN
#  define  VG_TRIPOS_ATM_CA             0x00004143
#  define  VG_TRIPOS_FF_C2              MakeInt64(0x0000000000322e43)
#  define  VG_TRIPOS_FF_Nam             MakeInt64(0x000000006d612e4e)
#  define  VG_TRIPOS_FF_Oco2            MakeInt64(0x000000326f632e4f)
#else
#  define  VG_TRIPOS_ATM_CA             0x43410000
#  define  VG_TRIPOS_FF_C2              MakeInt64(0x432e320000000000)
#  define  VG_TRIPOS_FF_Nam             MakeInt64(0x4e2e616d00000000)
#  define  VG_TRIPOS_FF_Oco2            MakeInt64(0x4f2e636f32000000)
#endif

/**** Types ****/

typedef struct _VgMol2Sub {
  struct _VgMol2Sub     *Ptr;           /* Pointer to the next list element   */
  struct _VgMol2Sub     *ConnSub;       /* Pointer to connected substructures */
  VG_ULONG              SubNum;         /* Progressive number                 */
  VG_ULONG              ConnSubNum;     /* Number of connected substructures  */
  VG_QCHAR              ResName;        /* Residue name                       */
  VG_QCHAR              ResSeq;         /* Residue number                     */
  VG_ULONG              AtmNum;         /* Number of the most important atom  */
  VG_BYTE               ChainID;        /* Chain identificator                */
} VG_MOL2SUB;

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_BOOL     AssignTriposFF(ATOMO *, VG_ULONG);
VG_BOOL     Mol2ChkConnSub(VG_MOL2SUB *, ATOMO *);
VG_MOL2SUB *Mol2FindSub(ATOMO *, VG_ULONG *);
void        Mol2FreeSub(VG_MOL2SUB *);
VG_MOL2SUB *Mol2GetSub(VG_MOL2SUB *, ATOMO *);

#  ifdef __cplusplus
}
#  endif
#endif
