
/*************************************************
****          VEGA - un/packing header        ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


/* Universal data de/compressor engine for VEGA */

#ifndef  __PK_DEF_H
#define  __PK_DEF_H

#ifndef  __GLOBDEF
#include "globdef.h"
#endif

/**** Packing formats ****/

#define  PK_NONE        0       /* None        */
#define  PK_BZ2         1       /* BZip2       */
#define  PK_GZ          2       /* GZip        */
#define  PK_PP          3       /* PowerPacker */
#define  PK_Z           4       /* Z Compress  */

/**** Packer headres in little-endian format ****/

#define  PK_HDR_BZIP2               0x425A6830    /* Bzip2 1-9         */
#define  PK_HDR_COMPRESS            0x1F9D0000    /* Unix Z compress   */
#define  PK_HDR_GZIP                0x1F8B0000    /* GZip magic number */
#define  PK_HDR_POWERPACKER         0x50503230    /* PP20              */
#define  PK_HDR_XPK                 0x58504B46    /* XPKF              */

/**** Global variables ****/

extern const char               *PackerNames[];

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_LONG ChkPackerName(char *, VG_BOOL);
VG_BOOL BZ2_DepackFile(char *, char *);
VG_BOOL BZ2_PackFile(char *, char *);
VG_BOOL GZ_DepackFile(char *, char *);
VG_BOOL GZ_PackFile(char *, char *);
VG_BOOL PP_DepackFile(char *, char *);
VG_BOOL PP_PackFile(char *, char *);
VG_BOOL Z_DepackFile(char *, char *);
VG_BOOL Z_PackFile(char *, char *);

#  ifdef __cplusplus
}
#  endif
#endif
