
/*******************************************
****         VEGA - Preferences         ****
**** (c) 1996-2002, Alessandro Pedretti ****
*******************************************/


#include <stdio.h>
#include <string.h>

#include "globdef.h"
#include "globvar.h"
#include "formats.h"

#define  COM_MOPAC_DEF           0
#define  COM_MOPAC_CRG           1
#define  COM_MOPAC_MMOK          2
#define  COM_SAS_PROBERAD        3
#define  COM_SAS_POINTS          4
#define  COM_OUTFORMAT           5
#define  COM_RENSTART            6
#define  COM_ENERGY_RES          7
#define  COM_ENERGY_CUTOFF       8
#define  COM_ENERGY_FILTER       9
#define  COM_ENERGY_DIEL        10
#define  COM_SOL_RADIUS         11
#define  COM_SOL_SHAPE          12
#define  COM_VOL_DENSITY        13
#define  COM_LANGUAGE           14
#define  COM_MAXATMINFO         15
#define  COM_CONNTOL            16

/**** For OpenGL version ****/

#define  COM_MOPAC_MAXATM       17
#define  COM_CHART_ZOOMFACT     18
#define  COM_SYS_GLASSWIN       19

#define  TOTPREFCOM             20


static char *PrefCom[]     = { "MOPAC_DEF"     ,
                               "MOPAC_CRG"     ,
                               "MOPAC_MMOK"    ,
                               "SAS_PROBERAD"  ,
                               "SAS_POINTS"    ,
                               "OUTFORMAT"     ,
                               "RENSTART"      ,
                               "ENERGY_RES"    ,
                               "ENERGY_CUTOFF" ,
                               "ENERGY_FILTER" ,
                               "ENERGY_DIEL"   ,
                               "SOL_RADIUS"    ,
                               "SOL_SHAPE"     ,
                               "VOL_DENSITY"   ,
                               "LANGUAGE"      ,
                               "MAXATMINFO"    ,
                               "CONNTOL"       ,
                               "MOPAC_MAXATM"  ,
                               "CHART_ZOOMFACT",
                               "GLASSWINDOWS"
                             };

VG_BOOL GetPrefsRes(char *Str)
{
  char          Buf[10], *Ptr;

  VG_BOOL       Ret = FALSE;
  VG_UWORD      k   = strlen(Str);

  if (k < 9) {
    strcpy(Buf, Str);
    if ((Str = strchr(Buf, ':'))) {
      *Str++ = 0;
      if (*Str) {
        Prefs.ENRESNAME.L = 0;
        Prefs.ENRRESSEQ.L = 0;
        k                 = 0;
        for(Ptr = Buf; *Ptr; ++Ptr) {
          Prefs.ENRESNAME.C[k] = *Ptr;
          ++k;
        }
        k = 0;
        for(Ptr = Str; *Ptr; ++Ptr) {
          Prefs.ENRRESSEQ.C[k] = *Ptr;
          ++k;
        }
        Ret = TRUE;
      }
    } else if (k <= 4) {
      Prefs.ENRESNAME.L = 0;
      Prefs.ENRRESSEQ.L = 0;
      k                 = 0;
      for(Ptr = Buf; *Ptr; ++Ptr) {
        Prefs.ENRRESSEQ.C[k] = *Ptr;
        ++k;
      }
      Ret = TRUE;
    }
  }

  return Ret;
}

/**** Preference loader ****/

void LoadPrefs(char *File)
{
  char          Buf[256], Com[256];
  char          *Ptr;
  FILE          *FH;
  float         TmpF;
  VG_LONG       k;
  VG_UWORD      NCom;

  static char	*Opt[] = { "ON", "OFF", "AUTO" };

  if ((FH = fopen(File, "r"))) {
    while(fgets(Buf, 256, FH)) {
      *Com = 0;
      sscanf(Buf, "%s", Com);
      if ((Com) && (*Com != ';') && (*Com != '\n')) {
        for(NCom = 0; (NCom < TOTPREFCOM) && (strcasecmp(Com, PrefCom[NCom])); ++NCom);
        if (NCom < TOTPREFCOM) {
          Buf[strlen(Buf) - 1] = 0;
          switch(NCom) {
          case COM_CONNTOL:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if ((TmpF >= 0.0f) && (TmpF <= 100.0f)) Prefs.CONNTOL = TmpF;
            break;

          case COM_MOPAC_DEF:
            for(Ptr = Buf + strlen(Com); (*Ptr == ' ') || (*Ptr == '\t'); ++Ptr);
            strncpy(Prefs.MOPAC_DEF, Ptr, 79);
            break;

          case COM_MOPAC_CRG:
            sscanf(Buf, "%*s %s", Com);
            if (!strcasecmp(Com, "AUTO")) Prefs.MOPAC_CRG = (VG_WORD)32000;
            else {
              sscanf(Com, "%d", &k);
              Prefs.MOPAC_CRG = (VG_WORD)k;
            }
            break;

          case COM_MOPAC_MAXATM:
            sscanf(Buf, "%*s %d", &k);
            if (k >= 0) Prefs.MOPAC_MAXATM = k;
            break;

          case COM_MOPAC_MMOK:
            sscanf(Buf, "%*s %s", Com);
            for(k = 0; (k < 3) && (strcasecmp(Com, Opt[k])); ++k);
            if (k < 3) Prefs.MOPAC_MMOK = k;
            break;

          case COM_SAS_PROBERAD:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if (TmpF >= 0) Prefs.SAS_PROBERAD = TmpF;
            break;

          case COM_SAS_POINTS:
            k = 0;
            sscanf(Buf, "%*s %d", &k);
            if (k > 0) Prefs.SAS_POINTS = k;
            break;

          case COM_OUTFORMAT:
            sscanf(Buf, "%*s %s", Com);
            for(k = 0;(FileInfo[k].Com) && (strcasecmp(Com, FileInfo[k].Com));++k);
            if (FileInfo[k].Com) Prefs.OUTFORMAT = &FileInfo[k];
            break;

          case COM_RENSTART:
            k = 0;
            sscanf(Buf, "%*s %d", &k);
            if (k > 0) Prefs.RENSTART = k;
            break;

          case COM_ENERGY_RES:
            GetPrefsRes(Buf);
            break;

          case COM_ENERGY_CUTOFF:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if (TmpF >= 0) Prefs.ENCUTOFF = TmpF;
            break;

          case COM_ENERGY_FILTER:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if ((TmpF >= 0) && (TmpF <= 100)) Prefs.ENFILTER = TmpF;
            break;

          case COM_ENERGY_DIEL:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if (TmpF > 0) Prefs.ENDIEL = TmpF;
            break;

          case COM_SOL_RADIUS:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if (TmpF > 0) Prefs.SOL_RAD = TmpF;
            break;

          case COM_SOL_SHAPE:
            sscanf(Buf, "%*s %s", Com);
            for(k = 0;(ShapeType[k]) && (strcasecmp(Com, ShapeType[k]));++k);
            if (ShapeType[k]) Prefs.SOL_SHAPE = k;
            break;

          case COM_VOL_DENSITY:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if (TmpF > 0) Prefs.VOL_DEN = TmpF;
            break;

          case COM_LANGUAGE:
            sscanf(Buf, "%*s %18s", Prefs.LANGUAGE);
            Lower(Prefs.LANGUAGE);
            break;

          case COM_MAXATMINFO:
            k = 0;
            sscanf(Buf, "%*s %d", &k);
            if (k > 0) Prefs.MAXATMINFO = k;
            break;

          case COM_CHART_ZOOMFACT:
            TmpF = 0;
            sscanf(Buf, "%*s %f", &TmpF);
            if (TmpF > 0) Prefs.CHART_ZOOMFACT = TmpF;
            break;

          case COM_SYS_GLASSWIN:
            k = 0;
            sscanf(Buf, "%*s %d", &k);
            if (!k) Prefs.SYS_GLASSWIN = 0;
            else Prefs.SYS_GLASSWIN = 1;
            break;
          } /* End of switch */
        }
      }
    }
    fclose(FH);
  }
}
