
/*************************************************
****         VEGA - Molecular surface         ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VG_SURFACE_H
#  define  __VG_SURFACE_H

#  ifndef __VG_TYPES
#    include "vgtypes.h"
#  endif


/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

XYZ        *CalcSfUn(VG_ULONG, float, VG_ULONG *);
float      CalcSrfArea(ATOMO *, float *, XYZ *, VG_ULONG, TRJPAR *, float, float *, VG_ULONG);
VG_BOOL    CalcSrfPsa(ATOMO *);
VG_SURFACE *SrfAlloc(VG_SURFACE **, VG_ULONG *);
VG_SURFACE *SrfCalc(VG_SURFACE **, VG_ULONG *, ATOMO *, VG_ULONG, VG_ULONG, float, VG_UWORD, float *, VG_ULONG);
void       SrfClose(void);
void       SrfColorByVal(VG_SURFACE *);
VG_SURFACE *SrfCsvLoad(FILE *, VG_ULONG *);
VG_BOOL    SrfCsvSave(FILE *, VG_SURFACE *);
void       SrfFree(VG_SURFACE *);
VG_BOOL    SrfInsightSave(FILE *, char *, VG_SURFACE *, ATOMO *);
VG_SURFACE *SrfInsightLoad(FILE *, VG_ULONG *);
void       SrfName(char *, char *);
ATOMO      **SrfPsaInitCalc(ATOMO *, VG_ULONG);
VG_SURFACE *SrfQuantaLoad(FILE *, VG_ULONG *);
VG_BOOL    SrfQuantaSave(FILE *, char *, VG_SURFACE *Dot, ATOMO *);
void       SrfPsaCalc(VG_SURFACE *, ATOMO **, ATOMO *, VG_ULONG, float *, float *);
void       SrfPrintProg(VG_UWORD);
VG_BOOL    SrfSave(FILE *, char *, VG_SURFACE *, VG_ULONG, ATOMO *, VG_UWORD);
VG_BOOL    SrfRawSave(FILE *, VG_SURFACE *);
VG_BOOL    SrfVrmlSave(FILE *, VG_SURFACE *, VG_BOOL);
VG_BOOL    Surface(FILE *, char *, ATOMO *, VG_ULONG, VG_ULONG, float, VG_UWORD, float *);

#  ifdef __cplusplus
}
#  endif
#endif
